/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying the ingest configuration set up by the broadcaster, usually in an encoder.
 * </p>
 * <p>
 * <b>Note:</b> Use IngestConfigurations instead of <a>IngestConfiguration</a> (which is deprecated). If multitrack is
 * not enabled, IngestConfiguration and IngestConfigurations contain the same data, namely information about track0 (the
 * sole track). If multitrack is enabled, IngestConfiguration contains data for only the first track (track0) and
 * IngestConfigurations contains data for all tracks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestConfigurations.Builder, IngestConfigurations> {
    private static final SdkField<List<AudioConfiguration>> AUDIO_CONFIGURATIONS_FIELD = SdkField
            .<List<AudioConfiguration>> builder(MarshallingType.LIST)
            .memberName("audioConfigurations")
            .getter(getter(IngestConfigurations::audioConfigurations))
            .setter(setter(Builder::audioConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VideoConfiguration>> VIDEO_CONFIGURATIONS_FIELD = SdkField
            .<List<VideoConfiguration>> builder(MarshallingType.LIST)
            .memberName("videoConfigurations")
            .getter(getter(IngestConfigurations::videoConfigurations))
            .setter(setter(Builder::videoConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CONFIGURATIONS_FIELD,
            VIDEO_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AudioConfiguration> audioConfigurations;

    private final List<VideoConfiguration> videoConfigurations;

    private IngestConfigurations(BuilderImpl builder) {
        this.audioConfigurations = builder.audioConfigurations;
        this.videoConfigurations = builder.videoConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudioConfigurations() {
        return audioConfigurations != null && !(audioConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Encoder settings for audio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioConfigurations} method.
     * </p>
     * 
     * @return Encoder settings for audio.
     */
    public final List<AudioConfiguration> audioConfigurations() {
        return audioConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the VideoConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVideoConfigurations() {
        return videoConfigurations != null && !(videoConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Encoder settings for video
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVideoConfigurations} method.
     * </p>
     * 
     * @return Encoder settings for video
     */
    public final List<VideoConfiguration> videoConfigurations() {
        return videoConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioConfigurations() ? audioConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVideoConfigurations() ? videoConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfigurations)) {
            return false;
        }
        IngestConfigurations other = (IngestConfigurations) obj;
        return hasAudioConfigurations() == other.hasAudioConfigurations()
                && Objects.equals(audioConfigurations(), other.audioConfigurations())
                && hasVideoConfigurations() == other.hasVideoConfigurations()
                && Objects.equals(videoConfigurations(), other.videoConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestConfigurations")
                .add("AudioConfigurations", hasAudioConfigurations() ? audioConfigurations() : null)
                .add("VideoConfigurations", hasVideoConfigurations() ? videoConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audioConfigurations":
            return Optional.ofNullable(clazz.cast(audioConfigurations()));
        case "videoConfigurations":
            return Optional.ofNullable(clazz.cast(videoConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioConfigurations", AUDIO_CONFIGURATIONS_FIELD);
        map.put("videoConfigurations", VIDEO_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestConfigurations, T> g) {
        return obj -> g.apply((IngestConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestConfigurations> {
        /**
         * <p>
         * Encoder settings for audio.
         * </p>
         * 
         * @param audioConfigurations
         *        Encoder settings for audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioConfigurations(Collection<AudioConfiguration> audioConfigurations);

        /**
         * <p>
         * Encoder settings for audio.
         * </p>
         * 
         * @param audioConfigurations
         *        Encoder settings for audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioConfigurations(AudioConfiguration... audioConfigurations);

        /**
         * <p>
         * Encoder settings for audio.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivs.model.AudioConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ivs.model.AudioConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivs.model.AudioConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #audioConfigurations(List<AudioConfiguration>)}.
         * 
         * @param audioConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivs.model.AudioConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioConfigurations(java.util.Collection<AudioConfiguration>)
         */
        Builder audioConfigurations(Consumer<AudioConfiguration.Builder>... audioConfigurations);

        /**
         * <p>
         * Encoder settings for video
         * </p>
         * 
         * @param videoConfigurations
         *        Encoder settings for video
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoConfigurations(Collection<VideoConfiguration> videoConfigurations);

        /**
         * <p>
         * Encoder settings for video
         * </p>
         * 
         * @param videoConfigurations
         *        Encoder settings for video
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoConfigurations(VideoConfiguration... videoConfigurations);

        /**
         * <p>
         * Encoder settings for video
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivs.model.VideoConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ivs.model.VideoConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivs.model.VideoConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #videoConfigurations(List<VideoConfiguration>)}.
         * 
         * @param videoConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivs.model.VideoConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoConfigurations(java.util.Collection<VideoConfiguration>)
         */
        Builder videoConfigurations(Consumer<VideoConfiguration.Builder>... videoConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<AudioConfiguration> audioConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<VideoConfiguration> videoConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfigurations model) {
            audioConfigurations(model.audioConfigurations);
            videoConfigurations(model.videoConfigurations);
        }

        public final List<AudioConfiguration.Builder> getAudioConfigurations() {
            List<AudioConfiguration.Builder> result = AudioConfigurationListCopier.copyToBuilder(this.audioConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioConfigurations(Collection<AudioConfiguration.BuilderImpl> audioConfigurations) {
            this.audioConfigurations = AudioConfigurationListCopier.copyFromBuilder(audioConfigurations);
        }

        @Override
        public final Builder audioConfigurations(Collection<AudioConfiguration> audioConfigurations) {
            this.audioConfigurations = AudioConfigurationListCopier.copy(audioConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioConfigurations(AudioConfiguration... audioConfigurations) {
            audioConfigurations(Arrays.asList(audioConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioConfigurations(Consumer<AudioConfiguration.Builder>... audioConfigurations) {
            audioConfigurations(Stream.of(audioConfigurations).map(c -> AudioConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VideoConfiguration.Builder> getVideoConfigurations() {
            List<VideoConfiguration.Builder> result = VideoConfigurationListCopier.copyToBuilder(this.videoConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideoConfigurations(Collection<VideoConfiguration.BuilderImpl> videoConfigurations) {
            this.videoConfigurations = VideoConfigurationListCopier.copyFromBuilder(videoConfigurations);
        }

        @Override
        public final Builder videoConfigurations(Collection<VideoConfiguration> videoConfigurations) {
            this.videoConfigurations = VideoConfigurationListCopier.copy(videoConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoConfigurations(VideoConfiguration... videoConfigurations) {
            videoConfigurations(Arrays.asList(videoConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoConfigurations(Consumer<VideoConfiguration.Builder>... videoConfigurations) {
            videoConfigurations(Stream.of(videoConfigurations).map(c -> VideoConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public IngestConfigurations build() {
            return new IngestConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
