/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamKeysResponse extends IvsResponse implements
        ToCopyableBuilder<ListStreamKeysResponse.Builder, ListStreamKeysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<StreamKeySummary>> STREAM_KEYS_FIELD = SdkField
            .<List<StreamKeySummary>> builder(MarshallingType.LIST)
            .memberName("streamKeys")
            .getter(getter(ListStreamKeysResponse::streamKeys))
            .setter(setter(Builder::streamKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamKeySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamKeySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STREAM_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<StreamKeySummary> streamKeys;

    private ListStreamKeysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamKeys = builder.streamKeys;
    }

    /**
     * <p>
     * If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
     * next set.
     * </p>
     * 
     * @return If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to
     *         get the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StreamKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreamKeys() {
        return streamKeys != null && !(streamKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of stream keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreamKeys} method.
     * </p>
     * 
     * @return List of stream keys.
     */
    public final List<StreamKeySummary> streamKeys() {
        return streamKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamKeys() ? streamKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamKeysResponse)) {
            return false;
        }
        ListStreamKeysResponse other = (ListStreamKeysResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStreamKeys() == other.hasStreamKeys()
                && Objects.equals(streamKeys(), other.streamKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamKeysResponse").add("NextToken", nextToken())
                .add("StreamKeys", hasStreamKeys() ? streamKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "streamKeys":
            return Optional.ofNullable(clazz.cast(streamKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("streamKeys", STREAM_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamKeysResponse, T> g) {
        return obj -> g.apply((ListStreamKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamKeysResponse> {
        /**
         * <p>
         * If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get
         * the next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request
         *        to get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of stream keys.
         * </p>
         * 
         * @param streamKeys
         *        List of stream keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKeys(Collection<StreamKeySummary> streamKeys);

        /**
         * <p>
         * List of stream keys.
         * </p>
         * 
         * @param streamKeys
         *        List of stream keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKeys(StreamKeySummary... streamKeys);

        /**
         * <p>
         * List of stream keys.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivs.model.StreamKeySummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ivs.model.StreamKeySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivs.model.StreamKeySummary.Builder#build()} is called immediately and
         * its result is passed to {@link #streamKeys(List<StreamKeySummary>)}.
         * 
         * @param streamKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivs.model.StreamKeySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamKeys(java.util.Collection<StreamKeySummary>)
         */
        Builder streamKeys(Consumer<StreamKeySummary.Builder>... streamKeys);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StreamKeySummary> streamKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamKeysResponse model) {
            super(model);
            nextToken(model.nextToken);
            streamKeys(model.streamKeys);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamKeySummary.Builder> getStreamKeys() {
            List<StreamKeySummary.Builder> result = StreamKeyListCopier.copyToBuilder(this.streamKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamKeys(Collection<StreamKeySummary.BuilderImpl> streamKeys) {
            this.streamKeys = StreamKeyListCopier.copyFromBuilder(streamKeys);
        }

        @Override
        public final Builder streamKeys(Collection<StreamKeySummary> streamKeys) {
            this.streamKeys = StreamKeyListCopier.copy(streamKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamKeys(StreamKeySummary... streamKeys) {
            streamKeys(Arrays.asList(streamKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamKeys(Consumer<StreamKeySummary.Builder>... streamKeys) {
            streamKeys(Stream.of(streamKeys).map(c -> StreamKeySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamKeysResponse build() {
            return new ListStreamKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
