/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies multitrack input configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultitrackInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MultitrackInputConfiguration.Builder, MultitrackInputConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(MultitrackInputConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> MAXIMUM_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("maximumResolution").getter(getter(MultitrackInputConfiguration::maximumResolutionAsString))
            .setter(setter(Builder::maximumResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumResolution").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(MultitrackInputConfiguration::policyAsString)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MAXIMUM_RESOLUTION_FIELD, POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String maximumResolution;

    private final String policy;

    private MultitrackInputConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maximumResolution = builder.maximumResolution;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * Indicates whether multitrack input is enabled. Can be set to <code>true</code> only if channel type is
     * <code>STANDARD</code>. Setting <code>enabled</code> to <code>true</code> with any other channel type will cause
     * an exception. If <code>true</code>, then <code>policy</code>, <code>maximumResolution</code>, and
     * <code>containerFormat</code> are required, and <code>containerFormat</code> must be set to
     * <code>FRAGMENTED_MP4</code>. Default: <code>false</code>.
     * </p>
     * 
     * @return Indicates whether multitrack input is enabled. Can be set to <code>true</code> only if channel type is
     *         <code>STANDARD</code>. Setting <code>enabled</code> to <code>true</code> with any other channel type will
     *         cause an exception. If <code>true</code>, then <code>policy</code>, <code>maximumResolution</code>, and
     *         <code>containerFormat</code> are required, and <code>containerFormat</code> must be set to
     *         <code>FRAGMENTED_MP4</code>. Default: <code>false</code>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumResolution}
     * will return {@link MultitrackMaximumResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumResolutionAsString}.
     * </p>
     * 
     * @return Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
     * @see MultitrackMaximumResolution
     */
    public final MultitrackMaximumResolution maximumResolution() {
        return MultitrackMaximumResolution.fromValue(maximumResolution);
    }

    /**
     * <p>
     * Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumResolution}
     * will return {@link MultitrackMaximumResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumResolutionAsString}.
     * </p>
     * 
     * @return Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
     * @see MultitrackMaximumResolution
     */
    public final String maximumResolutionAsString() {
        return maximumResolution;
    }

    /**
     * <p>
     * Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policy} will
     * return {@link MultitrackPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyAsString}.
     * </p>
     * 
     * @return Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is
     *         <code>true</code>.
     * @see MultitrackPolicy
     */
    public final MultitrackPolicy policy() {
        return MultitrackPolicy.fromValue(policy);
    }

    /**
     * <p>
     * Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policy} will
     * return {@link MultitrackPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyAsString}.
     * </p>
     * 
     * @return Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is
     *         <code>true</code>.
     * @see MultitrackPolicy
     */
    public final String policyAsString() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(maximumResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultitrackInputConfiguration)) {
            return false;
        }
        MultitrackInputConfiguration other = (MultitrackInputConfiguration) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(maximumResolutionAsString(), other.maximumResolutionAsString())
                && Objects.equals(policyAsString(), other.policyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultitrackInputConfiguration").add("Enabled", enabled())
                .add("MaximumResolution", maximumResolutionAsString()).add("Policy", policyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "maximumResolution":
            return Optional.ofNullable(clazz.cast(maximumResolutionAsString()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("maximumResolution", MAXIMUM_RESOLUTION_FIELD);
        map.put("policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultitrackInputConfiguration, T> g) {
        return obj -> g.apply((MultitrackInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultitrackInputConfiguration> {
        /**
         * <p>
         * Indicates whether multitrack input is enabled. Can be set to <code>true</code> only if channel type is
         * <code>STANDARD</code>. Setting <code>enabled</code> to <code>true</code> with any other channel type will
         * cause an exception. If <code>true</code>, then <code>policy</code>, <code>maximumResolution</code>, and
         * <code>containerFormat</code> are required, and <code>containerFormat</code> must be set to
         * <code>FRAGMENTED_MP4</code>. Default: <code>false</code>.
         * </p>
         * 
         * @param enabled
         *        Indicates whether multitrack input is enabled. Can be set to <code>true</code> only if channel type is
         *        <code>STANDARD</code>. Setting <code>enabled</code> to <code>true</code> with any other channel type
         *        will cause an exception. If <code>true</code>, then <code>policy</code>,
         *        <code>maximumResolution</code>, and <code>containerFormat</code> are required, and
         *        <code>containerFormat</code> must be set to <code>FRAGMENTED_MP4</code>. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
         * </p>
         * 
         * @param maximumResolution
         *        Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
         * @see MultitrackMaximumResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultitrackMaximumResolution
         */
        Builder maximumResolution(String maximumResolution);

        /**
         * <p>
         * Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
         * </p>
         * 
         * @param maximumResolution
         *        Maximum resolution for multitrack input. Required if <code>enabled</code> is <code>true</code>.
         * @see MultitrackMaximumResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultitrackMaximumResolution
         */
        Builder maximumResolution(MultitrackMaximumResolution maximumResolution);

        /**
         * <p>
         * Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is
         * <code>true</code>.
         * </p>
         * 
         * @param policy
         *        Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is
         *        <code>true</code>.
         * @see MultitrackPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultitrackPolicy
         */
        Builder policy(String policy);

        /**
         * <p>
         * Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is
         * <code>true</code>.
         * </p>
         * 
         * @param policy
         *        Indicates whether multitrack input is allowed or required. Required if <code>enabled</code> is
         *        <code>true</code>.
         * @see MultitrackPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultitrackPolicy
         */
        Builder policy(MultitrackPolicy policy);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String maximumResolution;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(MultitrackInputConfiguration model) {
            enabled(model.enabled);
            maximumResolution(model.maximumResolution);
            policy(model.policy);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getMaximumResolution() {
            return maximumResolution;
        }

        public final void setMaximumResolution(String maximumResolution) {
            this.maximumResolution = maximumResolution;
        }

        @Override
        public final Builder maximumResolution(String maximumResolution) {
            this.maximumResolution = maximumResolution;
            return this;
        }

        @Override
        public final Builder maximumResolution(MultitrackMaximumResolution maximumResolution) {
            this.maximumResolution(maximumResolution == null ? null : maximumResolution.toString());
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder policy(MultitrackPolicy policy) {
            this.policy(policy == null ? null : policy.toString());
            return this;
        }

        @Override
        public MultitrackInputConfiguration build() {
            return new MultitrackInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
