/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key pair used to sign and validate a playback authorization token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlaybackKeyPair implements SdkPojo, Serializable, ToCopyableBuilder<PlaybackKeyPair.Builder, PlaybackKeyPair> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(PlaybackKeyPair::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fingerprint").getter(getter(PlaybackKeyPair::fingerprint)).setter(setter(Builder::fingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fingerprint").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PlaybackKeyPair::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PlaybackKeyPair::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FINGERPRINT_FIELD,
            NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String fingerprint;

    private final String name;

    private final Map<String, String> tags;

    private PlaybackKeyPair(BuilderImpl builder) {
        this.arn = builder.arn;
        this.fingerprint = builder.fingerprint;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Key-pair ARN.
     * </p>
     * 
     * @return Key-pair ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Key-pair identifier.
     * </p>
     * 
     * @return Key-pair identifier.
     */
    public final String fingerprint() {
        return fingerprint;
    }

    /**
     * <p>
     * Playback-key-pair name. The value does not need to be unique.
     * </p>
     * 
     * @return Playback-key-pair name. The value does not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See
     * <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
     * and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details, including
     * restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific
     * constraints beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of 1-50 maps, each of the form
     *         <code>string:string (key:value)</code>. See <a
     *         href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details,
     *         including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
     *         service-specific constraints beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackKeyPair)) {
            return false;
        }
        PlaybackKeyPair other = (PlaybackKeyPair) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(fingerprint(), other.fingerprint())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlaybackKeyPair").add("Arn", arn()).add("Fingerprint", fingerprint()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "fingerprint":
            return Optional.ofNullable(clazz.cast(fingerprint()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("fingerprint", FINGERPRINT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlaybackKeyPair, T> g) {
        return obj -> g.apply((PlaybackKeyPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlaybackKeyPair> {
        /**
         * <p>
         * Key-pair ARN.
         * </p>
         * 
         * @param arn
         *        Key-pair ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Key-pair identifier.
         * </p>
         * 
         * @param fingerprint
         *        Key-pair identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fingerprint(String fingerprint);

        /**
         * <p>
         * Playback-key-pair name. The value does not need to be unique.
         * </p>
         * 
         * @param name
         *        Playback-key-pair name. The value does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         * practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details,
         * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         * service-specific constraints beyond what is documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of 1-50 maps, each of the form
         *        <code>string:string (key:value)</code>. See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for
         *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
         *        IVS has no service-specific constraints beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String fingerprint;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlaybackKeyPair model) {
            arn(model.arn);
            fingerprint(model.fingerprint);
            name(model.name);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFingerprint() {
            return fingerprint;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public PlaybackKeyPair build() {
            return new PlaybackKeyPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
