/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that describes which renditions should be recorded for a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenditionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RenditionConfiguration.Builder, RenditionConfiguration> {
    private static final SdkField<String> RENDITION_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("renditionSelection").getter(getter(RenditionConfiguration::renditionSelectionAsString))
            .setter(setter(Builder::renditionSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionSelection").build())
            .build();

    private static final SdkField<List<String>> RENDITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("renditions")
            .getter(getter(RenditionConfiguration::renditionsAsStrings))
            .setter(setter(Builder::renditionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDITION_SELECTION_FIELD,
            RENDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String renditionSelection;

    private final List<String> renditions;

    private RenditionConfiguration(BuilderImpl builder) {
        this.renditionSelection = builder.renditionSelection;
        this.renditions = builder.renditions;
    }

    /**
     * <p>
     * Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
     * <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be
     * specified in the <code>renditions</code> field. Default: <code>ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #renditionSelection} will return {@link RenditionConfigurationRenditionSelection#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #renditionSelectionAsString}.
     * </p>
     * 
     * @return Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
     *         <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be
     *         specified in the <code>renditions</code> field. Default: <code>ALL</code>.
     * @see RenditionConfigurationRenditionSelection
     */
    public final RenditionConfigurationRenditionSelection renditionSelection() {
        return RenditionConfigurationRenditionSelection.fromValue(renditionSelection);
    }

    /**
     * <p>
     * Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
     * <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be
     * specified in the <code>renditions</code> field. Default: <code>ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #renditionSelection} will return {@link RenditionConfigurationRenditionSelection#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #renditionSelectionAsString}.
     * </p>
     * 
     * @return Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
     *         <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be
     *         specified in the <code>renditions</code> field. Default: <code>ALL</code>.
     * @see RenditionConfigurationRenditionSelection
     */
    public final String renditionSelectionAsString() {
        return renditionSelection;
    }

    /**
     * <p>
     * Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is <code>CUSTOM</code>;
     * otherwise, this field is irrelevant. The selected renditions are recorded if they are available during the
     * stream. If a selected rendition is unavailable, the best available rendition is recorded. For details on the
     * resolution dimensions of each rendition, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRenditions} method.
     * </p>
     * 
     * @return Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
     *         <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they
     *         are available during the stream. If a selected rendition is unavailable, the best available rendition is
     *         recorded. For details on the resolution dimensions of each rendition, see <a
     *         href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
     */
    public final List<RenditionConfigurationRendition> renditions() {
        return RenditionConfigurationRenditionListCopier.copyStringToEnum(renditions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Renditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRenditions() {
        return renditions != null && !(renditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is <code>CUSTOM</code>;
     * otherwise, this field is irrelevant. The selected renditions are recorded if they are available during the
     * stream. If a selected rendition is unavailable, the best available rendition is recorded. For details on the
     * resolution dimensions of each rendition, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRenditions} method.
     * </p>
     * 
     * @return Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
     *         <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they
     *         are available during the stream. If a selected rendition is unavailable, the best available rendition is
     *         recorded. For details on the resolution dimensions of each rendition, see <a
     *         href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
     */
    public final List<String> renditionsAsStrings() {
        return renditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renditionSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRenditions() ? renditionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenditionConfiguration)) {
            return false;
        }
        RenditionConfiguration other = (RenditionConfiguration) obj;
        return Objects.equals(renditionSelectionAsString(), other.renditionSelectionAsString())
                && hasRenditions() == other.hasRenditions() && Objects.equals(renditionsAsStrings(), other.renditionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenditionConfiguration").add("RenditionSelection", renditionSelectionAsString())
                .add("Renditions", hasRenditions() ? renditionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "renditionSelection":
            return Optional.ofNullable(clazz.cast(renditionSelectionAsString()));
        case "renditions":
            return Optional.ofNullable(clazz.cast(renditionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("renditionSelection", RENDITION_SELECTION_FIELD);
        map.put("renditions", RENDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenditionConfiguration, T> g) {
        return obj -> g.apply((RenditionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenditionConfiguration> {
        /**
         * <p>
         * Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
         * <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be
         * specified in the <code>renditions</code> field. Default: <code>ALL</code>.
         * </p>
         * 
         * @param renditionSelection
         *        Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
         *        <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must
         *        be specified in the <code>renditions</code> field. Default: <code>ALL</code>.
         * @see RenditionConfigurationRenditionSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenditionConfigurationRenditionSelection
         */
        Builder renditionSelection(String renditionSelection);

        /**
         * <p>
         * Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
         * <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be
         * specified in the <code>renditions</code> field. Default: <code>ALL</code>.
         * </p>
         * 
         * @param renditionSelection
         *        Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the
         *        <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must
         *        be specified in the <code>renditions</code> field. Default: <code>ALL</code>.
         * @see RenditionConfigurationRenditionSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenditionConfigurationRenditionSelection
         */
        Builder renditionSelection(RenditionConfigurationRenditionSelection renditionSelection);

        /**
         * <p>
         * Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         * <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they are
         * available during the stream. If a selected rendition is unavailable, the best available rendition is
         * recorded. For details on the resolution dimensions of each rendition, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
         * </p>
         * 
         * @param renditions
         *        Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         *        <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they
         *        are available during the stream. If a selected rendition is unavailable, the best available rendition
         *        is recorded. For details on the resolution dimensions of each rendition, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         *        S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditionsWithStrings(Collection<String> renditions);

        /**
         * <p>
         * Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         * <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they are
         * available during the stream. If a selected rendition is unavailable, the best available rendition is
         * recorded. For details on the resolution dimensions of each rendition, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
         * </p>
         * 
         * @param renditions
         *        Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         *        <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they
         *        are available during the stream. If a selected rendition is unavailable, the best available rendition
         *        is recorded. For details on the resolution dimensions of each rendition, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         *        S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditionsWithStrings(String... renditions);

        /**
         * <p>
         * Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         * <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they are
         * available during the stream. If a selected rendition is unavailable, the best available rendition is
         * recorded. For details on the resolution dimensions of each rendition, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
         * </p>
         * 
         * @param renditions
         *        Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         *        <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they
         *        are available during the stream. If a selected rendition is unavailable, the best available rendition
         *        is recorded. For details on the resolution dimensions of each rendition, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         *        S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditions(Collection<RenditionConfigurationRendition> renditions);

        /**
         * <p>
         * Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         * <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they are
         * available during the stream. If a selected rendition is unavailable, the best available rendition is
         * recorded. For details on the resolution dimensions of each rendition, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.
         * </p>
         * 
         * @param renditions
         *        Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is
         *        <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they
         *        are available during the stream. If a selected rendition is unavailable, the best available rendition
         *        is recorded. For details on the resolution dimensions of each rendition, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         *        S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditions(RenditionConfigurationRendition... renditions);
    }

    static final class BuilderImpl implements Builder {
        private String renditionSelection;

        private List<String> renditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenditionConfiguration model) {
            renditionSelection(model.renditionSelection);
            renditionsWithStrings(model.renditions);
        }

        public final String getRenditionSelection() {
            return renditionSelection;
        }

        public final void setRenditionSelection(String renditionSelection) {
            this.renditionSelection = renditionSelection;
        }

        @Override
        public final Builder renditionSelection(String renditionSelection) {
            this.renditionSelection = renditionSelection;
            return this;
        }

        @Override
        public final Builder renditionSelection(RenditionConfigurationRenditionSelection renditionSelection) {
            this.renditionSelection(renditionSelection == null ? null : renditionSelection.toString());
            return this;
        }

        public final Collection<String> getRenditions() {
            if (renditions instanceof SdkAutoConstructList) {
                return null;
            }
            return renditions;
        }

        public final void setRenditions(Collection<String> renditions) {
            this.renditions = RenditionConfigurationRenditionListCopier.copy(renditions);
        }

        @Override
        public final Builder renditionsWithStrings(Collection<String> renditions) {
            this.renditions = RenditionConfigurationRenditionListCopier.copy(renditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renditionsWithStrings(String... renditions) {
            renditionsWithStrings(Arrays.asList(renditions));
            return this;
        }

        @Override
        public final Builder renditions(Collection<RenditionConfigurationRendition> renditions) {
            this.renditions = RenditionConfigurationRenditionListCopier.copyEnumToString(renditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renditions(RenditionConfigurationRendition... renditions) {
            renditions(Arrays.asList(renditions));
            return this;
        }

        @Override
        public RenditionConfiguration build() {
            return new RenditionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
