/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a stream session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamSessionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamSessionSummary.Builder, StreamSessionSummary> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(StreamSessionSummary::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> HAS_ERROR_EVENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasErrorEvent").getter(getter(StreamSessionSummary::hasErrorEvent))
            .setter(setter(Builder::hasErrorEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasErrorEvent").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(StreamSessionSummary::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamId").getter(getter(StreamSessionSummary::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            HAS_ERROR_EVENT_FIELD, START_TIME_FIELD, STREAM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final Boolean hasErrorEvent;

    private final Instant startTime;

    private final String streamId;

    private StreamSessionSummary(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.hasErrorEvent = builder.hasErrorEvent;
        this.startTime = builder.startTime;
        this.streamId = builder.streamId;
    }

    /**
     * <p>
     * Time when the channel went offline. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * For live streams, this is <code>NULL</code>.
     * </p>
     * 
     * @return Time when the channel went offline. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>. For live streams, this is <code>NULL</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * If <code>true</code>, this stream encountered a quota breach or failure.
     * </p>
     * 
     * @return If <code>true</code>, this stream encountered a quota breach or failure.
     */
    public final Boolean hasErrorEvent() {
        return hasErrorEvent;
    }

    /**
     * <p>
     * Time when the channel went live. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time when the channel went live. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Unique identifier for a live or previously live stream in the specified channel.
     * </p>
     * 
     * @return Unique identifier for a live or previously live stream in the specified channel.
     */
    public final String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorEvent());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSessionSummary)) {
            return false;
        }
        StreamSessionSummary other = (StreamSessionSummary) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(hasErrorEvent(), other.hasErrorEvent())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamSessionSummary").add("EndTime", endTime()).add("HasErrorEvent", hasErrorEvent())
                .add("StartTime", startTime()).add("StreamId", streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "hasErrorEvent":
            return Optional.ofNullable(clazz.cast(hasErrorEvent()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "streamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endTime", END_TIME_FIELD);
        map.put("hasErrorEvent", HAS_ERROR_EVENT_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamSessionSummary, T> g) {
        return obj -> g.apply((StreamSessionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamSessionSummary> {
        /**
         * <p>
         * Time when the channel went offline. This is an ISO 8601 timestamp; <i>note that this is returned as a
         * string</i>. For live streams, this is <code>NULL</code>.
         * </p>
         * 
         * @param endTime
         *        Time when the channel went offline. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>. For live streams, this is <code>NULL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * If <code>true</code>, this stream encountered a quota breach or failure.
         * </p>
         * 
         * @param hasErrorEvent
         *        If <code>true</code>, this stream encountered a quota breach or failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasErrorEvent(Boolean hasErrorEvent);

        /**
         * <p>
         * Time when the channel went live. This is an ISO 8601 timestamp; <i>note that this is returned as a
         * string</i>.
         * </p>
         * 
         * @param startTime
         *        Time when the channel went live. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Unique identifier for a live or previously live stream in the specified channel.
         * </p>
         * 
         * @param streamId
         *        Unique identifier for a live or previously live stream in the specified channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private Boolean hasErrorEvent;

        private Instant startTime;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSessionSummary model) {
            endTime(model.endTime);
            hasErrorEvent(model.hasErrorEvent);
            startTime(model.startTime);
            streamId(model.streamId);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getHasErrorEvent() {
            return hasErrorEvent;
        }

        public final void setHasErrorEvent(Boolean hasErrorEvent) {
            this.hasErrorEvent = hasErrorEvent;
        }

        @Override
        public final Builder hasErrorEvent(Boolean hasErrorEvent) {
            this.hasErrorEvent = hasErrorEvent;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public StreamSessionSummary build() {
            return new StreamSessionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
