/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a stream’s video configuration, as set up by the broadcaster (usually in an encoder). This is part
 * of the <a>IngestConfigurations</a> object and the deprecated <a>IngestConfiguration</a> object. It is used for
 * monitoring stream health.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoConfiguration.Builder, VideoConfiguration> {
    private static final SdkField<String> AVC_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("avcLevel").getter(getter(VideoConfiguration::avcLevel)).setter(setter(Builder::avcLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("avcLevel").build()).build();

    private static final SdkField<String> AVC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("avcProfile").getter(getter(VideoConfiguration::avcProfile)).setter(setter(Builder::avcProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("avcProfile").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("codec")
            .getter(getter(VideoConfiguration::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<String> ENCODER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("encoder")
            .getter(getter(VideoConfiguration::encoder)).setter(setter(Builder::encoder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoder").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("level")
            .getter(getter(VideoConfiguration::level)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("profile")
            .getter(getter(VideoConfiguration::profile)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<Long> TARGET_BITRATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("targetBitrate").getter(getter(VideoConfiguration::targetBitrate)).setter(setter(Builder::targetBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBitrate").build()).build();

    private static final SdkField<Long> TARGET_FRAMERATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("targetFramerate").getter(getter(VideoConfiguration::targetFramerate))
            .setter(setter(Builder::targetFramerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFramerate").build()).build();

    private static final SdkField<String> TRACK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("track")
            .getter(getter(VideoConfiguration::track)).setter(setter(Builder::track))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("track").build()).build();

    private static final SdkField<Long> VIDEO_HEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("videoHeight").getter(getter(VideoConfiguration::videoHeight)).setter(setter(Builder::videoHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoHeight").build()).build();

    private static final SdkField<Long> VIDEO_WIDTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("videoWidth").getter(getter(VideoConfiguration::videoWidth)).setter(setter(Builder::videoWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVC_LEVEL_FIELD,
            AVC_PROFILE_FIELD, CODEC_FIELD, ENCODER_FIELD, LEVEL_FIELD, PROFILE_FIELD, TARGET_BITRATE_FIELD,
            TARGET_FRAMERATE_FIELD, TRACK_FIELD, VIDEO_HEIGHT_FIELD, VIDEO_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String avcLevel;

    private final String avcProfile;

    private final String codec;

    private final String encoder;

    private final String level;

    private final String profile;

    private final Long targetBitrate;

    private final Long targetFramerate;

    private final String track;

    private final Long videoHeight;

    private final Long videoWidth;

    private VideoConfiguration(BuilderImpl builder) {
        this.avcLevel = builder.avcLevel;
        this.avcProfile = builder.avcProfile;
        this.codec = builder.codec;
        this.encoder = builder.encoder;
        this.level = builder.level;
        this.profile = builder.profile;
        this.targetBitrate = builder.targetBitrate;
        this.targetFramerate = builder.targetFramerate;
        this.track = builder.track;
        this.videoHeight = builder.videoHeight;
        this.videoWidth = builder.videoWidth;
    }

    /**
     * <p>
     * Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the
     * encoder. For details, see the H.264 specification.
     * </p>
     * 
     * @return Indicates the degree of required decoder performance for a profile. Normally this is set automatically by
     *         the encoder. For details, see the H.264 specification.
     */
    public final String avcLevel() {
        return avcLevel;
    }

    /**
     * <p>
     * Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values, see the
     * H.264 specification.
     * </p>
     * 
     * @return Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values,
     *         see the H.264 specification.
     */
    public final String avcProfile() {
        return avcProfile;
    }

    /**
     * <p>
     * Codec used for the video encoding.
     * </p>
     * 
     * @return Codec used for the video encoding.
     */
    public final String codec() {
        return codec;
    }

    /**
     * <p>
     * Software or hardware used to encode the video.
     * </p>
     * 
     * @return Software or hardware used to encode the video.
     */
    public final String encoder() {
        return encoder;
    }

    /**
     * <p>
     * Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the
     * encoder. When an AVC codec is used, this field has the same value as <code>avcLevel</code>.
     * </p>
     * 
     * @return Indicates the degree of required decoder performance for a profile. Normally this is set automatically by
     *         the encoder. When an AVC codec is used, this field has the same value as <code>avcLevel</code>.
     */
    public final String level() {
        return level;
    }

    /**
     * <p>
     * Indicates to the decoder the requirements for decoding the stream. When an AVC codec is used, this field has the
     * same value as <code>avcProfile</code>.
     * </p>
     * 
     * @return Indicates to the decoder the requirements for decoding the stream. When an AVC codec is used, this field
     *         has the same value as <code>avcProfile</code>.
     */
    public final String profile() {
        return profile;
    }

    /**
     * <p>
     * The expected ingest bitrate (bits per second). This is configured in the encoder.
     * </p>
     * 
     * @return The expected ingest bitrate (bits per second). This is configured in the encoder.
     */
    public final Long targetBitrate() {
        return targetBitrate;
    }

    /**
     * <p>
     * The expected ingest framerate. This is configured in the encoder.
     * </p>
     * 
     * @return The expected ingest framerate. This is configured in the encoder.
     */
    public final Long targetFramerate() {
        return targetFramerate;
    }

    /**
     * <p>
     * Name of the video track. If multitrack is not enabled, this is track0 (the sole track).
     * </p>
     * 
     * @return Name of the video track. If multitrack is not enabled, this is track0 (the sole track).
     */
    public final String track() {
        return track;
    }

    /**
     * <p>
     * Video-resolution height in pixels.
     * </p>
     * 
     * @return Video-resolution height in pixels.
     */
    public final Long videoHeight() {
        return videoHeight;
    }

    /**
     * <p>
     * Video-resolution width in pixels.
     * </p>
     * 
     * @return Video-resolution width in pixels.
     */
    public final Long videoWidth() {
        return videoWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(avcLevel());
        hashCode = 31 * hashCode + Objects.hashCode(avcProfile());
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(encoder());
        hashCode = 31 * hashCode + Objects.hashCode(level());
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        hashCode = 31 * hashCode + Objects.hashCode(targetBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(targetFramerate());
        hashCode = 31 * hashCode + Objects.hashCode(track());
        hashCode = 31 * hashCode + Objects.hashCode(videoHeight());
        hashCode = 31 * hashCode + Objects.hashCode(videoWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoConfiguration)) {
            return false;
        }
        VideoConfiguration other = (VideoConfiguration) obj;
        return Objects.equals(avcLevel(), other.avcLevel()) && Objects.equals(avcProfile(), other.avcProfile())
                && Objects.equals(codec(), other.codec()) && Objects.equals(encoder(), other.encoder())
                && Objects.equals(level(), other.level()) && Objects.equals(profile(), other.profile())
                && Objects.equals(targetBitrate(), other.targetBitrate())
                && Objects.equals(targetFramerate(), other.targetFramerate()) && Objects.equals(track(), other.track())
                && Objects.equals(videoHeight(), other.videoHeight()) && Objects.equals(videoWidth(), other.videoWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoConfiguration").add("AvcLevel", avcLevel()).add("AvcProfile", avcProfile())
                .add("Codec", codec()).add("Encoder", encoder()).add("Level", level()).add("Profile", profile())
                .add("TargetBitrate", targetBitrate()).add("TargetFramerate", targetFramerate()).add("Track", track())
                .add("VideoHeight", videoHeight()).add("VideoWidth", videoWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "avcLevel":
            return Optional.ofNullable(clazz.cast(avcLevel()));
        case "avcProfile":
            return Optional.ofNullable(clazz.cast(avcProfile()));
        case "codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "encoder":
            return Optional.ofNullable(clazz.cast(encoder()));
        case "level":
            return Optional.ofNullable(clazz.cast(level()));
        case "profile":
            return Optional.ofNullable(clazz.cast(profile()));
        case "targetBitrate":
            return Optional.ofNullable(clazz.cast(targetBitrate()));
        case "targetFramerate":
            return Optional.ofNullable(clazz.cast(targetFramerate()));
        case "track":
            return Optional.ofNullable(clazz.cast(track()));
        case "videoHeight":
            return Optional.ofNullable(clazz.cast(videoHeight()));
        case "videoWidth":
            return Optional.ofNullable(clazz.cast(videoWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("avcLevel", AVC_LEVEL_FIELD);
        map.put("avcProfile", AVC_PROFILE_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("encoder", ENCODER_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("profile", PROFILE_FIELD);
        map.put("targetBitrate", TARGET_BITRATE_FIELD);
        map.put("targetFramerate", TARGET_FRAMERATE_FIELD);
        map.put("track", TRACK_FIELD);
        map.put("videoHeight", VIDEO_HEIGHT_FIELD);
        map.put("videoWidth", VIDEO_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoConfiguration, T> g) {
        return obj -> g.apply((VideoConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoConfiguration> {
        /**
         * <p>
         * Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the
         * encoder. For details, see the H.264 specification.
         * </p>
         * 
         * @param avcLevel
         *        Indicates the degree of required decoder performance for a profile. Normally this is set automatically
         *        by the encoder. For details, see the H.264 specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avcLevel(String avcLevel);

        /**
         * <p>
         * Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values, see
         * the H.264 specification.
         * </p>
         * 
         * @param avcProfile
         *        Indicates to the decoder the requirements for decoding the stream. For definitions of the valid
         *        values, see the H.264 specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avcProfile(String avcProfile);

        /**
         * <p>
         * Codec used for the video encoding.
         * </p>
         * 
         * @param codec
         *        Codec used for the video encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * <p>
         * Software or hardware used to encode the video.
         * </p>
         * 
         * @param encoder
         *        Software or hardware used to encode the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoder(String encoder);

        /**
         * <p>
         * Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the
         * encoder. When an AVC codec is used, this field has the same value as <code>avcLevel</code>.
         * </p>
         * 
         * @param level
         *        Indicates the degree of required decoder performance for a profile. Normally this is set automatically
         *        by the encoder. When an AVC codec is used, this field has the same value as <code>avcLevel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level(String level);

        /**
         * <p>
         * Indicates to the decoder the requirements for decoding the stream. When an AVC codec is used, this field has
         * the same value as <code>avcProfile</code>.
         * </p>
         * 
         * @param profile
         *        Indicates to the decoder the requirements for decoding the stream. When an AVC codec is used, this
         *        field has the same value as <code>avcProfile</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(String profile);

        /**
         * <p>
         * The expected ingest bitrate (bits per second). This is configured in the encoder.
         * </p>
         * 
         * @param targetBitrate
         *        The expected ingest bitrate (bits per second). This is configured in the encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBitrate(Long targetBitrate);

        /**
         * <p>
         * The expected ingest framerate. This is configured in the encoder.
         * </p>
         * 
         * @param targetFramerate
         *        The expected ingest framerate. This is configured in the encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFramerate(Long targetFramerate);

        /**
         * <p>
         * Name of the video track. If multitrack is not enabled, this is track0 (the sole track).
         * </p>
         * 
         * @param track
         *        Name of the video track. If multitrack is not enabled, this is track0 (the sole track).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder track(String track);

        /**
         * <p>
         * Video-resolution height in pixels.
         * </p>
         * 
         * @param videoHeight
         *        Video-resolution height in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoHeight(Long videoHeight);

        /**
         * <p>
         * Video-resolution width in pixels.
         * </p>
         * 
         * @param videoWidth
         *        Video-resolution width in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoWidth(Long videoWidth);
    }

    static final class BuilderImpl implements Builder {
        private String avcLevel;

        private String avcProfile;

        private String codec;

        private String encoder;

        private String level;

        private String profile;

        private Long targetBitrate;

        private Long targetFramerate;

        private String track;

        private Long videoHeight;

        private Long videoWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoConfiguration model) {
            avcLevel(model.avcLevel);
            avcProfile(model.avcProfile);
            codec(model.codec);
            encoder(model.encoder);
            level(model.level);
            profile(model.profile);
            targetBitrate(model.targetBitrate);
            targetFramerate(model.targetFramerate);
            track(model.track);
            videoHeight(model.videoHeight);
            videoWidth(model.videoWidth);
        }

        public final String getAvcLevel() {
            return avcLevel;
        }

        public final void setAvcLevel(String avcLevel) {
            this.avcLevel = avcLevel;
        }

        @Override
        public final Builder avcLevel(String avcLevel) {
            this.avcLevel = avcLevel;
            return this;
        }

        public final String getAvcProfile() {
            return avcProfile;
        }

        public final void setAvcProfile(String avcProfile) {
            this.avcProfile = avcProfile;
        }

        @Override
        public final Builder avcProfile(String avcProfile) {
            this.avcProfile = avcProfile;
            return this;
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final String getEncoder() {
            return encoder;
        }

        public final void setEncoder(String encoder) {
            this.encoder = encoder;
        }

        @Override
        public final Builder encoder(String encoder) {
            this.encoder = encoder;
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public final Long getTargetBitrate() {
            return targetBitrate;
        }

        public final void setTargetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
        }

        @Override
        public final Builder targetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
            return this;
        }

        public final Long getTargetFramerate() {
            return targetFramerate;
        }

        public final void setTargetFramerate(Long targetFramerate) {
            this.targetFramerate = targetFramerate;
        }

        @Override
        public final Builder targetFramerate(Long targetFramerate) {
            this.targetFramerate = targetFramerate;
            return this;
        }

        public final String getTrack() {
            return track;
        }

        public final void setTrack(String track) {
            this.track = track;
        }

        @Override
        public final Builder track(String track) {
            this.track = track;
            return this;
        }

        public final Long getVideoHeight() {
            return videoHeight;
        }

        public final void setVideoHeight(Long videoHeight) {
            this.videoHeight = videoHeight;
        }

        @Override
        public final Builder videoHeight(Long videoHeight) {
            this.videoHeight = videoHeight;
            return this;
        }

        public final Long getVideoWidth() {
            return videoWidth;
        }

        public final void setVideoWidth(Long videoWidth) {
            this.videoWidth = videoWidth;
        }

        @Override
        public final Builder videoWidth(Long videoWidth) {
            this.videoWidth = videoWidth;
            return this;
        }

        @Override
        public VideoConfiguration build() {
            return new VideoConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
