/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioConfiguration> {
    private static final SdkField<Long> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("channels").getter(AudioConfiguration.getter(AudioConfiguration::channels)).setter(AudioConfiguration.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codec").getter(AudioConfiguration.getter(AudioConfiguration::codec)).setter(AudioConfiguration.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<Long> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("sampleRate").getter(AudioConfiguration.getter(AudioConfiguration::sampleRate)).setter(AudioConfiguration.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<Long> TARGET_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetBitrate").getter(AudioConfiguration.getter(AudioConfiguration::targetBitrate)).setter(AudioConfiguration.setter(Builder::targetBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBitrate").build()}).build();
    private static final SdkField<String> TRACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("track").getter(AudioConfiguration.getter(AudioConfiguration::track)).setter(AudioConfiguration.setter(Builder::track)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("track").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CODEC_FIELD, SAMPLE_RATE_FIELD, TARGET_BITRATE_FIELD, TRACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long channels;
    private final String codec;
    private final Long sampleRate;
    private final Long targetBitrate;
    private final String track;

    private AudioConfiguration(BuilderImpl builder) {
        this.channels = builder.channels;
        this.codec = builder.codec;
        this.sampleRate = builder.sampleRate;
        this.targetBitrate = builder.targetBitrate;
        this.track = builder.track;
    }

    public final Long channels() {
        return this.channels;
    }

    public final String codec() {
        return this.codec;
    }

    public final Long sampleRate() {
        return this.sampleRate;
    }

    public final Long targetBitrate() {
        return this.targetBitrate;
    }

    public final String track() {
        return this.track;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.track());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioConfiguration)) {
            return false;
        }
        AudioConfiguration other = (AudioConfiguration)obj;
        return Objects.equals(this.channels(), other.channels()) && Objects.equals(this.codec(), other.codec()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.targetBitrate(), other.targetBitrate()) && Objects.equals(this.track(), other.track());
    }

    public final String toString() {
        return ToString.builder((String)"AudioConfiguration").add("Channels", (Object)this.channels()).add("Codec", (Object)this.codec()).add("SampleRate", (Object)this.sampleRate()).add("TargetBitrate", (Object)this.targetBitrate()).add("Track", (Object)this.track()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "sampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "targetBitrate": {
                return Optional.ofNullable(clazz.cast(this.targetBitrate()));
            }
            case "track": {
                return Optional.ofNullable(clazz.cast(this.track()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channels", CHANNELS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        map.put("targetBitrate", TARGET_BITRATE_FIELD);
        map.put("track", TRACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioConfiguration, T> g) {
        return obj -> g.apply((AudioConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long channels;
        private String codec;
        private Long sampleRate;
        private Long targetBitrate;
        private String track;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioConfiguration model) {
            this.channels(model.channels);
            this.codec(model.codec);
            this.sampleRate(model.sampleRate);
            this.targetBitrate(model.targetBitrate);
            this.track(model.track);
        }

        public final Long getChannels() {
            return this.channels;
        }

        public final void setChannels(Long channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Long channels) {
            this.channels = channels;
            return this;
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final Long getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Long getTargetBitrate() {
            return this.targetBitrate;
        }

        public final void setTargetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
        }

        @Override
        public final Builder targetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
            return this;
        }

        public final String getTrack() {
            return this.track;
        }

        public final void setTrack(String track) {
            this.track = track;
        }

        @Override
        public final Builder track(String track) {
            this.track = track;
            return this;
        }

        public AudioConfiguration build() {
            return new AudioConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioConfiguration> {
        public Builder channels(Long var1);

        public Builder codec(String var1);

        public Builder sampleRate(Long var1);

        public Builder targetBitrate(Long var1);

        public Builder track(String var1);
    }
}

