/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.Channel;
import software.amazon.awssdk.services.ivs.model.IngestConfiguration;
import software.amazon.awssdk.services.ivs.model.IngestConfigurations;
import software.amazon.awssdk.services.ivs.model.RecordingConfiguration;
import software.amazon.awssdk.services.ivs.model.StreamEvent;
import software.amazon.awssdk.services.ivs.model.StreamEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSession> {
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channel").getter(StreamSession.getter(StreamSession::channel)).setter(StreamSession.setter(Builder::channel)).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StreamSession.getter(StreamSession::endTime)).setter(StreamSession.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<IngestConfiguration> INGEST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ingestConfiguration").getter(StreamSession.getter(StreamSession::ingestConfiguration)).setter(StreamSession.setter(Builder::ingestConfiguration)).constructor(IngestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestConfiguration").build()}).build();
    private static final SdkField<IngestConfigurations> INGEST_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ingestConfigurations").getter(StreamSession.getter(StreamSession::ingestConfigurations)).setter(StreamSession.setter(Builder::ingestConfigurations)).constructor(IngestConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestConfigurations").build()}).build();
    private static final SdkField<RecordingConfiguration> RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingConfiguration").getter(StreamSession.getter(StreamSession::recordingConfiguration)).setter(StreamSession.setter(Builder::recordingConfiguration)).constructor(RecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfiguration").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StreamSession.getter(StreamSession::startTime)).setter(StreamSession.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(StreamSession.getter(StreamSession::streamId)).setter(StreamSession.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<List<StreamEvent>> TRUNCATED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("truncatedEvents").getter(StreamSession.getter(StreamSession::truncatedEvents)).setter(StreamSession.setter(Builder::truncatedEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truncatedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, END_TIME_FIELD, INGEST_CONFIGURATION_FIELD, INGEST_CONFIGURATIONS_FIELD, RECORDING_CONFIGURATION_FIELD, START_TIME_FIELD, STREAM_ID_FIELD, TRUNCATED_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamSession.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Channel channel;
    private final Instant endTime;
    private final IngestConfiguration ingestConfiguration;
    private final IngestConfigurations ingestConfigurations;
    private final RecordingConfiguration recordingConfiguration;
    private final Instant startTime;
    private final String streamId;
    private final List<StreamEvent> truncatedEvents;

    private StreamSession(BuilderImpl builder) {
        this.channel = builder.channel;
        this.endTime = builder.endTime;
        this.ingestConfiguration = builder.ingestConfiguration;
        this.ingestConfigurations = builder.ingestConfigurations;
        this.recordingConfiguration = builder.recordingConfiguration;
        this.startTime = builder.startTime;
        this.streamId = builder.streamId;
        this.truncatedEvents = builder.truncatedEvents;
    }

    public final Channel channel() {
        return this.channel;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final IngestConfiguration ingestConfiguration() {
        return this.ingestConfiguration;
    }

    public final IngestConfigurations ingestConfigurations() {
        return this.ingestConfigurations;
    }

    public final RecordingConfiguration recordingConfiguration() {
        return this.recordingConfiguration;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final boolean hasTruncatedEvents() {
        return this.truncatedEvents != null && !(this.truncatedEvents instanceof SdkAutoConstructList);
    }

    public final List<StreamEvent> truncatedEvents() {
        return this.truncatedEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruncatedEvents() ? this.truncatedEvents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSession)) {
            return false;
        }
        StreamSession other = (StreamSession)obj;
        return Objects.equals(this.channel(), other.channel()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ingestConfiguration(), other.ingestConfiguration()) && Objects.equals(this.ingestConfigurations(), other.ingestConfigurations()) && Objects.equals(this.recordingConfiguration(), other.recordingConfiguration()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.streamId(), other.streamId()) && this.hasTruncatedEvents() == other.hasTruncatedEvents() && Objects.equals(this.truncatedEvents(), other.truncatedEvents());
    }

    public final String toString() {
        return ToString.builder((String)"StreamSession").add("Channel", (Object)this.channel()).add("EndTime", (Object)this.endTime()).add("IngestConfiguration", (Object)this.ingestConfiguration()).add("IngestConfigurations", (Object)this.ingestConfigurations()).add("RecordingConfiguration", (Object)this.recordingConfiguration()).add("StartTime", (Object)this.startTime()).add("StreamId", (Object)this.streamId()).add("TruncatedEvents", this.hasTruncatedEvents() ? this.truncatedEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ingestConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingestConfiguration()));
            }
            case "ingestConfigurations": {
                return Optional.ofNullable(clazz.cast(this.ingestConfigurations()));
            }
            case "recordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.recordingConfiguration()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "truncatedEvents": {
                return Optional.ofNullable(clazz.cast(this.truncatedEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", CHANNEL_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("ingestConfiguration", INGEST_CONFIGURATION_FIELD);
        map.put("ingestConfigurations", INGEST_CONFIGURATIONS_FIELD);
        map.put("recordingConfiguration", RECORDING_CONFIGURATION_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        map.put("truncatedEvents", TRUNCATED_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamSession, T> g) {
        return obj -> g.apply((StreamSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Channel channel;
        private Instant endTime;
        private IngestConfiguration ingestConfiguration;
        private IngestConfigurations ingestConfigurations;
        private RecordingConfiguration recordingConfiguration;
        private Instant startTime;
        private String streamId;
        private List<StreamEvent> truncatedEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSession model) {
            this.channel(model.channel);
            this.endTime(model.endTime);
            this.ingestConfiguration(model.ingestConfiguration);
            this.ingestConfigurations(model.ingestConfigurations);
            this.recordingConfiguration(model.recordingConfiguration);
            this.startTime(model.startTime);
            this.streamId(model.streamId);
            this.truncatedEvents(model.truncatedEvents);
        }

        public final Channel.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final IngestConfiguration.Builder getIngestConfiguration() {
            return this.ingestConfiguration != null ? this.ingestConfiguration.toBuilder() : null;
        }

        public final void setIngestConfiguration(IngestConfiguration.BuilderImpl ingestConfiguration) {
            this.ingestConfiguration = ingestConfiguration != null ? ingestConfiguration.build() : null;
        }

        @Override
        public final Builder ingestConfiguration(IngestConfiguration ingestConfiguration) {
            this.ingestConfiguration = ingestConfiguration;
            return this;
        }

        public final IngestConfigurations.Builder getIngestConfigurations() {
            return this.ingestConfigurations != null ? this.ingestConfigurations.toBuilder() : null;
        }

        public final void setIngestConfigurations(IngestConfigurations.BuilderImpl ingestConfigurations) {
            this.ingestConfigurations = ingestConfigurations != null ? ingestConfigurations.build() : null;
        }

        @Override
        public final Builder ingestConfigurations(IngestConfigurations ingestConfigurations) {
            this.ingestConfigurations = ingestConfigurations;
            return this;
        }

        public final RecordingConfiguration.Builder getRecordingConfiguration() {
            return this.recordingConfiguration != null ? this.recordingConfiguration.toBuilder() : null;
        }

        public final void setRecordingConfiguration(RecordingConfiguration.BuilderImpl recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration != null ? recordingConfiguration.build() : null;
        }

        @Override
        public final Builder recordingConfiguration(RecordingConfiguration recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final List<StreamEvent.Builder> getTruncatedEvents() {
            List<StreamEvent.Builder> result = StreamEventsCopier.copyToBuilder(this.truncatedEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTruncatedEvents(Collection<StreamEvent.BuilderImpl> truncatedEvents) {
            this.truncatedEvents = StreamEventsCopier.copyFromBuilder(truncatedEvents);
        }

        @Override
        public final Builder truncatedEvents(Collection<StreamEvent> truncatedEvents) {
            this.truncatedEvents = StreamEventsCopier.copy(truncatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truncatedEvents(StreamEvent ... truncatedEvents) {
            this.truncatedEvents(Arrays.asList(truncatedEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truncatedEvents(Consumer<StreamEvent.Builder> ... truncatedEvents) {
            this.truncatedEvents(Stream.of(truncatedEvents).map(c -> (StreamEvent)((StreamEvent.Builder)StreamEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StreamSession build() {
            return new StreamSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSession> {
        public Builder channel(Channel var1);

        default public Builder channel(Consumer<Channel.Builder> channel) {
            return this.channel((Channel)((Channel.Builder)Channel.builder().applyMutation(channel)).build());
        }

        public Builder endTime(Instant var1);

        public Builder ingestConfiguration(IngestConfiguration var1);

        default public Builder ingestConfiguration(Consumer<IngestConfiguration.Builder> ingestConfiguration) {
            return this.ingestConfiguration((IngestConfiguration)((IngestConfiguration.Builder)IngestConfiguration.builder().applyMutation(ingestConfiguration)).build());
        }

        public Builder ingestConfigurations(IngestConfigurations var1);

        default public Builder ingestConfigurations(Consumer<IngestConfigurations.Builder> ingestConfigurations) {
            return this.ingestConfigurations((IngestConfigurations)((IngestConfigurations.Builder)IngestConfigurations.builder().applyMutation(ingestConfigurations)).build());
        }

        public Builder recordingConfiguration(RecordingConfiguration var1);

        default public Builder recordingConfiguration(Consumer<RecordingConfiguration.Builder> recordingConfiguration) {
            return this.recordingConfiguration((RecordingConfiguration)((RecordingConfiguration.Builder)RecordingConfiguration.builder().applyMutation(recordingConfiguration)).build());
        }

        public Builder startTime(Instant var1);

        public Builder streamId(String var1);

        public Builder truncatedEvents(Collection<StreamEvent> var1);

        public Builder truncatedEvents(StreamEvent ... var1);

        public Builder truncatedEvents(Consumer<StreamEvent.Builder> ... var1);
    }
}

