/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for optional message review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageReviewHandler implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageReviewHandler.Builder, MessageReviewHandler> {
    private static final SdkField<String> FALLBACK_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fallbackResult").getter(getter(MessageReviewHandler::fallbackResultAsString))
            .setter(setter(Builder::fallbackResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackResult").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(MessageReviewHandler::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FALLBACK_RESULT_FIELD,
            URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fallbackResult;

    private final String uri;

    private MessageReviewHandler(BuilderImpl builder) {
        this.fallbackResult = builder.fallbackResult;
        this.uri = builder.uri;
    }

    /**
     * <p>
     * Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return a valid
     * response, encounters an error or times out. If allowed, the message is delivered with returned content to all
     * users connected to the room. If denied, the message is not delivered to any user. Default: <code>ALLOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackResult}
     * will return {@link FallbackResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackResultAsString}.
     * </p>
     * 
     * @return Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return
     *         a valid response, encounters an error or times out. If allowed, the message is delivered with returned
     *         content to all users connected to the room. If denied, the message is not delivered to any user. Default:
     *         <code>ALLOW</code>.
     * @see FallbackResult
     */
    public final FallbackResult fallbackResult() {
        return FallbackResult.fromValue(fallbackResult);
    }

    /**
     * <p>
     * Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return a valid
     * response, encounters an error or times out. If allowed, the message is delivered with returned content to all
     * users connected to the room. If denied, the message is not delivered to any user. Default: <code>ALLOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackResult}
     * will return {@link FallbackResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackResultAsString}.
     * </p>
     * 
     * @return Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return
     *         a valid response, encounters an error or times out. If allowed, the message is delivered with returned
     *         content to all users connected to the room. If denied, the message is not delivered to any user. Default:
     *         <code>ALLOW</code>.
     * @see FallbackResult
     */
    public final String fallbackResultAsString() {
        return fallbackResult;
    }

    /**
     * <p>
     * Identifier of the message review handler. Currently this must be an ARN of a lambda function.
     * </p>
     * 
     * @return Identifier of the message review handler. Currently this must be an ARN of a lambda function.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fallbackResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageReviewHandler)) {
            return false;
        }
        MessageReviewHandler other = (MessageReviewHandler) obj;
        return Objects.equals(fallbackResultAsString(), other.fallbackResultAsString()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageReviewHandler").add("FallbackResult", fallbackResultAsString()).add("Uri", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fallbackResult":
            return Optional.ofNullable(clazz.cast(fallbackResultAsString()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageReviewHandler, T> g) {
        return obj -> g.apply((MessageReviewHandler) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageReviewHandler> {
        /**
         * <p>
         * Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return a
         * valid response, encounters an error or times out. If allowed, the message is delivered with returned content
         * to all users connected to the room. If denied, the message is not delivered to any user. Default:
         * <code>ALLOW</code>.
         * </p>
         * 
         * @param fallbackResult
         *        Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not
         *        return a valid response, encounters an error or times out. If allowed, the message is delivered with
         *        returned content to all users connected to the room. If denied, the message is not delivered to any
         *        user. Default: <code>ALLOW</code>.
         * @see FallbackResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackResult
         */
        Builder fallbackResult(String fallbackResult);

        /**
         * <p>
         * Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return a
         * valid response, encounters an error or times out. If allowed, the message is delivered with returned content
         * to all users connected to the room. If denied, the message is not delivered to any user. Default:
         * <code>ALLOW</code>.
         * </p>
         * 
         * @param fallbackResult
         *        Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not
         *        return a valid response, encounters an error or times out. If allowed, the message is delivered with
         *        returned content to all users connected to the room. If denied, the message is not delivered to any
         *        user. Default: <code>ALLOW</code>.
         * @see FallbackResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackResult
         */
        Builder fallbackResult(FallbackResult fallbackResult);

        /**
         * <p>
         * Identifier of the message review handler. Currently this must be an ARN of a lambda function.
         * </p>
         * 
         * @param uri
         *        Identifier of the message review handler. Currently this must be an ARN of a lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String fallbackResult;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageReviewHandler model) {
            fallbackResult(model.fallbackResult);
            uri(model.uri);
        }

        public final String getFallbackResult() {
            return fallbackResult;
        }

        public final void setFallbackResult(String fallbackResult) {
            this.fallbackResult = fallbackResult;
        }

        @Override
        public final Builder fallbackResult(String fallbackResult) {
            this.fallbackResult = fallbackResult;
            return this;
        }

        @Override
        public final Builder fallbackResult(FallbackResult fallbackResult) {
            this.fallbackResult(fallbackResult == null ? null : fallbackResult.toString());
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public MessageReviewHandler build() {
            return new MessageReviewHandler(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
