/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a room.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoomSummary implements SdkPojo, Serializable, ToCopyableBuilder<RoomSummary.Builder, RoomSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RoomSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(RoomSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RoomSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MessageReviewHandler> MESSAGE_REVIEW_HANDLER_FIELD = SdkField
            .<MessageReviewHandler> builder(MarshallingType.SDK_POJO).memberName("messageReviewHandler")
            .getter(getter(RoomSummary::messageReviewHandler)).setter(setter(Builder::messageReviewHandler))
            .constructor(MessageReviewHandler::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandler").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RoomSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RoomSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(RoomSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATE_TIME_FIELD,
            ID_FIELD, MESSAGE_REVIEW_HANDLER_FIELD, NAME_FIELD, TAGS_FIELD, UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createTime;

    private final String id;

    private final MessageReviewHandler messageReviewHandler;

    private final String name;

    private final Map<String, String> tags;

    private final Instant updateTime;

    private RoomSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createTime = builder.createTime;
        this.id = builder.id;
        this.messageReviewHandler = builder.messageReviewHandler;
        this.name = builder.name;
        this.tags = builder.tags;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * Room ARN.
     * </p>
     * 
     * @return Room ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the
     * room.
     * </p>
     * 
     * @return Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
     *         identifies the room.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Configuration information for optional review of messages.
     * </p>
     * 
     * @return Configuration information for optional review of messages.
     */
    public final MessageReviewHandler messageReviewHandler() {
        return messageReviewHandler;
    }

    /**
     * <p>
     * Room name. The value does not need to be unique.
     * </p>
     * 
     * @return Room name. The value does not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no
     * constraints beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. See <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for
     *         details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS
     *         Chat has no constraints beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(messageReviewHandler());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomSummary)) {
            return false;
        }
        RoomSummary other = (RoomSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(id(), other.id()) && Objects.equals(messageReviewHandler(), other.messageReviewHandler())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoomSummary").add("Arn", arn()).add("CreateTime", createTime()).add("Id", id())
                .add("MessageReviewHandler", messageReviewHandler()).add("Name", name()).add("Tags", hasTags() ? tags() : null)
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "messageReviewHandler":
            return Optional.ofNullable(clazz.cast(messageReviewHandler()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoomSummary, T> g) {
        return obj -> g.apply((RoomSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoomSummary> {
        /**
         * <p>
         * Room ARN.
         * </p>
         * 
         * @param arn
         *        Room ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
         * </p>
         * 
         * @param createTime
         *        Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies
         * the room.
         * </p>
         * 
         * @param id
         *        Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
         *        identifies the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Configuration information for optional review of messages.
         * </p>
         * 
         * @param messageReviewHandler
         *        Configuration information for optional review of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageReviewHandler(MessageReviewHandler messageReviewHandler);

        /**
         * <p>
         * Configuration information for optional review of messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageReviewHandler.Builder} avoiding
         * the need to create one manually via {@link MessageReviewHandler#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageReviewHandler.Builder#build()} is called immediately and
         * its result is passed to {@link #messageReviewHandler(MessageReviewHandler)}.
         * 
         * @param messageReviewHandler
         *        a consumer that will call methods on {@link MessageReviewHandler.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageReviewHandler(MessageReviewHandler)
         */
        default Builder messageReviewHandler(Consumer<MessageReviewHandler.Builder> messageReviewHandler) {
            return messageReviewHandler(MessageReviewHandler.builder().applyMutation(messageReviewHandler).build());
        }

        /**
         * <p>
         * Room name. The value does not need to be unique.
         * </p>
         * 
         * @param name
         *        Room name. The value does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tags attached to the resource. See <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
         * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no
         * constraints beyond what is documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. See <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for
         *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
         *        IVS Chat has no constraints beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
         * </p>
         * 
         * @param updateTime
         *        Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createTime;

        private String id;

        private MessageReviewHandler messageReviewHandler;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomSummary model) {
            arn(model.arn);
            createTime(model.createTime);
            id(model.id);
            messageReviewHandler(model.messageReviewHandler);
            name(model.name);
            tags(model.tags);
            updateTime(model.updateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MessageReviewHandler.Builder getMessageReviewHandler() {
            return messageReviewHandler != null ? messageReviewHandler.toBuilder() : null;
        }

        public final void setMessageReviewHandler(MessageReviewHandler.BuilderImpl messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler != null ? messageReviewHandler.build() : null;
        }

        @Override
        public final Builder messageReviewHandler(MessageReviewHandler messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public RoomSummary build() {
            return new RoomSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
