/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoomRequest extends IvschatRequest implements
        ToCopyableBuilder<UpdateRoomRequest.Builder, UpdateRoomRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateRoomRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<Integer> MAXIMUM_MESSAGE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMessageLength").getter(getter(UpdateRoomRequest::maximumMessageLength))
            .setter(setter(Builder::maximumMessageLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageLength").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMessageRatePerSecond")
            .getter(getter(UpdateRoomRequest::maximumMessageRatePerSecond))
            .setter(setter(Builder::maximumMessageRatePerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageRatePerSecond")
                    .build()).build();

    private static final SdkField<MessageReviewHandler> MESSAGE_REVIEW_HANDLER_FIELD = SdkField
            .<MessageReviewHandler> builder(MarshallingType.SDK_POJO).memberName("messageReviewHandler")
            .getter(getter(UpdateRoomRequest::messageReviewHandler)).setter(setter(Builder::messageReviewHandler))
            .constructor(MessageReviewHandler::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandler").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateRoomRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            MAXIMUM_MESSAGE_LENGTH_FIELD, MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD, MESSAGE_REVIEW_HANDLER_FIELD, NAME_FIELD));

    private final String identifier;

    private final Integer maximumMessageLength;

    private final Integer maximumMessageRatePerSecond;

    private final MessageReviewHandler messageReviewHandler;

    private final String name;

    private UpdateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.maximumMessageLength = builder.maximumMessageLength;
        this.maximumMessageRatePerSecond = builder.maximumMessageRatePerSecond;
        this.messageReviewHandler = builder.messageReviewHandler;
        this.name = builder.name;
    }

    /**
     * <p>
     * Identifier of the room to be updated. Currently this must be an ARN.
     * </p>
     * 
     * @return Identifier of the room to be updated. Currently this must be an ARN.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit
     * applies specifically to rune/code-point count, not number of bytes. Default: 500.
     * </p>
     * 
     * @return The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this
     *         limit applies specifically to rune/code-point count, not number of bytes. Default: 500.
     */
    public final Integer maximumMessageLength() {
        return maximumMessageLength;
    }

    /**
     * <p>
     * Maximum number of messages per second that can be sent to the room (by all clients). Default: 10.
     * </p>
     * 
     * @return Maximum number of messages per second that can be sent to the room (by all clients). Default: 10.
     */
    public final Integer maximumMessageRatePerSecond() {
        return maximumMessageRatePerSecond;
    }

    /**
     * <p>
     * Configuration information for optional review of messages. Specify an empty <code>uri</code> string to
     * disassociate a message review handler from the specified room.
     * </p>
     * 
     * @return Configuration information for optional review of messages. Specify an empty <code>uri</code> string to
     *         disassociate a message review handler from the specified room.
     */
    public final MessageReviewHandler messageReviewHandler() {
        return messageReviewHandler;
    }

    /**
     * <p>
     * Room name. The value does not need to be unique.
     * </p>
     * 
     * @return Room name. The value does not need to be unique.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(maximumMessageLength());
        hashCode = 31 * hashCode + Objects.hashCode(maximumMessageRatePerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(messageReviewHandler());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoomRequest)) {
            return false;
        }
        UpdateRoomRequest other = (UpdateRoomRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(maximumMessageLength(), other.maximumMessageLength())
                && Objects.equals(maximumMessageRatePerSecond(), other.maximumMessageRatePerSecond())
                && Objects.equals(messageReviewHandler(), other.messageReviewHandler()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoomRequest").add("Identifier", identifier())
                .add("MaximumMessageLength", maximumMessageLength())
                .add("MaximumMessageRatePerSecond", maximumMessageRatePerSecond())
                .add("MessageReviewHandler", messageReviewHandler()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "maximumMessageLength":
            return Optional.ofNullable(clazz.cast(maximumMessageLength()));
        case "maximumMessageRatePerSecond":
            return Optional.ofNullable(clazz.cast(maximumMessageRatePerSecond()));
        case "messageReviewHandler":
            return Optional.ofNullable(clazz.cast(messageReviewHandler()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoomRequest, T> g) {
        return obj -> g.apply((UpdateRoomRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRoomRequest> {
        /**
         * <p>
         * Identifier of the room to be updated. Currently this must be an ARN.
         * </p>
         * 
         * @param identifier
         *        Identifier of the room to be updated. Currently this must be an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this
         * limit applies specifically to rune/code-point count, not number of bytes. Default: 500.
         * </p>
         * 
         * @param maximumMessageLength
         *        The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and
         *        this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMessageLength(Integer maximumMessageLength);

        /**
         * <p>
         * Maximum number of messages per second that can be sent to the room (by all clients). Default: 10.
         * </p>
         * 
         * @param maximumMessageRatePerSecond
         *        Maximum number of messages per second that can be sent to the room (by all clients). Default: 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond);

        /**
         * <p>
         * Configuration information for optional review of messages. Specify an empty <code>uri</code> string to
         * disassociate a message review handler from the specified room.
         * </p>
         * 
         * @param messageReviewHandler
         *        Configuration information for optional review of messages. Specify an empty <code>uri</code> string to
         *        disassociate a message review handler from the specified room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageReviewHandler(MessageReviewHandler messageReviewHandler);

        /**
         * <p>
         * Configuration information for optional review of messages. Specify an empty <code>uri</code> string to
         * disassociate a message review handler from the specified room.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageReviewHandler.Builder} avoiding
         * the need to create one manually via {@link MessageReviewHandler#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageReviewHandler.Builder#build()} is called immediately and
         * its result is passed to {@link #messageReviewHandler(MessageReviewHandler)}.
         * 
         * @param messageReviewHandler
         *        a consumer that will call methods on {@link MessageReviewHandler.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageReviewHandler(MessageReviewHandler)
         */
        default Builder messageReviewHandler(Consumer<MessageReviewHandler.Builder> messageReviewHandler) {
            return messageReviewHandler(MessageReviewHandler.builder().applyMutation(messageReviewHandler).build());
        }

        /**
         * <p>
         * Room name. The value does not need to be unique.
         * </p>
         * 
         * @param name
         *        Room name. The value does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvschatRequest.BuilderImpl implements Builder {
        private String identifier;

        private Integer maximumMessageLength;

        private Integer maximumMessageRatePerSecond;

        private MessageReviewHandler messageReviewHandler;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoomRequest model) {
            super(model);
            identifier(model.identifier);
            maximumMessageLength(model.maximumMessageLength);
            maximumMessageRatePerSecond(model.maximumMessageRatePerSecond);
            messageReviewHandler(model.messageReviewHandler);
            name(model.name);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Integer getMaximumMessageLength() {
            return maximumMessageLength;
        }

        public final void setMaximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
        }

        @Override
        public final Builder maximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
            return this;
        }

        public final Integer getMaximumMessageRatePerSecond() {
            return maximumMessageRatePerSecond;
        }

        public final void setMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
        }

        @Override
        public final Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
            return this;
        }

        public final MessageReviewHandler.Builder getMessageReviewHandler() {
            return messageReviewHandler != null ? messageReviewHandler.toBuilder() : null;
        }

        public final void setMessageReviewHandler(MessageReviewHandler.BuilderImpl messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler != null ? messageReviewHandler.build() : null;
        }

        @Override
        public final Builder messageReviewHandler(MessageReviewHandler messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoomRequest build() {
            return new UpdateRoomRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
