/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoomResponse extends IvschatResponse implements
        ToCopyableBuilder<CreateRoomResponse.Builder, CreateRoomResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateRoomResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(CreateRoomResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateRoomResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> MAXIMUM_MESSAGE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMessageLength").getter(getter(CreateRoomResponse::maximumMessageLength))
            .setter(setter(Builder::maximumMessageLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageLength").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMessageRatePerSecond")
            .getter(getter(CreateRoomResponse::maximumMessageRatePerSecond))
            .setter(setter(Builder::maximumMessageRatePerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageRatePerSecond")
                    .build()).build();

    private static final SdkField<MessageReviewHandler> MESSAGE_REVIEW_HANDLER_FIELD = SdkField
            .<MessageReviewHandler> builder(MarshallingType.SDK_POJO).memberName("messageReviewHandler")
            .getter(getter(CreateRoomResponse::messageReviewHandler)).setter(setter(Builder::messageReviewHandler))
            .constructor(MessageReviewHandler::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandler").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRoomResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRoomResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(CreateRoomResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATE_TIME_FIELD,
            ID_FIELD, MAXIMUM_MESSAGE_LENGTH_FIELD, MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD, MESSAGE_REVIEW_HANDLER_FIELD,
            NAME_FIELD, TAGS_FIELD, UPDATE_TIME_FIELD));

    private final String arn;

    private final Instant createTime;

    private final String id;

    private final Integer maximumMessageLength;

    private final Integer maximumMessageRatePerSecond;

    private final MessageReviewHandler messageReviewHandler;

    private final String name;

    private final Map<String, String> tags;

    private final Instant updateTime;

    private CreateRoomResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createTime = builder.createTime;
        this.id = builder.id;
        this.maximumMessageLength = builder.maximumMessageLength;
        this.maximumMessageRatePerSecond = builder.maximumMessageRatePerSecond;
        this.messageReviewHandler = builder.messageReviewHandler;
        this.name = builder.name;
        this.tags = builder.tags;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * Room ARN, assigned by the system.
     * </p>
     * 
     * @return Room ARN, assigned by the system.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the
     * room.
     * </p>
     * 
     * @return Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
     *         identifies the room.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Maximum number of characters in a single message, from the request.
     * </p>
     * 
     * @return Maximum number of characters in a single message, from the request.
     */
    public final Integer maximumMessageLength() {
        return maximumMessageLength;
    }

    /**
     * <p>
     * Maximum number of messages per second that can be sent to the room (by all clients), from the request.
     * </p>
     * 
     * @return Maximum number of messages per second that can be sent to the room (by all clients), from the request.
     */
    public final Integer maximumMessageRatePerSecond() {
        return maximumMessageRatePerSecond;
    }

    /**
     * <p>
     * Configuration information for optional review of messages.
     * </p>
     * 
     * @return Configuration information for optional review of messages.
     */
    public final MessageReviewHandler messageReviewHandler() {
        return messageReviewHandler;
    }

    /**
     * <p>
     * Room name, from the request (if specified).
     * </p>
     * 
     * @return Room name, from the request (if specified).
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource, from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource, from the request.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(maximumMessageLength());
        hashCode = 31 * hashCode + Objects.hashCode(maximumMessageRatePerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(messageReviewHandler());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomResponse)) {
            return false;
        }
        CreateRoomResponse other = (CreateRoomResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(id(), other.id()) && Objects.equals(maximumMessageLength(), other.maximumMessageLength())
                && Objects.equals(maximumMessageRatePerSecond(), other.maximumMessageRatePerSecond())
                && Objects.equals(messageReviewHandler(), other.messageReviewHandler()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoomResponse").add("Arn", arn()).add("CreateTime", createTime()).add("Id", id())
                .add("MaximumMessageLength", maximumMessageLength())
                .add("MaximumMessageRatePerSecond", maximumMessageRatePerSecond())
                .add("MessageReviewHandler", messageReviewHandler()).add("Name", name()).add("Tags", hasTags() ? tags() : null)
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "maximumMessageLength":
            return Optional.ofNullable(clazz.cast(maximumMessageLength()));
        case "maximumMessageRatePerSecond":
            return Optional.ofNullable(clazz.cast(maximumMessageRatePerSecond()));
        case "messageReviewHandler":
            return Optional.ofNullable(clazz.cast(messageReviewHandler()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoomResponse, T> g) {
        return obj -> g.apply((CreateRoomResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoomResponse> {
        /**
         * <p>
         * Room ARN, assigned by the system.
         * </p>
         * 
         * @param arn
         *        Room ARN, assigned by the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
         * </p>
         * 
         * @param createTime
         *        Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies
         * the room.
         * </p>
         * 
         * @param id
         *        Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
         *        identifies the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Maximum number of characters in a single message, from the request.
         * </p>
         * 
         * @param maximumMessageLength
         *        Maximum number of characters in a single message, from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMessageLength(Integer maximumMessageLength);

        /**
         * <p>
         * Maximum number of messages per second that can be sent to the room (by all clients), from the request.
         * </p>
         * 
         * @param maximumMessageRatePerSecond
         *        Maximum number of messages per second that can be sent to the room (by all clients), from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond);

        /**
         * <p>
         * Configuration information for optional review of messages.
         * </p>
         * 
         * @param messageReviewHandler
         *        Configuration information for optional review of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageReviewHandler(MessageReviewHandler messageReviewHandler);

        /**
         * <p>
         * Configuration information for optional review of messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageReviewHandler.Builder} avoiding
         * the need to create one manually via {@link MessageReviewHandler#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageReviewHandler.Builder#build()} is called immediately and
         * its result is passed to {@link #messageReviewHandler(MessageReviewHandler)}.
         * 
         * @param messageReviewHandler
         *        a consumer that will call methods on {@link MessageReviewHandler.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageReviewHandler(MessageReviewHandler)
         */
        default Builder messageReviewHandler(Consumer<MessageReviewHandler.Builder> messageReviewHandler) {
            return messageReviewHandler(MessageReviewHandler.builder().applyMutation(messageReviewHandler).build());
        }

        /**
         * <p>
         * Room name, from the request (if specified).
         * </p>
         * 
         * @param name
         *        Room name, from the request (if specified).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tags attached to the resource, from the request.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource, from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
         * </p>
         * 
         * @param updateTime
         *        Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends IvschatResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant createTime;

        private String id;

        private Integer maximumMessageLength;

        private Integer maximumMessageRatePerSecond;

        private MessageReviewHandler messageReviewHandler;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomResponse model) {
            super(model);
            arn(model.arn);
            createTime(model.createTime);
            id(model.id);
            maximumMessageLength(model.maximumMessageLength);
            maximumMessageRatePerSecond(model.maximumMessageRatePerSecond);
            messageReviewHandler(model.messageReviewHandler);
            name(model.name);
            tags(model.tags);
            updateTime(model.updateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getMaximumMessageLength() {
            return maximumMessageLength;
        }

        public final void setMaximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
        }

        @Override
        public final Builder maximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
            return this;
        }

        public final Integer getMaximumMessageRatePerSecond() {
            return maximumMessageRatePerSecond;
        }

        public final void setMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
        }

        @Override
        public final Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
            return this;
        }

        public final MessageReviewHandler.Builder getMessageReviewHandler() {
            return messageReviewHandler != null ? messageReviewHandler.toBuilder() : null;
        }

        public final void setMessageReviewHandler(MessageReviewHandler.BuilderImpl messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler != null ? messageReviewHandler.build() : null;
        }

        @Override
        public final Builder messageReviewHandler(MessageReviewHandler messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public CreateRoomResponse build() {
            return new CreateRoomResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
