/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivschat.model.IvschatResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChatTokenResponse
extends IvschatResponse
implements ToCopyableBuilder<Builder, CreateChatTokenResponse> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("token").getter(CreateChatTokenResponse.getter(CreateChatTokenResponse::token)).setter(CreateChatTokenResponse.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final SdkField<Instant> TOKEN_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("tokenExpirationTime").getter(CreateChatTokenResponse.getter(CreateChatTokenResponse::tokenExpirationTime)).setter(CreateChatTokenResponse.setter(Builder::tokenExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> SESSION_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("sessionExpirationTime").getter(CreateChatTokenResponse.getter(CreateChatTokenResponse::sessionExpirationTime)).setter(CreateChatTokenResponse.setter(Builder::sessionExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD, TOKEN_EXPIRATION_TIME_FIELD, SESSION_EXPIRATION_TIME_FIELD));
    private final String token;
    private final Instant tokenExpirationTime;
    private final Instant sessionExpirationTime;

    private CreateChatTokenResponse(BuilderImpl builder) {
        super(builder);
        this.token = builder.token;
        this.tokenExpirationTime = builder.tokenExpirationTime;
        this.sessionExpirationTime = builder.sessionExpirationTime;
    }

    public final String token() {
        return this.token;
    }

    public final Instant tokenExpirationTime() {
        return this.tokenExpirationTime;
    }

    public final Instant sessionExpirationTime() {
        return this.sessionExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChatTokenResponse)) {
            return false;
        }
        CreateChatTokenResponse other = (CreateChatTokenResponse)((Object)obj);
        return Objects.equals(this.token(), other.token()) && Objects.equals(this.tokenExpirationTime(), other.tokenExpirationTime()) && Objects.equals(this.sessionExpirationTime(), other.sessionExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChatTokenResponse").add("Token", (Object)(this.token() == null ? null : "*** Sensitive Data Redacted ***")).add("TokenExpirationTime", (Object)this.tokenExpirationTime()).add("SessionExpirationTime", (Object)this.sessionExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "tokenExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.tokenExpirationTime()));
            }
            case "sessionExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.sessionExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChatTokenResponse, T> g) {
        return obj -> g.apply((CreateChatTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatResponse.BuilderImpl
    implements Builder {
        private String token;
        private Instant tokenExpirationTime;
        private Instant sessionExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChatTokenResponse model) {
            super(model);
            this.token(model.token);
            this.tokenExpirationTime(model.tokenExpirationTime);
            this.sessionExpirationTime(model.sessionExpirationTime);
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final Instant getTokenExpirationTime() {
            return this.tokenExpirationTime;
        }

        public final void setTokenExpirationTime(Instant tokenExpirationTime) {
            this.tokenExpirationTime = tokenExpirationTime;
        }

        @Override
        public final Builder tokenExpirationTime(Instant tokenExpirationTime) {
            this.tokenExpirationTime = tokenExpirationTime;
            return this;
        }

        public final Instant getSessionExpirationTime() {
            return this.sessionExpirationTime;
        }

        public final void setSessionExpirationTime(Instant sessionExpirationTime) {
            this.sessionExpirationTime = sessionExpirationTime;
        }

        @Override
        public final Builder sessionExpirationTime(Instant sessionExpirationTime) {
            this.sessionExpirationTime = sessionExpirationTime;
            return this;
        }

        @Override
        public CreateChatTokenResponse build() {
            return new CreateChatTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvschatResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChatTokenResponse> {
        public Builder token(String var1);

        public Builder tokenExpirationTime(Instant var1);

        public Builder sessionExpirationTime(Instant var1);
    }
}

