/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoggingConfigurationResponse extends IvschatResponse implements
        ToCopyableBuilder<CreateLoggingConfigurationResponse.Builder, CreateLoggingConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateLoggingConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateLoggingConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(CreateLoggingConfigurationResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(CreateLoggingConfigurationResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateLoggingConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(CreateLoggingConfigurationResponse::destinationConfiguration))
            .setter(setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CreateLoggingConfigurationResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLoggingConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD, NAME_FIELD, DESTINATION_CONFIGURATION_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("arn", ARN_FIELD);
                    put("id", ID_FIELD);
                    put("createTime", CREATE_TIME_FIELD);
                    put("updateTime", UPDATE_TIME_FIELD);
                    put("name", NAME_FIELD);
                    put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
                    put("state", STATE_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String arn;

    private final String id;

    private final Instant createTime;

    private final Instant updateTime;

    private final String name;

    private final DestinationConfiguration destinationConfiguration;

    private final String state;

    private final Map<String, String> tags;

    private CreateLoggingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.name = builder.name;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Logging-configuration ARN, assigned by the system.
     * </p>
     * 
     * @return Logging-configuration ARN, assigned by the system.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     * uniquely identifies the logging configuration.
     * </p>
     * 
     * @return Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN
     *         that uniquely identifies the logging configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @return Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is
     *         returned as a string</i>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @return Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is
     *         returned as a string</i>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * Logging-configuration name, from the request (if specified).
     * </p>
     * 
     * @return Logging-configuration name, from the request (if specified).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A complex type that contains a destination configuration for where chat content will be logged, from the request.
     * There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in
     * a <code>destinationConfiguration</code>.
     * </p>
     * 
     * @return A complex type that contains a destination configuration for where chat content will be logged, from the
     *         request. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or
     *         <code>s3</code>) in a <code>destinationConfiguration</code>.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to log
     * chat content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CreateLoggingConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready
     *         to log chat content.
     * @see CreateLoggingConfigurationState
     */
    public final CreateLoggingConfigurationState state() {
        return CreateLoggingConfigurationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to log
     * chat content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CreateLoggingConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready
     *         to log chat content.
     * @see CreateLoggingConfigurationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource, from the request (if specified). Array of maps, each of the form
     * <code>string:string (key:value)</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource, from the request (if specified). Array of maps, each of the form
     *         <code>string:string (key:value)</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoggingConfigurationResponse)) {
            return false;
        }
        CreateLoggingConfigurationResponse other = (CreateLoggingConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(name(), other.name())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLoggingConfigurationResponse").add("Arn", arn()).add("Id", id())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("Name", name())
                .add("DestinationConfiguration", destinationConfiguration()).add("State", stateAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoggingConfigurationResponse, T> g) {
        return obj -> g.apply((CreateLoggingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLoggingConfigurationResponse> {
        /**
         * <p>
         * Logging-configuration ARN, assigned by the system.
         * </p>
         * 
         * @param arn
         *        Logging-configuration ARN, assigned by the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
         * uniquely identifies the logging configuration.
         * </p>
         * 
         * @param id
         *        Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN
         *        that uniquely identifies the logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned
         * as a string</i>.
         * </p>
         * 
         * @param createTime
         *        Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is
         *        returned as a string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned
         * as a string</i>.
         * </p>
         * 
         * @param updateTime
         *        Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is
         *        returned as a string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * Logging-configuration name, from the request (if specified).
         * </p>
         * 
         * @param name
         *        Logging-configuration name, from the request (if specified).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A complex type that contains a destination configuration for where chat content will be logged, from the
         * request. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or
         * <code>s3</code>) in a <code>destinationConfiguration</code>.
         * </p>
         * 
         * @param destinationConfiguration
         *        A complex type that contains a destination configuration for where chat content will be logged, from
         *        the request. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>
         *        , or <code>s3</code>) in a <code>destinationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * A complex type that contains a destination configuration for where chat content will be logged, from the
         * request. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or
         * <code>s3</code>) in a <code>destinationConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to
         * log chat content.
         * </p>
         * 
         * @param state
         *        The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is
         *        ready to log chat content.
         * @see CreateLoggingConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreateLoggingConfigurationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to
         * log chat content.
         * </p>
         * 
         * @param state
         *        The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is
         *        ready to log chat content.
         * @see CreateLoggingConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreateLoggingConfigurationState
         */
        Builder state(CreateLoggingConfigurationState state);

        /**
         * <p>
         * Tags attached to the resource, from the request (if specified). Array of maps, each of the form
         * <code>string:string (key:value)</code>.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource, from the request (if specified). Array of maps, each of the form
         *        <code>string:string (key:value)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IvschatResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private Instant createTime;

        private Instant updateTime;

        private String name;

        private DestinationConfiguration destinationConfiguration;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoggingConfigurationResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            createTime(model.createTime);
            updateTime(model.updateTime);
            name(model.name);
            destinationConfiguration(model.destinationConfiguration);
            state(model.state);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CreateLoggingConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public CreateLoggingConfigurationResponse build() {
            return new CreateLoggingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
