/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisconnectUserRequest extends IvschatRequest implements
        ToCopyableBuilder<DisconnectUserRequest.Builder, DisconnectUserRequest> {
    private static final SdkField<String> ROOM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roomIdentifier").getter(getter(DisconnectUserRequest::roomIdentifier))
            .setter(setter(Builder::roomIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roomIdentifier").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(DisconnectUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(DisconnectUserRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_IDENTIFIER_FIELD,
            USER_ID_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("roomIdentifier", ROOM_IDENTIFIER_FIELD);
                    put("userId", USER_ID_FIELD);
                    put("reason", REASON_FIELD);
                }
            });

    private final String roomIdentifier;

    private final String userId;

    private final String reason;

    private DisconnectUserRequest(BuilderImpl builder) {
        super(builder);
        this.roomIdentifier = builder.roomIdentifier;
        this.userId = builder.userId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.
     * </p>
     * 
     * @return Identifier of the room from which the user's clients should be disconnected. Currently this must be an
     *         ARN.
     */
    public final String roomIdentifier() {
        return roomIdentifier;
    }

    /**
     * <p>
     * ID of the user (connection) to disconnect from the room.
     * </p>
     * 
     * @return ID of the user (connection) to disconnect from the room.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Reason for disconnecting the user.
     * </p>
     * 
     * @return Reason for disconnecting the user.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roomIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectUserRequest)) {
            return false;
        }
        DisconnectUserRequest other = (DisconnectUserRequest) obj;
        return Objects.equals(roomIdentifier(), other.roomIdentifier()) && Objects.equals(userId(), other.userId())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisconnectUserRequest").add("RoomIdentifier", roomIdentifier())
                .add("UserId", userId() == null ? null : "*** Sensitive Data Redacted ***").add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roomIdentifier":
            return Optional.ofNullable(clazz.cast(roomIdentifier()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisconnectUserRequest, T> g) {
        return obj -> g.apply((DisconnectUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisconnectUserRequest> {
        /**
         * <p>
         * Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.
         * </p>
         * 
         * @param roomIdentifier
         *        Identifier of the room from which the user's clients should be disconnected. Currently this must be an
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomIdentifier(String roomIdentifier);

        /**
         * <p>
         * ID of the user (connection) to disconnect from the room.
         * </p>
         * 
         * @param userId
         *        ID of the user (connection) to disconnect from the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Reason for disconnecting the user.
         * </p>
         * 
         * @param reason
         *        Reason for disconnecting the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvschatRequest.BuilderImpl implements Builder {
        private String roomIdentifier;

        private String userId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectUserRequest model) {
            super(model);
            roomIdentifier(model.roomIdentifier);
            userId(model.userId);
            reason(model.reason);
        }

        public final String getRoomIdentifier() {
            return roomIdentifier;
        }

        public final void setRoomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
        }

        @Override
        public final Builder roomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisconnectUserRequest build() {
            return new DisconnectUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
