/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoomsRequest extends IvschatRequest implements
        ToCopyableBuilder<ListRoomsRequest.Builder, ListRoomsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListRoomsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRoomsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRoomsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> MESSAGE_REVIEW_HANDLER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageReviewHandlerUri").getter(getter(ListRoomsRequest::messageReviewHandlerUri))
            .setter(setter(Builder::messageReviewHandlerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandlerUri").build())
            .build();

    private static final SdkField<String> LOGGING_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("loggingConfigurationIdentifier")
            .getter(getter(ListRoomsRequest::loggingConfigurationIdentifier))
            .setter(setter(Builder::loggingConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfigurationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, MESSAGE_REVIEW_HANDLER_URI_FIELD, LOGGING_CONFIGURATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("messageReviewHandlerUri", MESSAGE_REVIEW_HANDLER_URI_FIELD);
                    put("loggingConfigurationIdentifier", LOGGING_CONFIGURATION_IDENTIFIER_FIELD);
                }
            });

    private final String name;

    private final String nextToken;

    private final Integer maxResults;

    private final String messageReviewHandlerUri;

    private final String loggingConfigurationIdentifier;

    private ListRoomsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.messageReviewHandlerUri = builder.messageReviewHandlerUri;
        this.loggingConfigurationIdentifier = builder.loggingConfigurationIdentifier;
    }

    /**
     * <p>
     * Filters the list to match the specified room name.
     * </p>
     * 
     * @return Filters the list to match the specified room name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
     * </p>
     * 
     * @return The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of rooms to return. Default: 50.
     * </p>
     * 
     * @return Maximum number of rooms to return. Default: 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters the list to match the specified message review handler URI.
     * </p>
     * 
     * @return Filters the list to match the specified message review handler URI.
     */
    public final String messageReviewHandlerUri() {
        return messageReviewHandlerUri;
    }

    /**
     * <p>
     * Logging-configuration identifier.
     * </p>
     * 
     * @return Logging-configuration identifier.
     */
    public final String loggingConfigurationIdentifier() {
        return loggingConfigurationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(messageReviewHandlerUri());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfigurationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomsRequest)) {
            return false;
        }
        ListRoomsRequest other = (ListRoomsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(messageReviewHandlerUri(), other.messageReviewHandlerUri())
                && Objects.equals(loggingConfigurationIdentifier(), other.loggingConfigurationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRoomsRequest").add("Name", name()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("MessageReviewHandlerUri", messageReviewHandlerUri())
                .add("LoggingConfigurationIdentifier", loggingConfigurationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "messageReviewHandlerUri":
            return Optional.ofNullable(clazz.cast(messageReviewHandlerUri()));
        case "loggingConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(loggingConfigurationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRoomsRequest, T> g) {
        return obj -> g.apply((ListRoomsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRoomsRequest> {
        /**
         * <p>
         * Filters the list to match the specified room name.
         * </p>
         * 
         * @param name
         *        Filters the list to match the specified room name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
         * </p>
         * 
         * @param nextToken
         *        The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of rooms to return. Default: 50.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of rooms to return. Default: 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the list to match the specified message review handler URI.
         * </p>
         * 
         * @param messageReviewHandlerUri
         *        Filters the list to match the specified message review handler URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageReviewHandlerUri(String messageReviewHandlerUri);

        /**
         * <p>
         * Logging-configuration identifier.
         * </p>
         * 
         * @param loggingConfigurationIdentifier
         *        Logging-configuration identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfigurationIdentifier(String loggingConfigurationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvschatRequest.BuilderImpl implements Builder {
        private String name;

        private String nextToken;

        private Integer maxResults;

        private String messageReviewHandlerUri;

        private String loggingConfigurationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomsRequest model) {
            super(model);
            name(model.name);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            messageReviewHandlerUri(model.messageReviewHandlerUri);
            loggingConfigurationIdentifier(model.loggingConfigurationIdentifier);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMessageReviewHandlerUri() {
            return messageReviewHandlerUri;
        }

        public final void setMessageReviewHandlerUri(String messageReviewHandlerUri) {
            this.messageReviewHandlerUri = messageReviewHandlerUri;
        }

        @Override
        public final Builder messageReviewHandlerUri(String messageReviewHandlerUri) {
            this.messageReviewHandlerUri = messageReviewHandlerUri;
            return this;
        }

        public final String getLoggingConfigurationIdentifier() {
            return loggingConfigurationIdentifier;
        }

        public final void setLoggingConfigurationIdentifier(String loggingConfigurationIdentifier) {
            this.loggingConfigurationIdentifier = loggingConfigurationIdentifier;
        }

        @Override
        public final Builder loggingConfigurationIdentifier(String loggingConfigurationIdentifier) {
            this.loggingConfigurationIdentifier = loggingConfigurationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRoomsRequest build() {
            return new ListRoomsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
