/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes a location where chat logs will be stored. Each member represents the configuration of
 * one log destination. For logging, you define only one type of destination (for CloudWatch Logs, Kinesis Firehose, or
 * S3).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfiguration.Builder, DestinationConfiguration> {
    private static final SdkField<S3DestinationConfiguration> S3_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(DestinationConfiguration::s3)).setter(setter(Builder::s3))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final SdkField<CloudWatchLogsDestinationConfiguration> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(DestinationConfiguration::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<FirehoseDestinationConfiguration> FIREHOSE_FIELD = SdkField
            .<FirehoseDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("firehose")
            .getter(getter(DestinationConfiguration::firehose)).setter(setter(Builder::firehose))
            .constructor(FirehoseDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD,
            CLOUD_WATCH_LOGS_FIELD, FIREHOSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3DestinationConfiguration s3;

    private final CloudWatchLogsDestinationConfiguration cloudWatchLogs;

    private final FirehoseDestinationConfiguration firehose;

    private final Type type;

    private DestinationConfiguration(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.type = builder.type;
    }

    /**
     * <p>
     * An Amazon S3 destination configuration where chat activity will be logged.
     * </p>
     * 
     * @return An Amazon S3 destination configuration where chat activity will be logged.
     */
    public final S3DestinationConfiguration s3() {
        return s3;
    }

    /**
     * <p>
     * An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     * </p>
     * 
     * @return An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     */
    public final CloudWatchLogsDestinationConfiguration cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     * </p>
     * 
     * @return An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     */
    public final FirehoseDestinationConfiguration firehose() {
        return firehose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration) obj;
        return Objects.equals(s3(), other.s3()) && Objects.equals(cloudWatchLogs(), other.cloudWatchLogs())
                && Objects.equals(firehose(), other.firehose());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfiguration").add("S3", s3()).add("CloudWatchLogs", cloudWatchLogs())
                .add("Firehose", firehose()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "firehose":
            return Optional.ofNullable(clazz.cast(firehose()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * An Amazon S3 destination configuration where chat activity will be logged.
     * </p>
     * 
     * @param s3
     *        An Amazon S3 destination configuration where chat activity will be logged.
     */
    public static DestinationConfiguration fromS3(S3DestinationConfiguration s3) {
        return builder().s3(s3).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * An Amazon S3 destination configuration where chat activity will be logged.
     * </p>
     * 
     * @param s3
     *        An Amazon S3 destination configuration where chat activity will be logged.
     */
    public static DestinationConfiguration fromS3(Consumer<S3DestinationConfiguration.Builder> s3) {
        S3DestinationConfiguration.Builder builder = S3DestinationConfiguration.builder();
        s3.accept(builder);
        return fromS3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cloudWatchLogs()} initialized to the given value.
     *
     * <p>
     * An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     * </p>
     * 
     * @param cloudWatchLogs
     *        An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     */
    public static DestinationConfiguration fromCloudWatchLogs(CloudWatchLogsDestinationConfiguration cloudWatchLogs) {
        return builder().cloudWatchLogs(cloudWatchLogs).build();
    }

    /**
     * Create an instance of this class with {@link #cloudWatchLogs()} initialized to the given value.
     *
     * <p>
     * An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     * </p>
     * 
     * @param cloudWatchLogs
     *        An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     */
    public static DestinationConfiguration fromCloudWatchLogs(
            Consumer<CloudWatchLogsDestinationConfiguration.Builder> cloudWatchLogs) {
        CloudWatchLogsDestinationConfiguration.Builder builder = CloudWatchLogsDestinationConfiguration.builder();
        cloudWatchLogs.accept(builder);
        return fromCloudWatchLogs(builder.build());
    }

    /**
     * Create an instance of this class with {@link #firehose()} initialized to the given value.
     *
     * <p>
     * An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     * </p>
     * 
     * @param firehose
     *        An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     */
    public static DestinationConfiguration fromFirehose(FirehoseDestinationConfiguration firehose) {
        return builder().firehose(firehose).build();
    }

    /**
     * Create an instance of this class with {@link #firehose()} initialized to the given value.
     *
     * <p>
     * An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     * </p>
     * 
     * @param firehose
     *        An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     */
    public static DestinationConfiguration fromFirehose(Consumer<FirehoseDestinationConfiguration.Builder> firehose) {
        FirehoseDestinationConfiguration.Builder builder = FirehoseDestinationConfiguration.builder();
        firehose.accept(builder);
        return fromFirehose(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3", S3_FIELD);
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("firehose", FIREHOSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfiguration> {
        /**
         * <p>
         * An Amazon S3 destination configuration where chat activity will be logged.
         * </p>
         * 
         * @param s3
         *        An Amazon S3 destination configuration where chat activity will be logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3DestinationConfiguration s3);

        /**
         * <p>
         * An Amazon S3 destination configuration where chat activity will be logged.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3(S3DestinationConfiguration)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3DestinationConfiguration)
         */
        default Builder s3(Consumer<S3DestinationConfiguration.Builder> s3) {
            return s3(S3DestinationConfiguration.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
         * </p>
         * 
         * @param cloudWatchLogs
         *        An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsDestinationConfiguration cloudWatchLogs);

        /**
         * <p>
         * An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CloudWatchLogsDestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link CloudWatchLogsDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogs(CloudWatchLogsDestinationConfiguration)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsDestinationConfiguration)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsDestinationConfiguration.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsDestinationConfiguration.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
         * </p>
         * 
         * @param firehose
         *        An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseDestinationConfiguration firehose);

        /**
         * <p>
         * An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirehoseDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link FirehoseDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FirehoseDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #firehose(FirehoseDestinationConfiguration)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link FirehoseDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(FirehoseDestinationConfiguration)
         */
        default Builder firehose(Consumer<FirehoseDestinationConfiguration.Builder> firehose) {
            return firehose(FirehoseDestinationConfiguration.builder().applyMutation(firehose).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DestinationConfiguration s3;

        private CloudWatchLogsDestinationConfiguration cloudWatchLogs;

        private FirehoseDestinationConfiguration firehose;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            s3(model.s3);
            cloudWatchLogs(model.cloudWatchLogs);
            firehose(model.firehose);
        }

        public final S3DestinationConfiguration.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3DestinationConfiguration.BuilderImpl s3) {
            Object oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3DestinationConfiguration s3) {
            Object oldValue = this.s3;
            this.s3 = s3;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final CloudWatchLogsDestinationConfiguration.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestinationConfiguration.BuilderImpl cloudWatchLogs) {
            Object oldValue = this.cloudWatchLogs;
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
            handleUnionValueChange(Type.CLOUD_WATCH_LOGS, oldValue, this.cloudWatchLogs);
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsDestinationConfiguration cloudWatchLogs) {
            Object oldValue = this.cloudWatchLogs;
            this.cloudWatchLogs = cloudWatchLogs;
            handleUnionValueChange(Type.CLOUD_WATCH_LOGS, oldValue, this.cloudWatchLogs);
            return this;
        }

        public final FirehoseDestinationConfiguration.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseDestinationConfiguration.BuilderImpl firehose) {
            Object oldValue = this.firehose;
            this.firehose = firehose != null ? firehose.build() : null;
            handleUnionValueChange(Type.FIREHOSE, oldValue, this.firehose);
        }

        @Override
        public final Builder firehose(FirehoseDestinationConfiguration firehose) {
            Object oldValue = this.firehose;
            this.firehose = firehose;
            handleUnionValueChange(Type.FIREHOSE, oldValue, this.firehose);
            return this;
        }

        @Override
        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DestinationConfiguration#type()
     */
    public enum Type {
        S3,

        CLOUD_WATCH_LOGS,

        FIREHOSE,

        UNKNOWN_TO_SDK_VERSION
    }
}
