/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLoggingConfigurationsResponse extends IvschatResponse implements
        ToCopyableBuilder<ListLoggingConfigurationsResponse.Builder, ListLoggingConfigurationsResponse> {
    private static final SdkField<List<LoggingConfigurationSummary>> LOGGING_CONFIGURATIONS_FIELD = SdkField
            .<List<LoggingConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("loggingConfigurations")
            .getter(getter(ListLoggingConfigurationsResponse::loggingConfigurations))
            .setter(setter(Builder::loggingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoggingConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoggingConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLoggingConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIGURATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LoggingConfigurationSummary> loggingConfigurations;

    private final String nextToken;

    private ListLoggingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.loggingConfigurations = builder.loggingConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoggingConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLoggingConfigurations() {
        return loggingConfigurations != null && !(loggingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the matching logging configurations (summary information only). There is only one type of destination (
     * <code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
     * <code>destinationConfiguration</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoggingConfigurations} method.
     * </p>
     * 
     * @return List of the matching logging configurations (summary information only). There is only one type of
     *         destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
     *         <code>destinationConfiguration</code>.
     */
    public final List<LoggingConfigurationSummary> loggingConfigurations() {
        return loggingConfigurations;
    }

    /**
     * <p>
     * If there are more logging configurations than <code>maxResults</code>, use <code>nextToken</code> in the request
     * to get the next set.
     * </p>
     * 
     * @return If there are more logging configurations than <code>maxResults</code>, use <code>nextToken</code> in the
     *         request to get the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLoggingConfigurations() ? loggingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoggingConfigurationsResponse)) {
            return false;
        }
        ListLoggingConfigurationsResponse other = (ListLoggingConfigurationsResponse) obj;
        return hasLoggingConfigurations() == other.hasLoggingConfigurations()
                && Objects.equals(loggingConfigurations(), other.loggingConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLoggingConfigurationsResponse")
                .add("LoggingConfigurations", hasLoggingConfigurations() ? loggingConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loggingConfigurations":
            return Optional.ofNullable(clazz.cast(loggingConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("loggingConfigurations", LOGGING_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLoggingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListLoggingConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLoggingConfigurationsResponse> {
        /**
         * <p>
         * List of the matching logging configurations (summary information only). There is only one type of destination
         * (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
         * <code>destinationConfiguration</code>.
         * </p>
         * 
         * @param loggingConfigurations
         *        List of the matching logging configurations (summary information only). There is only one type of
         *        destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
         *        <code>destinationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfigurations(Collection<LoggingConfigurationSummary> loggingConfigurations);

        /**
         * <p>
         * List of the matching logging configurations (summary information only). There is only one type of destination
         * (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
         * <code>destinationConfiguration</code>.
         * </p>
         * 
         * @param loggingConfigurations
         *        List of the matching logging configurations (summary information only). There is only one type of
         *        destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
         *        <code>destinationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfigurations(LoggingConfigurationSummary... loggingConfigurations);

        /**
         * <p>
         * List of the matching logging configurations (summary information only). There is only one type of destination
         * (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a
         * <code>destinationConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivschat.model.LoggingConfigurationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ivschat.model.LoggingConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivschat.model.LoggingConfigurationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #loggingConfigurations(List<LoggingConfigurationSummary>)}.
         * 
         * @param loggingConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivschat.model.LoggingConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfigurations(java.util.Collection<LoggingConfigurationSummary>)
         */
        Builder loggingConfigurations(Consumer<LoggingConfigurationSummary.Builder>... loggingConfigurations);

        /**
         * <p>
         * If there are more logging configurations than <code>maxResults</code>, use <code>nextToken</code> in the
         * request to get the next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more logging configurations than <code>maxResults</code>, use <code>nextToken</code> in
         *        the request to get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IvschatResponse.BuilderImpl implements Builder {
        private List<LoggingConfigurationSummary> loggingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoggingConfigurationsResponse model) {
            super(model);
            loggingConfigurations(model.loggingConfigurations);
            nextToken(model.nextToken);
        }

        public final List<LoggingConfigurationSummary.Builder> getLoggingConfigurations() {
            List<LoggingConfigurationSummary.Builder> result = LoggingConfigurationListCopier
                    .copyToBuilder(this.loggingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoggingConfigurations(Collection<LoggingConfigurationSummary.BuilderImpl> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationListCopier.copyFromBuilder(loggingConfigurations);
        }

        @Override
        public final Builder loggingConfigurations(Collection<LoggingConfigurationSummary> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationListCopier.copy(loggingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(LoggingConfigurationSummary... loggingConfigurations) {
            loggingConfigurations(Arrays.asList(loggingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(Consumer<LoggingConfigurationSummary.Builder>... loggingConfigurations) {
            loggingConfigurations(Stream.of(loggingConfigurations)
                    .map(c -> LoggingConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLoggingConfigurationsResponse build() {
            return new ListLoggingConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
