/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChatTokenResponse extends IvschatResponse implements
        ToCopyableBuilder<CreateChatTokenResponse.Builder, CreateChatTokenResponse> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(CreateChatTokenResponse::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<Instant> TOKEN_EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("tokenExpirationTime")
            .getter(getter(CreateChatTokenResponse::tokenExpirationTime))
            .setter(setter(Builder::tokenExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SESSION_EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("sessionExpirationTime")
            .getter(getter(CreateChatTokenResponse::sessionExpirationTime))
            .setter(setter(Builder::sessionExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD,
            TOKEN_EXPIRATION_TIME_FIELD, SESSION_EXPIRATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String token;

    private final Instant tokenExpirationTime;

    private final Instant sessionExpirationTime;

    private CreateChatTokenResponse(BuilderImpl builder) {
        super(builder);
        this.token = builder.token;
        this.tokenExpirationTime = builder.tokenExpirationTime;
        this.sessionExpirationTime = builder.sessionExpirationTime;
    }

    /**
     * <p>
     * The issued client token, encrypted.
     * </p>
     * 
     * @return The issued client token, encrypted.
     */
    public final String token() {
        return token;
    }

    /**
     * <p>
     * Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601
     * timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO
     *         8601 timestamp; <i>note that this is returned as a string</i>.
     */
    public final Instant tokenExpirationTime() {
        return tokenExpirationTime;
    }

    /**
     * <p>
     * Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is
     * returned as a string</i>.
     * </p>
     * 
     * @return Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that
     *         this is returned as a string</i>.
     */
    public final Instant sessionExpirationTime() {
        return sessionExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(tokenExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChatTokenResponse)) {
            return false;
        }
        CreateChatTokenResponse other = (CreateChatTokenResponse) obj;
        return Objects.equals(token(), other.token()) && Objects.equals(tokenExpirationTime(), other.tokenExpirationTime())
                && Objects.equals(sessionExpirationTime(), other.sessionExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChatTokenResponse")
                .add("Token", token() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TokenExpirationTime", tokenExpirationTime()).add("SessionExpirationTime", sessionExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "tokenExpirationTime":
            return Optional.ofNullable(clazz.cast(tokenExpirationTime()));
        case "sessionExpirationTime":
            return Optional.ofNullable(clazz.cast(sessionExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("token", TOKEN_FIELD);
        map.put("tokenExpirationTime", TOKEN_EXPIRATION_TIME_FIELD);
        map.put("sessionExpirationTime", SESSION_EXPIRATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChatTokenResponse, T> g) {
        return obj -> g.apply((CreateChatTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvschatResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChatTokenResponse> {
        /**
         * <p>
         * The issued client token, encrypted.
         * </p>
         * 
         * @param token
         *        The issued client token, encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601
         * timestamp; <i>note that this is returned as a string</i>.
         * </p>
         * 
         * @param tokenExpirationTime
         *        Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO
         *        8601 timestamp; <i>note that this is returned as a string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenExpirationTime(Instant tokenExpirationTime);

        /**
         * <p>
         * Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this
         * is returned as a string</i>.
         * </p>
         * 
         * @param sessionExpirationTime
         *        Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that
         *        this is returned as a string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpirationTime(Instant sessionExpirationTime);
    }

    static final class BuilderImpl extends IvschatResponse.BuilderImpl implements Builder {
        private String token;

        private Instant tokenExpirationTime;

        private Instant sessionExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChatTokenResponse model) {
            super(model);
            token(model.token);
            tokenExpirationTime(model.tokenExpirationTime);
            sessionExpirationTime(model.sessionExpirationTime);
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final Instant getTokenExpirationTime() {
            return tokenExpirationTime;
        }

        public final void setTokenExpirationTime(Instant tokenExpirationTime) {
            this.tokenExpirationTime = tokenExpirationTime;
        }

        @Override
        public final Builder tokenExpirationTime(Instant tokenExpirationTime) {
            this.tokenExpirationTime = tokenExpirationTime;
            return this;
        }

        public final Instant getSessionExpirationTime() {
            return sessionExpirationTime;
        }

        public final void setSessionExpirationTime(Instant sessionExpirationTime) {
            this.sessionExpirationTime = sessionExpirationTime;
        }

        @Override
        public final Builder sessionExpirationTime(Instant sessionExpirationTime) {
            this.sessionExpirationTime = sessionExpirationTime;
            return this;
        }

        @Override
        public CreateChatTokenResponse build() {
            return new CreateChatTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
