/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateParticipantTokenRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<CreateParticipantTokenRequest.Builder, CreateParticipantTokenRequest> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(CreateParticipantTokenRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CreateParticipantTokenRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("duration").getter(getter(CreateParticipantTokenRequest::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(CreateParticipantTokenRequest::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(CreateParticipantTokenRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            CAPABILITIES_FIELD, DURATION_FIELD, STAGE_ARN_FIELD, USER_ID_FIELD));

    private final Map<String, String> attributes;

    private final List<String> capabilities;

    private final Integer duration;

    private final String stageArn;

    private final String userId;

    private CreateParticipantTokenRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.capabilities = builder.capabilities;
        this.duration = builder.duration;
        this.stageArn = builder.stageArn;
        this.userId = builder.userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to encode into the token and attach to a stage. Map keys and values can contain
     * UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all stage
     * participants and should not be used for personally identifying, confidential, or sensitive information.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to encode into the token and attach to a stage. Map keys and values can
     *         contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to
     *         all stage participants and should not be used for personally identifying, confidential, or sensitive
     *         information.</i>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Set of capabilities that the user is allowed to perform in the stage. Default: <code>PUBLISH, SUBSCRIBE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Set of capabilities that the user is allowed to perform in the stage. Default:
     *         <code>PUBLISH, SUBSCRIBE</code>.
     */
    public final List<ParticipantTokenCapability> capabilities() {
        return ParticipantTokenCapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Set of capabilities that the user is allowed to perform in the stage. Default: <code>PUBLISH, SUBSCRIBE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Set of capabilities that the user is allowed to perform in the stage. Default:
     *         <code>PUBLISH, SUBSCRIBE</code>.
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * Duration (in minutes), after which the token expires. Default: 60 (1 hour).
     * </p>
     * 
     * @return Duration (in minutes), after which the token expires. Default: 60 (1 hour).
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * ARN of the stage to which this token is scoped.
     * </p>
     * 
     * @return ARN of the stage to which this token is scoped.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * Name that can be specified to help identify the token. This can be any UTF-8 encoded text. <i>This field is
     * exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive
     * information.</i>
     * </p>
     * 
     * @return Name that can be specified to help identify the token. This can be any UTF-8 encoded text. <i>This field
     *         is exposed to all stage participants and should not be used for personally identifying, confidential, or
     *         sensitive information.</i>
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantTokenRequest)) {
            return false;
        }
        CreateParticipantTokenRequest other = (CreateParticipantTokenRequest) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(duration(), other.duration()) && Objects.equals(stageArn(), other.stageArn())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateParticipantTokenRequest").add("Attributes", hasAttributes() ? attributes() : null)
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null).add("Duration", duration())
                .add("StageArn", stageArn()).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantTokenRequest, T> g) {
        return obj -> g.apply((CreateParticipantTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateParticipantTokenRequest> {
        /**
         * <p>
         * Application-provided attributes to encode into the token and attach to a stage. Map keys and values can
         * contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all
         * stage participants and should not be used for personally identifying, confidential, or sensitive
         * information.</i>
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to encode into the token and attach to a stage. Map keys and values
         *        can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
         *        exposed to all stage participants and should not be used for personally identifying, confidential, or
         *        sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage. Default:
         * <code>PUBLISH, SUBSCRIBE</code>.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage. Default:
         *        <code>PUBLISH, SUBSCRIBE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage. Default:
         * <code>PUBLISH, SUBSCRIBE</code>.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage. Default:
         *        <code>PUBLISH, SUBSCRIBE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage. Default:
         * <code>PUBLISH, SUBSCRIBE</code>.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage. Default:
         *        <code>PUBLISH, SUBSCRIBE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<ParticipantTokenCapability> capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage. Default:
         * <code>PUBLISH, SUBSCRIBE</code>.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage. Default:
         *        <code>PUBLISH, SUBSCRIBE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(ParticipantTokenCapability... capabilities);

        /**
         * <p>
         * Duration (in minutes), after which the token expires. Default: 60 (1 hour).
         * </p>
         * 
         * @param duration
         *        Duration (in minutes), after which the token expires. Default: 60 (1 hour).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * ARN of the stage to which this token is scoped.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage to which this token is scoped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * Name that can be specified to help identify the token. This can be any UTF-8 encoded text. <i>This field is
         * exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param userId
         *        Name that can be specified to help identify the token. This can be any UTF-8 encoded text. <i>This
         *        field is exposed to all stage participants and should not be used for personally identifying,
         *        confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private Integer duration;

        private String stageArn;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantTokenRequest model) {
            super(model);
            attributes(model.attributes);
            capabilitiesWithStrings(model.capabilities);
            duration(model.duration);
            stageArn(model.stageArn);
            userId(model.userId);
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantTokenAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantTokenAttributesCopier.copy(attributes);
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<ParticipantTokenCapability> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(ParticipantTokenCapability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateParticipantTokenRequest build() {
            return new CreateParticipantTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
