/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse;

public class ListStageSessionsPublisher
implements SdkPublisher<ListStageSessionsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListStageSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStageSessionsPublisher(IvsRealTimeAsyncClient client, ListStageSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStageSessionsPublisher(IvsRealTimeAsyncClient client, ListStageSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStageSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStageSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStageSessionsResponseFetcher
    implements AsyncPageFetcher<ListStageSessionsResponse> {
        private ListStageSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStageSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStageSessionsResponse> nextPage(ListStageSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStageSessionsPublisher.this.client.listStageSessions(ListStageSessionsPublisher.this.firstRequest);
            }
            return ListStageSessionsPublisher.this.client.listStageSessions((ListStageSessionsRequest)((Object)ListStageSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

