/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStorageConfigurationsResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<ListStorageConfigurationsResponse.Builder, ListStorageConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStorageConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<StorageConfigurationSummary>> STORAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<StorageConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("storageConfigurations")
            .getter(getter(ListStorageConfigurationsResponse::storageConfigurations))
            .setter(setter(Builder::storageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STORAGE_CONFIGURATIONS_FIELD));

    private final String nextToken;

    private final List<StorageConfigurationSummary> storageConfigurations;

    private ListStorageConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.storageConfigurations = builder.storageConfigurations;
    }

    /**
     * <p>
     * If there are more storage configurations than <code>maxResults</code>, use <code>nextToken</code> in the request
     * to get the next set.
     * </p>
     * 
     * @return If there are more storage configurations than <code>maxResults</code>, use <code>nextToken</code> in the
     *         request to get the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStorageConfigurations() {
        return storageConfigurations != null && !(storageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the matching storage configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageConfigurations} method.
     * </p>
     * 
     * @return List of the matching storage configurations.
     */
    public final List<StorageConfigurationSummary> storageConfigurations() {
        return storageConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConfigurations() ? storageConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageConfigurationsResponse)) {
            return false;
        }
        ListStorageConfigurationsResponse other = (ListStorageConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStorageConfigurations() == other.hasStorageConfigurations()
                && Objects.equals(storageConfigurations(), other.storageConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStorageConfigurationsResponse").add("NextToken", nextToken())
                .add("StorageConfigurations", hasStorageConfigurations() ? storageConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "storageConfigurations":
            return Optional.ofNullable(clazz.cast(storageConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStorageConfigurationsResponse, T> g) {
        return obj -> g.apply((ListStorageConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStorageConfigurationsResponse> {
        /**
         * <p>
         * If there are more storage configurations than <code>maxResults</code>, use <code>nextToken</code> in the
         * request to get the next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more storage configurations than <code>maxResults</code>, use <code>nextToken</code> in
         *        the request to get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of the matching storage configurations.
         * </p>
         * 
         * @param storageConfigurations
         *        List of the matching storage configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(Collection<StorageConfigurationSummary> storageConfigurations);

        /**
         * <p>
         * List of the matching storage configurations.
         * </p>
         * 
         * @param storageConfigurations
         *        List of the matching storage configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(StorageConfigurationSummary... storageConfigurations);

        /**
         * <p>
         * List of the matching storage configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.StorageConfigurationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ivsrealtime.model.StorageConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.StorageConfigurationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #storageConfigurations(List<StorageConfigurationSummary>)}.
         * 
         * @param storageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.StorageConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfigurations(java.util.Collection<StorageConfigurationSummary>)
         */
        Builder storageConfigurations(Consumer<StorageConfigurationSummary.Builder>... storageConfigurations);
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StorageConfigurationSummary> storageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            storageConfigurations(model.storageConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StorageConfigurationSummary.Builder> getStorageConfigurations() {
            List<StorageConfigurationSummary.Builder> result = StorageConfigurationSummaryListCopier
                    .copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(Collection<StorageConfigurationSummary.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationSummaryListCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<StorageConfigurationSummary> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationSummaryListCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(StorageConfigurationSummary... storageConfigurations) {
            storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(Consumer<StorageConfigurationSummary.Builder>... storageConfigurations) {
            storageConfigurations(Stream.of(storageConfigurations)
                    .map(c -> StorageConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStorageConfigurationsResponse build() {
            return new ListStorageConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
