/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information specific to Picture-in-Picture (PiP) layout, for <a
 * href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html">server-side
 * composition</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PipConfiguration.Builder, PipConfiguration> {
    private static final SdkField<String> FEATURED_PARTICIPANT_ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("featuredParticipantAttribute")
            .getter(getter(PipConfiguration::featuredParticipantAttribute))
            .setter(setter(Builder::featuredParticipantAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featuredParticipantAttribute")
                    .build()).build();

    private static final SdkField<Integer> GRID_GAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gridGap").getter(getter(PipConfiguration::gridGap)).setter(setter(Builder::gridGap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gridGap").build()).build();

    private static final SdkField<Boolean> OMIT_STOPPED_VIDEO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("omitStoppedVideo").getter(getter(PipConfiguration::omitStoppedVideo))
            .setter(setter(Builder::omitStoppedVideo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("omitStoppedVideo").build()).build();

    private static final SdkField<String> PIP_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipBehavior").getter(getter(PipConfiguration::pipBehaviorAsString)).setter(setter(Builder::pipBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipBehavior").build()).build();

    private static final SdkField<Integer> PIP_HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pipHeight").getter(getter(PipConfiguration::pipHeight)).setter(setter(Builder::pipHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipHeight").build()).build();

    private static final SdkField<Integer> PIP_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pipOffset").getter(getter(PipConfiguration::pipOffset)).setter(setter(Builder::pipOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipOffset").build()).build();

    private static final SdkField<String> PIP_PARTICIPANT_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipParticipantAttribute").getter(getter(PipConfiguration::pipParticipantAttribute))
            .setter(setter(Builder::pipParticipantAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipParticipantAttribute").build())
            .build();

    private static final SdkField<String> PIP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipPosition").getter(getter(PipConfiguration::pipPositionAsString)).setter(setter(Builder::pipPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipPosition").build()).build();

    private static final SdkField<Integer> PIP_WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pipWidth").getter(getter(PipConfiguration::pipWidth)).setter(setter(Builder::pipWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipWidth").build()).build();

    private static final SdkField<String> VIDEO_FILL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("videoFillMode").getter(getter(PipConfiguration::videoFillModeAsString))
            .setter(setter(Builder::videoFillMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFillMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FEATURED_PARTICIPANT_ATTRIBUTE_FIELD, GRID_GAP_FIELD, OMIT_STOPPED_VIDEO_FIELD, PIP_BEHAVIOR_FIELD, PIP_HEIGHT_FIELD,
            PIP_OFFSET_FIELD, PIP_PARTICIPANT_ATTRIBUTE_FIELD, PIP_POSITION_FIELD, PIP_WIDTH_FIELD, VIDEO_FILL_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featuredParticipantAttribute;

    private final Integer gridGap;

    private final Boolean omitStoppedVideo;

    private final String pipBehavior;

    private final Integer pipHeight;

    private final Integer pipOffset;

    private final String pipParticipantAttribute;

    private final String pipPosition;

    private final Integer pipWidth;

    private final String videoFillMode;

    private PipConfiguration(BuilderImpl builder) {
        this.featuredParticipantAttribute = builder.featuredParticipantAttribute;
        this.gridGap = builder.gridGap;
        this.omitStoppedVideo = builder.omitStoppedVideo;
        this.pipBehavior = builder.pipBehavior;
        this.pipHeight = builder.pipHeight;
        this.pipOffset = builder.pipOffset;
        this.pipParticipantAttribute = builder.pipParticipantAttribute;
        this.pipPosition = builder.pipPosition;
        this.pipWidth = builder.pipWidth;
        this.videoFillMode = builder.videoFillMode;
    }

    /**
     * <p>
     * This attribute name identifies the featured slot. A participant with this attribute set to <code>"true"</code>
     * (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured slot.
     * </p>
     * 
     * @return This attribute name identifies the featured slot. A participant with this attribute set to
     *         <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured
     *         slot.
     */
    public final String featuredParticipantAttribute() {
        return featuredParticipantAttribute;
    }

    /**
     * <p>
     * Specifies the spacing between participant tiles in pixels. Default: <code>0</code>.
     * </p>
     * 
     * @return Specifies the spacing between participant tiles in pixels. Default: <code>0</code>.
     */
    public final Integer gridGap() {
        return gridGap;
    }

    /**
     * <p>
     * Determines whether to omit participants with stopped video in the composition. Default: <code>false</code>.
     * </p>
     * 
     * @return Determines whether to omit participants with stopped video in the composition. Default:
     *         <code>false</code>.
     */
    public final Boolean omitStoppedVideo() {
        return omitStoppedVideo;
    }

    /**
     * <p>
     * Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipBehavior} will
     * return {@link PipBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipBehaviorAsString}.
     * </p>
     * 
     * @return Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
     * @see PipBehavior
     */
    public final PipBehavior pipBehavior() {
        return PipBehavior.fromValue(pipBehavior);
    }

    /**
     * <p>
     * Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipBehavior} will
     * return {@link PipBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipBehaviorAsString}.
     * </p>
     * 
     * @return Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
     * @see PipBehavior
     */
    public final String pipBehaviorAsString() {
        return pipBehavior;
    }

    /**
     * <p>
     * Specifies the height of the PiP window in pixels. When this is not set explicitly, <code>pipHeight</code>’s value
     * will be based on the size of the composition and the aspect ratio of the participant’s video.
     * </p>
     * 
     * @return Specifies the height of the PiP window in pixels. When this is not set explicitly, <code>pipHeight</code>
     *         ’s value will be based on the size of the composition and the aspect ratio of the participant’s video.
     */
    public final Integer pipHeight() {
        return pipHeight;
    }

    /**
     * <p>
     * Sets the PiP window’s offset position in pixels from the closest edges determined by <code>PipPosition</code>.
     * Default: <code>0</code>.
     * </p>
     * 
     * @return Sets the PiP window’s offset position in pixels from the closest edges determined by
     *         <code>PipPosition</code>. Default: <code>0</code>.
     */
    public final Integer pipOffset() {
        return pipOffset;
    }

    /**
     * <p>
     * Identifies the PiP slot. A participant with this attribute set to <code>"true"</code> (as a string value) in
     * <a>ParticipantTokenConfiguration</a> is placed in the PiP slot.
     * </p>
     * 
     * @return Identifies the PiP slot. A participant with this attribute set to <code>"true"</code> (as a string value)
     *         in <a>ParticipantTokenConfiguration</a> is placed in the PiP slot.
     */
    public final String pipParticipantAttribute() {
        return pipParticipantAttribute;
    }

    /**
     * <p>
     * Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipPosition} will
     * return {@link PipPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipPositionAsString}.
     * </p>
     * 
     * @return Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
     * @see PipPosition
     */
    public final PipPosition pipPosition() {
        return PipPosition.fromValue(pipPosition);
    }

    /**
     * <p>
     * Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipPosition} will
     * return {@link PipPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipPositionAsString}.
     * </p>
     * 
     * @return Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
     * @see PipPosition
     */
    public final String pipPositionAsString() {
        return pipPosition;
    }

    /**
     * <p>
     * Specifies the width of the PiP window in pixels. When this is not set explicitly, <code>pipWidth</code>’s value
     * will be based on the size of the composition and the aspect ratio of the participant’s video.
     * </p>
     * 
     * @return Specifies the width of the PiP window in pixels. When this is not set explicitly, <code>pipWidth</code>’s
     *         value will be based on the size of the composition and the aspect ratio of the participant’s video.
     */
    public final Integer pipWidth() {
        return pipWidth;
    }

    /**
     * <p>
     * Defines how video fits within the participant tile. Default: <code>COVER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoFillMode}
     * will return {@link VideoFillMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoFillModeAsString}.
     * </p>
     * 
     * @return Defines how video fits within the participant tile. Default: <code>COVER</code>.
     * @see VideoFillMode
     */
    public final VideoFillMode videoFillMode() {
        return VideoFillMode.fromValue(videoFillMode);
    }

    /**
     * <p>
     * Defines how video fits within the participant tile. Default: <code>COVER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoFillMode}
     * will return {@link VideoFillMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoFillModeAsString}.
     * </p>
     * 
     * @return Defines how video fits within the participant tile. Default: <code>COVER</code>.
     * @see VideoFillMode
     */
    public final String videoFillModeAsString() {
        return videoFillMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featuredParticipantAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(gridGap());
        hashCode = 31 * hashCode + Objects.hashCode(omitStoppedVideo());
        hashCode = 31 * hashCode + Objects.hashCode(pipBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipHeight());
        hashCode = 31 * hashCode + Objects.hashCode(pipOffset());
        hashCode = 31 * hashCode + Objects.hashCode(pipParticipantAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(pipPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipWidth());
        hashCode = 31 * hashCode + Objects.hashCode(videoFillModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipConfiguration)) {
            return false;
        }
        PipConfiguration other = (PipConfiguration) obj;
        return Objects.equals(featuredParticipantAttribute(), other.featuredParticipantAttribute())
                && Objects.equals(gridGap(), other.gridGap()) && Objects.equals(omitStoppedVideo(), other.omitStoppedVideo())
                && Objects.equals(pipBehaviorAsString(), other.pipBehaviorAsString())
                && Objects.equals(pipHeight(), other.pipHeight()) && Objects.equals(pipOffset(), other.pipOffset())
                && Objects.equals(pipParticipantAttribute(), other.pipParticipantAttribute())
                && Objects.equals(pipPositionAsString(), other.pipPositionAsString())
                && Objects.equals(pipWidth(), other.pipWidth())
                && Objects.equals(videoFillModeAsString(), other.videoFillModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipConfiguration").add("FeaturedParticipantAttribute", featuredParticipantAttribute())
                .add("GridGap", gridGap()).add("OmitStoppedVideo", omitStoppedVideo()).add("PipBehavior", pipBehaviorAsString())
                .add("PipHeight", pipHeight()).add("PipOffset", pipOffset())
                .add("PipParticipantAttribute", pipParticipantAttribute()).add("PipPosition", pipPositionAsString())
                .add("PipWidth", pipWidth()).add("VideoFillMode", videoFillModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "featuredParticipantAttribute":
            return Optional.ofNullable(clazz.cast(featuredParticipantAttribute()));
        case "gridGap":
            return Optional.ofNullable(clazz.cast(gridGap()));
        case "omitStoppedVideo":
            return Optional.ofNullable(clazz.cast(omitStoppedVideo()));
        case "pipBehavior":
            return Optional.ofNullable(clazz.cast(pipBehaviorAsString()));
        case "pipHeight":
            return Optional.ofNullable(clazz.cast(pipHeight()));
        case "pipOffset":
            return Optional.ofNullable(clazz.cast(pipOffset()));
        case "pipParticipantAttribute":
            return Optional.ofNullable(clazz.cast(pipParticipantAttribute()));
        case "pipPosition":
            return Optional.ofNullable(clazz.cast(pipPositionAsString()));
        case "pipWidth":
            return Optional.ofNullable(clazz.cast(pipWidth()));
        case "videoFillMode":
            return Optional.ofNullable(clazz.cast(videoFillModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipConfiguration, T> g) {
        return obj -> g.apply((PipConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipConfiguration> {
        /**
         * <p>
         * This attribute name identifies the featured slot. A participant with this attribute set to
         * <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured
         * slot.
         * </p>
         * 
         * @param featuredParticipantAttribute
         *        This attribute name identifies the featured slot. A participant with this attribute set to
         *        <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the
         *        featured slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredParticipantAttribute(String featuredParticipantAttribute);

        /**
         * <p>
         * Specifies the spacing between participant tiles in pixels. Default: <code>0</code>.
         * </p>
         * 
         * @param gridGap
         *        Specifies the spacing between participant tiles in pixels. Default: <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gridGap(Integer gridGap);

        /**
         * <p>
         * Determines whether to omit participants with stopped video in the composition. Default: <code>false</code>.
         * </p>
         * 
         * @param omitStoppedVideo
         *        Determines whether to omit participants with stopped video in the composition. Default:
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder omitStoppedVideo(Boolean omitStoppedVideo);

        /**
         * <p>
         * Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
         * </p>
         * 
         * @param pipBehavior
         *        Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
         * @see PipBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipBehavior
         */
        Builder pipBehavior(String pipBehavior);

        /**
         * <p>
         * Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
         * </p>
         * 
         * @param pipBehavior
         *        Defines PiP behavior when all participants have left. Default: <code>STATIC</code>.
         * @see PipBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipBehavior
         */
        Builder pipBehavior(PipBehavior pipBehavior);

        /**
         * <p>
         * Specifies the height of the PiP window in pixels. When this is not set explicitly, <code>pipHeight</code>’s
         * value will be based on the size of the composition and the aspect ratio of the participant’s video.
         * </p>
         * 
         * @param pipHeight
         *        Specifies the height of the PiP window in pixels. When this is not set explicitly,
         *        <code>pipHeight</code>’s value will be based on the size of the composition and the aspect ratio of
         *        the participant’s video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipHeight(Integer pipHeight);

        /**
         * <p>
         * Sets the PiP window’s offset position in pixels from the closest edges determined by <code>PipPosition</code>
         * . Default: <code>0</code>.
         * </p>
         * 
         * @param pipOffset
         *        Sets the PiP window’s offset position in pixels from the closest edges determined by
         *        <code>PipPosition</code>. Default: <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipOffset(Integer pipOffset);

        /**
         * <p>
         * Identifies the PiP slot. A participant with this attribute set to <code>"true"</code> (as a string value) in
         * <a>ParticipantTokenConfiguration</a> is placed in the PiP slot.
         * </p>
         * 
         * @param pipParticipantAttribute
         *        Identifies the PiP slot. A participant with this attribute set to <code>"true"</code> (as a string
         *        value) in <a>ParticipantTokenConfiguration</a> is placed in the PiP slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipParticipantAttribute(String pipParticipantAttribute);

        /**
         * <p>
         * Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
         * </p>
         * 
         * @param pipPosition
         *        Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
         * @see PipPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipPosition
         */
        Builder pipPosition(String pipPosition);

        /**
         * <p>
         * Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
         * </p>
         * 
         * @param pipPosition
         *        Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.
         * @see PipPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipPosition
         */
        Builder pipPosition(PipPosition pipPosition);

        /**
         * <p>
         * Specifies the width of the PiP window in pixels. When this is not set explicitly, <code>pipWidth</code>’s
         * value will be based on the size of the composition and the aspect ratio of the participant’s video.
         * </p>
         * 
         * @param pipWidth
         *        Specifies the width of the PiP window in pixels. When this is not set explicitly,
         *        <code>pipWidth</code>’s value will be based on the size of the composition and the aspect ratio of the
         *        participant’s video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipWidth(Integer pipWidth);

        /**
         * <p>
         * Defines how video fits within the participant tile. Default: <code>COVER</code>.
         * </p>
         * 
         * @param videoFillMode
         *        Defines how video fits within the participant tile. Default: <code>COVER</code>.
         * @see VideoFillMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoFillMode
         */
        Builder videoFillMode(String videoFillMode);

        /**
         * <p>
         * Defines how video fits within the participant tile. Default: <code>COVER</code>.
         * </p>
         * 
         * @param videoFillMode
         *        Defines how video fits within the participant tile. Default: <code>COVER</code>.
         * @see VideoFillMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoFillMode
         */
        Builder videoFillMode(VideoFillMode videoFillMode);
    }

    static final class BuilderImpl implements Builder {
        private String featuredParticipantAttribute;

        private Integer gridGap;

        private Boolean omitStoppedVideo;

        private String pipBehavior;

        private Integer pipHeight;

        private Integer pipOffset;

        private String pipParticipantAttribute;

        private String pipPosition;

        private Integer pipWidth;

        private String videoFillMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PipConfiguration model) {
            featuredParticipantAttribute(model.featuredParticipantAttribute);
            gridGap(model.gridGap);
            omitStoppedVideo(model.omitStoppedVideo);
            pipBehavior(model.pipBehavior);
            pipHeight(model.pipHeight);
            pipOffset(model.pipOffset);
            pipParticipantAttribute(model.pipParticipantAttribute);
            pipPosition(model.pipPosition);
            pipWidth(model.pipWidth);
            videoFillMode(model.videoFillMode);
        }

        public final String getFeaturedParticipantAttribute() {
            return featuredParticipantAttribute;
        }

        public final void setFeaturedParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
        }

        @Override
        public final Builder featuredParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
            return this;
        }

        public final Integer getGridGap() {
            return gridGap;
        }

        public final void setGridGap(Integer gridGap) {
            this.gridGap = gridGap;
        }

        @Override
        public final Builder gridGap(Integer gridGap) {
            this.gridGap = gridGap;
            return this;
        }

        public final Boolean getOmitStoppedVideo() {
            return omitStoppedVideo;
        }

        public final void setOmitStoppedVideo(Boolean omitStoppedVideo) {
            this.omitStoppedVideo = omitStoppedVideo;
        }

        @Override
        public final Builder omitStoppedVideo(Boolean omitStoppedVideo) {
            this.omitStoppedVideo = omitStoppedVideo;
            return this;
        }

        public final String getPipBehavior() {
            return pipBehavior;
        }

        public final void setPipBehavior(String pipBehavior) {
            this.pipBehavior = pipBehavior;
        }

        @Override
        public final Builder pipBehavior(String pipBehavior) {
            this.pipBehavior = pipBehavior;
            return this;
        }

        @Override
        public final Builder pipBehavior(PipBehavior pipBehavior) {
            this.pipBehavior(pipBehavior == null ? null : pipBehavior.toString());
            return this;
        }

        public final Integer getPipHeight() {
            return pipHeight;
        }

        public final void setPipHeight(Integer pipHeight) {
            this.pipHeight = pipHeight;
        }

        @Override
        public final Builder pipHeight(Integer pipHeight) {
            this.pipHeight = pipHeight;
            return this;
        }

        public final Integer getPipOffset() {
            return pipOffset;
        }

        public final void setPipOffset(Integer pipOffset) {
            this.pipOffset = pipOffset;
        }

        @Override
        public final Builder pipOffset(Integer pipOffset) {
            this.pipOffset = pipOffset;
            return this;
        }

        public final String getPipParticipantAttribute() {
            return pipParticipantAttribute;
        }

        public final void setPipParticipantAttribute(String pipParticipantAttribute) {
            this.pipParticipantAttribute = pipParticipantAttribute;
        }

        @Override
        public final Builder pipParticipantAttribute(String pipParticipantAttribute) {
            this.pipParticipantAttribute = pipParticipantAttribute;
            return this;
        }

        public final String getPipPosition() {
            return pipPosition;
        }

        public final void setPipPosition(String pipPosition) {
            this.pipPosition = pipPosition;
        }

        @Override
        public final Builder pipPosition(String pipPosition) {
            this.pipPosition = pipPosition;
            return this;
        }

        @Override
        public final Builder pipPosition(PipPosition pipPosition) {
            this.pipPosition(pipPosition == null ? null : pipPosition.toString());
            return this;
        }

        public final Integer getPipWidth() {
            return pipWidth;
        }

        public final void setPipWidth(Integer pipWidth) {
            this.pipWidth = pipWidth;
        }

        @Override
        public final Builder pipWidth(Integer pipWidth) {
            this.pipWidth = pipWidth;
            return this;
        }

        public final String getVideoFillMode() {
            return videoFillMode;
        }

        public final void setVideoFillMode(String videoFillMode) {
            this.videoFillMode = videoFillMode;
        }

        @Override
        public final Builder videoFillMode(String videoFillMode) {
            this.videoFillMode = videoFillMode;
            return this;
        }

        @Override
        public final Builder videoFillMode(VideoFillMode videoFillMode) {
            this.videoFillMode(videoFillMode == null ? null : videoFillMode.toString());
            return this;
        }

        @Override
        public PipConfiguration build() {
            return new PipConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
