/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object describing a participant that has joined a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Participant implements SdkPojo, Serializable, ToCopyableBuilder<Participant.Builder, Participant> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(Participant::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(Participant::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Participant::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstJoinTime")
            .getter(getter(Participant::firstJoinTime))
            .setter(setter(Builder::firstJoinTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(Participant::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("published").getter(getter(Participant::published)).setter(setter(Builder::published))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()).build();

    private static final SdkField<String> ISP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ispName").getter(getter(Participant::ispName)).setter(setter(Builder::ispName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ispName").build()).build();

    private static final SdkField<String> OS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("osName")
            .getter(getter(Participant::osName)).setter(setter(Builder::osName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osName").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osVersion").getter(getter(Participant::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()).build();

    private static final SdkField<String> BROWSER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserName").getter(getter(Participant::browserName)).setter(setter(Builder::browserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserName").build()).build();

    private static final SdkField<String> BROWSER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserVersion").getter(getter(Participant::browserVersion)).setter(setter(Builder::browserVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserVersion").build()).build();

    private static final SdkField<String> SDK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sdkVersion").getter(getter(Participant::sdkVersion)).setter(setter(Builder::sdkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdkVersion").build()).build();

    private static final SdkField<String> RECORDING_S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingS3BucketName").getter(getter(Participant::recordingS3BucketName))
            .setter(setter(Builder::recordingS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingS3BucketName").build())
            .build();

    private static final SdkField<String> RECORDING_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingS3Prefix").getter(getter(Participant::recordingS3Prefix))
            .setter(setter(Builder::recordingS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingS3Prefix").build()).build();

    private static final SdkField<String> RECORDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingState").getter(getter(Participant::recordingStateAsString))
            .setter(setter(Builder::recordingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD,
            USER_ID_FIELD, STATE_FIELD, FIRST_JOIN_TIME_FIELD, ATTRIBUTES_FIELD, PUBLISHED_FIELD, ISP_NAME_FIELD, OS_NAME_FIELD,
            OS_VERSION_FIELD, BROWSER_NAME_FIELD, BROWSER_VERSION_FIELD, SDK_VERSION_FIELD, RECORDING_S3_BUCKET_NAME_FIELD,
            RECORDING_S3_PREFIX_FIELD, RECORDING_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String participantId;

    private final String userId;

    private final String state;

    private final Instant firstJoinTime;

    private final Map<String, String> attributes;

    private final Boolean published;

    private final String ispName;

    private final String osName;

    private final String osVersion;

    private final String browserName;

    private final String browserVersion;

    private final String sdkVersion;

    private final String recordingS3BucketName;

    private final String recordingS3Prefix;

    private final String recordingState;

    private Participant(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.userId = builder.userId;
        this.state = builder.state;
        this.firstJoinTime = builder.firstJoinTime;
        this.attributes = builder.attributes;
        this.published = builder.published;
        this.ispName = builder.ispName;
        this.osName = builder.osName;
        this.osVersion = builder.osVersion;
        this.browserName = builder.browserName;
        this.browserVersion = builder.browserVersion;
        this.sdkVersion = builder.sdkVersion;
        this.recordingS3BucketName = builder.recordingS3BucketName;
        this.recordingS3Prefix = builder.recordingS3Prefix;
        this.recordingState = builder.recordingState;
    }

    /**
     * <p>
     * Unique identifier for this participant, assigned by IVS.
     * </p>
     * 
     * @return Unique identifier for this participant, assigned by IVS.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
     * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants
     * and should not be used for personally identifying, confidential, or sensitive information</i>.
     * </p>
     * 
     * @return Customer-assigned name to help identify the token; this can be used to link a participant to a user in
     *         the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
     *         participants and should not be used for personally identifying, confidential, or sensitive
     *         information</i>.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Whether the participant is connected to or disconnected from the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Whether the participant is connected to or disconnected from the stage.
     * @see ParticipantState
     */
    public final ParticipantState state() {
        return ParticipantState.fromValue(state);
    }

    /**
     * <p>
     * Whether the participant is connected to or disconnected from the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Whether the participant is connected to or disconnected from the stage.
     * @see ParticipantState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     * </p>
     * 
     * @return ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     */
    public final Instant firstJoinTime() {
        return firstJoinTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to encode into the token and attach to a stage. Map keys and values can contain
     * UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all stage
     * participants and should not be used for personally identifying, confidential, or sensitive information</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to encode into the token and attach to a stage. Map keys and values can
     *         contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to
     *         all stage participants and should not be used for personally identifying, confidential, or sensitive
     *         information</i>.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Whether the participant ever published to the stage session.
     * </p>
     * 
     * @return Whether the participant ever published to the stage session.
     */
    public final Boolean published() {
        return published;
    }

    /**
     * <p>
     * The participant’s Internet Service Provider.
     * </p>
     * 
     * @return The participant’s Internet Service Provider.
     */
    public final String ispName() {
        return ispName;
    }

    /**
     * <p>
     * The participant’s operating system.
     * </p>
     * 
     * @return The participant’s operating system.
     */
    public final String osName() {
        return osName;
    }

    /**
     * <p>
     * The participant’s operating system version.
     * </p>
     * 
     * @return The participant’s operating system version.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * <p>
     * The participant’s browser.
     * </p>
     * 
     * @return The participant’s browser.
     */
    public final String browserName() {
        return browserName;
    }

    /**
     * <p>
     * The participant’s browser version.
     * </p>
     * 
     * @return The participant’s browser version.
     */
    public final String browserVersion() {
        return browserVersion;
    }

    /**
     * <p>
     * The participant’s SDK version.
     * </p>
     * 
     * @return The participant’s SDK version.
     */
    public final String sdkVersion() {
        return sdkVersion;
    }

    /**
     * <p>
     * Name of the S3 bucket to where the participant is being recorded, if individual participant recording is enabled,
     * or <code>""</code> (empty string), if recording is not enabled.
     * </p>
     * 
     * @return Name of the S3 bucket to where the participant is being recorded, if individual participant recording is
     *         enabled, or <code>""</code> (empty string), if recording is not enabled.
     */
    public final String recordingS3BucketName() {
        return recordingS3BucketName;
    }

    /**
     * <p>
     * S3 prefix of the S3 bucket where the participant is being recorded, if individual participant recording is
     * enabled, or <code>""</code> (empty string), if recording is not enabled.
     * </p>
     * 
     * @return S3 prefix of the S3 bucket where the participant is being recorded, if individual participant recording
     *         is enabled, or <code>""</code> (empty string), if recording is not enabled.
     */
    public final String recordingS3Prefix() {
        return recordingS3Prefix;
    }

    /**
     * <p>
     * The participant’s recording state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingState}
     * will return {@link ParticipantRecordingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #recordingStateAsString}.
     * </p>
     * 
     * @return The participant’s recording state.
     * @see ParticipantRecordingState
     */
    public final ParticipantRecordingState recordingState() {
        return ParticipantRecordingState.fromValue(recordingState);
    }

    /**
     * <p>
     * The participant’s recording state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingState}
     * will return {@link ParticipantRecordingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #recordingStateAsString}.
     * </p>
     * 
     * @return The participant’s recording state.
     * @see ParticipantRecordingState
     */
    public final String recordingStateAsString() {
        return recordingState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(published());
        hashCode = 31 * hashCode + Objects.hashCode(ispName());
        hashCode = 31 * hashCode + Objects.hashCode(osName());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(browserName());
        hashCode = 31 * hashCode + Objects.hashCode(browserVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(recordingS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(recordingS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(recordingStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant) obj;
        return Objects.equals(participantId(), other.participantId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(firstJoinTime(), other.firstJoinTime()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(published(), other.published())
                && Objects.equals(ispName(), other.ispName()) && Objects.equals(osName(), other.osName())
                && Objects.equals(osVersion(), other.osVersion()) && Objects.equals(browserName(), other.browserName())
                && Objects.equals(browserVersion(), other.browserVersion()) && Objects.equals(sdkVersion(), other.sdkVersion())
                && Objects.equals(recordingS3BucketName(), other.recordingS3BucketName())
                && Objects.equals(recordingS3Prefix(), other.recordingS3Prefix())
                && Objects.equals(recordingStateAsString(), other.recordingStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Participant").add("ParticipantId", participantId()).add("UserId", userId())
                .add("State", stateAsString()).add("FirstJoinTime", firstJoinTime())
                .add("Attributes", hasAttributes() ? attributes() : null).add("Published", published()).add("IspName", ispName())
                .add("OsName", osName()).add("OsVersion", osVersion()).add("BrowserName", browserName())
                .add("BrowserVersion", browserVersion()).add("SdkVersion", sdkVersion())
                .add("RecordingS3BucketName", recordingS3BucketName()).add("RecordingS3Prefix", recordingS3Prefix())
                .add("RecordingState", recordingStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "firstJoinTime":
            return Optional.ofNullable(clazz.cast(firstJoinTime()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "published":
            return Optional.ofNullable(clazz.cast(published()));
        case "ispName":
            return Optional.ofNullable(clazz.cast(ispName()));
        case "osName":
            return Optional.ofNullable(clazz.cast(osName()));
        case "osVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "browserName":
            return Optional.ofNullable(clazz.cast(browserName()));
        case "browserVersion":
            return Optional.ofNullable(clazz.cast(browserVersion()));
        case "sdkVersion":
            return Optional.ofNullable(clazz.cast(sdkVersion()));
        case "recordingS3BucketName":
            return Optional.ofNullable(clazz.cast(recordingS3BucketName()));
        case "recordingS3Prefix":
            return Optional.ofNullable(clazz.cast(recordingS3Prefix()));
        case "recordingState":
            return Optional.ofNullable(clazz.cast(recordingStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Participant, T> g) {
        return obj -> g.apply((Participant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Participant> {
        /**
         * <p>
         * Unique identifier for this participant, assigned by IVS.
         * </p>
         * 
         * @param participantId
         *        Unique identifier for this participant, assigned by IVS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
         * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         * participants and should not be used for personally identifying, confidential, or sensitive information</i>.
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the token; this can be used to link a participant to a user in
         *        the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         *        participants and should not be used for personally identifying, confidential, or sensitive
         *        information</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Whether the participant is connected to or disconnected from the stage.
         * </p>
         * 
         * @param state
         *        Whether the participant is connected to or disconnected from the stage.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(String state);

        /**
         * <p>
         * Whether the participant is connected to or disconnected from the stage.
         * </p>
         * 
         * @param state
         *        Whether the participant is connected to or disconnected from the stage.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(ParticipantState state);

        /**
         * <p>
         * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         * </p>
         * 
         * @param firstJoinTime
         *        ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstJoinTime(Instant firstJoinTime);

        /**
         * <p>
         * Application-provided attributes to encode into the token and attach to a stage. Map keys and values can
         * contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all
         * stage participants and should not be used for personally identifying, confidential, or sensitive
         * information</i>.
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to encode into the token and attach to a stage. Map keys and values
         *        can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
         *        exposed to all stage participants and should not be used for personally identifying, confidential, or
         *        sensitive information</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Whether the participant ever published to the stage session.
         * </p>
         * 
         * @param published
         *        Whether the participant ever published to the stage session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder published(Boolean published);

        /**
         * <p>
         * The participant’s Internet Service Provider.
         * </p>
         * 
         * @param ispName
         *        The participant’s Internet Service Provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ispName(String ispName);

        /**
         * <p>
         * The participant’s operating system.
         * </p>
         * 
         * @param osName
         *        The participant’s operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osName(String osName);

        /**
         * <p>
         * The participant’s operating system version.
         * </p>
         * 
         * @param osVersion
         *        The participant’s operating system version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The participant’s browser.
         * </p>
         * 
         * @param browserName
         *        The participant’s browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserName(String browserName);

        /**
         * <p>
         * The participant’s browser version.
         * </p>
         * 
         * @param browserVersion
         *        The participant’s browser version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserVersion(String browserVersion);

        /**
         * <p>
         * The participant’s SDK version.
         * </p>
         * 
         * @param sdkVersion
         *        The participant’s SDK version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdkVersion(String sdkVersion);

        /**
         * <p>
         * Name of the S3 bucket to where the participant is being recorded, if individual participant recording is
         * enabled, or <code>""</code> (empty string), if recording is not enabled.
         * </p>
         * 
         * @param recordingS3BucketName
         *        Name of the S3 bucket to where the participant is being recorded, if individual participant recording
         *        is enabled, or <code>""</code> (empty string), if recording is not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingS3BucketName(String recordingS3BucketName);

        /**
         * <p>
         * S3 prefix of the S3 bucket where the participant is being recorded, if individual participant recording is
         * enabled, or <code>""</code> (empty string), if recording is not enabled.
         * </p>
         * 
         * @param recordingS3Prefix
         *        S3 prefix of the S3 bucket where the participant is being recorded, if individual participant
         *        recording is enabled, or <code>""</code> (empty string), if recording is not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingS3Prefix(String recordingS3Prefix);

        /**
         * <p>
         * The participant’s recording state.
         * </p>
         * 
         * @param recordingState
         *        The participant’s recording state.
         * @see ParticipantRecordingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRecordingState
         */
        Builder recordingState(String recordingState);

        /**
         * <p>
         * The participant’s recording state.
         * </p>
         * 
         * @param recordingState
         *        The participant’s recording state.
         * @see ParticipantRecordingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRecordingState
         */
        Builder recordingState(ParticipantRecordingState recordingState);
    }

    static final class BuilderImpl implements Builder {
        private String participantId;

        private String userId;

        private String state;

        private Instant firstJoinTime;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Boolean published;

        private String ispName;

        private String osName;

        private String osVersion;

        private String browserName;

        private String browserVersion;

        private String sdkVersion;

        private String recordingS3BucketName;

        private String recordingS3Prefix;

        private String recordingState;

        private BuilderImpl() {
        }

        private BuilderImpl(Participant model) {
            participantId(model.participantId);
            userId(model.userId);
            state(model.state);
            firstJoinTime(model.firstJoinTime);
            attributes(model.attributes);
            published(model.published);
            ispName(model.ispName);
            osName(model.osName);
            osVersion(model.osVersion);
            browserName(model.browserName);
            browserVersion(model.browserVersion);
            sdkVersion(model.sdkVersion);
            recordingS3BucketName(model.recordingS3BucketName);
            recordingS3Prefix(model.recordingS3Prefix);
            recordingState(model.recordingState);
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getFirstJoinTime() {
            return firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final Boolean getPublished() {
            return published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getIspName() {
            return ispName;
        }

        public final void setIspName(String ispName) {
            this.ispName = ispName;
        }

        @Override
        public final Builder ispName(String ispName) {
            this.ispName = ispName;
            return this;
        }

        public final String getOsName() {
            return osName;
        }

        public final void setOsName(String osName) {
            this.osName = osName;
        }

        @Override
        public final Builder osName(String osName) {
            this.osName = osName;
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getBrowserName() {
            return browserName;
        }

        public final void setBrowserName(String browserName) {
            this.browserName = browserName;
        }

        @Override
        public final Builder browserName(String browserName) {
            this.browserName = browserName;
            return this;
        }

        public final String getBrowserVersion() {
            return browserVersion;
        }

        public final void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        @Override
        public final Builder browserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public final String getSdkVersion() {
            return sdkVersion;
        }

        public final void setSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
        }

        @Override
        public final Builder sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public final String getRecordingS3BucketName() {
            return recordingS3BucketName;
        }

        public final void setRecordingS3BucketName(String recordingS3BucketName) {
            this.recordingS3BucketName = recordingS3BucketName;
        }

        @Override
        public final Builder recordingS3BucketName(String recordingS3BucketName) {
            this.recordingS3BucketName = recordingS3BucketName;
            return this;
        }

        public final String getRecordingS3Prefix() {
            return recordingS3Prefix;
        }

        public final void setRecordingS3Prefix(String recordingS3Prefix) {
            this.recordingS3Prefix = recordingS3Prefix;
        }

        @Override
        public final Builder recordingS3Prefix(String recordingS3Prefix) {
            this.recordingS3Prefix = recordingS3Prefix;
            return this;
        }

        public final String getRecordingState() {
            return recordingState;
        }

        public final void setRecordingState(String recordingState) {
            this.recordingState = recordingState;
        }

        @Override
        public final Builder recordingState(String recordingState) {
            this.recordingState = recordingState;
            return this;
        }

        @Override
        public final Builder recordingState(ParticipantRecordingState recordingState) {
            this.recordingState(recordingState == null ? null : recordingState.toString());
            return this;
        }

        @Override
        public Participant build() {
            return new Participant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
