/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about various endpoints for a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageEndpoints implements SdkPojo, Serializable, ToCopyableBuilder<StageEndpoints.Builder, StageEndpoints> {
    private static final SdkField<String> EVENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("events")
            .getter(getter(StageEndpoints::events)).setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build()).build();

    private static final SdkField<String> WHIP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("whip")
            .getter(getter(StageEndpoints::whip)).setter(setter(Builder::whip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whip").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, WHIP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String events;

    private final String whip;

    private StageEndpoints(BuilderImpl builder) {
        this.events = builder.events;
        this.whip = builder.whip;
    }

    /**
     * <p>
     * Events endpoint.
     * </p>
     * 
     * @return Events endpoint.
     */
    public final String events() {
        return events;
    }

    /**
     * <p>
     * WHIP endpoint.
     * </p>
     * 
     * @return WHIP endpoint.
     */
    public final String whip() {
        return whip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(whip());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageEndpoints)) {
            return false;
        }
        StageEndpoints other = (StageEndpoints) obj;
        return Objects.equals(events(), other.events()) && Objects.equals(whip(), other.whip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageEndpoints").add("Events", events()).add("Whip", whip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "whip":
            return Optional.ofNullable(clazz.cast(whip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageEndpoints, T> g) {
        return obj -> g.apply((StageEndpoints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageEndpoints> {
        /**
         * <p>
         * Events endpoint.
         * </p>
         * 
         * @param events
         *        Events endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(String events);

        /**
         * <p>
         * WHIP endpoint.
         * </p>
         * 
         * @param whip
         *        WHIP endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whip(String whip);
    }

    static final class BuilderImpl implements Builder {
        private String events;

        private String whip;

        private BuilderImpl() {
        }

        private BuilderImpl(StageEndpoints model) {
            events(model.events);
            whip(model.whip);
        }

        public final String getEvents() {
            return events;
        }

        public final void setEvents(String events) {
            this.events = events;
        }

        @Override
        public final Builder events(String events) {
            this.events = events;
            return this;
        }

        public final String getWhip() {
            return whip;
        }

        public final void setWhip(String whip) {
            this.whip = whip;
        }

        @Override
        public final Builder whip(String whip) {
            this.whip = whip;
            return this;
        }

        @Override
        public StageEndpoints build() {
            return new StageEndpoints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
