/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCompositionRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<StartCompositionRequest.Builder, StartCompositionRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(StartCompositionRequest::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("idempotencyToken")
            .getter(getter(StartCompositionRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<LayoutConfiguration> LAYOUT_FIELD = SdkField
            .<LayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("layout")
            .getter(getter(StartCompositionRequest::layout)).setter(setter(Builder::layout))
            .constructor(LayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layout").build()).build();

    private static final SdkField<List<DestinationConfiguration>> DESTINATIONS_FIELD = SdkField
            .<List<DestinationConfiguration>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(StartCompositionRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartCompositionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD,
            IDEMPOTENCY_TOKEN_FIELD, LAYOUT_FIELD, DESTINATIONS_FIELD, TAGS_FIELD));

    private final String stageArn;

    private final String idempotencyToken;

    private final LayoutConfiguration layout;

    private final List<DestinationConfiguration> destinations;

    private final Map<String, String> tags;

    private StartCompositionRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.layout = builder.layout;
        this.destinations = builder.destinations;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * ARN of the stage to be used for compositing.
     * </p>
     * 
     * @return ARN of the stage to be used for compositing.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * Idempotency token.
     * </p>
     * 
     * @return Idempotency token.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Layout object to configure composition parameters.
     * </p>
     * 
     * @return Layout object to configure composition parameters.
     */
    public final LayoutConfiguration layout() {
        return layout;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of destination configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return Array of destination configuration.
     */
    public final List<DestinationConfiguration> destinations() {
        return destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     * on tags beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>
     *         for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
     *         IVS has no constraints on tags beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(layout());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCompositionRequest)) {
            return false;
        }
        StartCompositionRequest other = (StartCompositionRequest) obj;
        return Objects.equals(stageArn(), other.stageArn()) && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(layout(), other.layout()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCompositionRequest").add("StageArn", stageArn())
                .add("IdempotencyToken", idempotencyToken()).add("Layout", layout())
                .add("Destinations", hasDestinations() ? destinations() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "idempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "layout":
            return Optional.ofNullable(clazz.cast(layout()));
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCompositionRequest, T> g) {
        return obj -> g.apply((StartCompositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCompositionRequest> {
        /**
         * <p>
         * ARN of the stage to be used for compositing.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage to be used for compositing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * Idempotency token.
         * </p>
         * 
         * @param idempotencyToken
         *        Idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Layout object to configure composition parameters.
         * </p>
         * 
         * @param layout
         *        Layout object to configure composition parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layout(LayoutConfiguration layout);

        /**
         * <p>
         * Layout object to configure composition parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutConfiguration.Builder} avoiding the
         * need to create one manually via {@link LayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #layout(LayoutConfiguration)}.
         * 
         * @param layout
         *        a consumer that will call methods on {@link LayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layout(LayoutConfiguration)
         */
        default Builder layout(Consumer<LayoutConfiguration.Builder> layout) {
            return layout(LayoutConfiguration.builder().applyMutation(layout).build());
        }

        /**
         * <p>
         * Array of destination configuration.
         * </p>
         * 
         * @param destinations
         *        Array of destination configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<DestinationConfiguration> destinations);

        /**
         * <p>
         * Array of destination configuration.
         * </p>
         * 
         * @param destinations
         *        Array of destination configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(DestinationConfiguration... destinations);

        /**
         * <p>
         * Array of destination configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.DestinationConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ivsrealtime.model.DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.DestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<DestinationConfiguration>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<DestinationConfiguration>)
         */
        Builder destinations(Consumer<DestinationConfiguration.Builder>... destinations);

        /**
         * <p>
         * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
         * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         * constraints on tags beyond what is documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
         *        See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>
         *        for details, including restrictions that apply to tags and "Tag naming limits and requirements";
         *        Amazon IVS has no constraints on tags beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String stageArn;

        private String idempotencyToken;

        private LayoutConfiguration layout;

        private List<DestinationConfiguration> destinations = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCompositionRequest model) {
            super(model);
            stageArn(model.stageArn);
            idempotencyToken(model.idempotencyToken);
            layout(model.layout);
            destinations(model.destinations);
            tags(model.tags);
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final LayoutConfiguration.Builder getLayout() {
            return layout != null ? layout.toBuilder() : null;
        }

        public final void setLayout(LayoutConfiguration.BuilderImpl layout) {
            this.layout = layout != null ? layout.build() : null;
        }

        @Override
        public final Builder layout(LayoutConfiguration layout) {
            this.layout = layout;
            return this;
        }

        public final List<DestinationConfiguration.Builder> getDestinations() {
            List<DestinationConfiguration.Builder> result = DestinationConfigurationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<DestinationConfiguration.BuilderImpl> destinations) {
            this.destinations = DestinationConfigurationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<DestinationConfiguration> destinations) {
            this.destinations = DestinationConfigurationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationConfiguration... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<DestinationConfiguration.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> DestinationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCompositionRequest build() {
            return new StartCompositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
