/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information specific to Grid layout, for server-side composition. See "Layouts" in <a
 * href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html">Server-Side
 * Composition</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GridConfiguration.Builder, GridConfiguration> {
    private static final SdkField<String> FEATURED_PARTICIPANT_ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("featuredParticipantAttribute")
            .getter(getter(GridConfiguration::featuredParticipantAttribute))
            .setter(setter(Builder::featuredParticipantAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featuredParticipantAttribute")
                    .build()).build();

    private static final SdkField<Boolean> OMIT_STOPPED_VIDEO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("omitStoppedVideo").getter(getter(GridConfiguration::omitStoppedVideo))
            .setter(setter(Builder::omitStoppedVideo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("omitStoppedVideo").build()).build();

    private static final SdkField<String> VIDEO_ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("videoAspectRatio").getter(getter(GridConfiguration::videoAspectRatioAsString))
            .setter(setter(Builder::videoAspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoAspectRatio").build()).build();

    private static final SdkField<String> VIDEO_FILL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("videoFillMode").getter(getter(GridConfiguration::videoFillModeAsString))
            .setter(setter(Builder::videoFillMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFillMode").build()).build();

    private static final SdkField<Integer> GRID_GAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gridGap").getter(getter(GridConfiguration::gridGap)).setter(setter(Builder::gridGap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gridGap").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FEATURED_PARTICIPANT_ATTRIBUTE_FIELD, OMIT_STOPPED_VIDEO_FIELD, VIDEO_ASPECT_RATIO_FIELD, VIDEO_FILL_MODE_FIELD,
            GRID_GAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featuredParticipantAttribute;

    private final Boolean omitStoppedVideo;

    private final String videoAspectRatio;

    private final String videoFillMode;

    private final Integer gridGap;

    private GridConfiguration(BuilderImpl builder) {
        this.featuredParticipantAttribute = builder.featuredParticipantAttribute;
        this.omitStoppedVideo = builder.omitStoppedVideo;
        this.videoAspectRatio = builder.videoAspectRatio;
        this.videoFillMode = builder.videoFillMode;
        this.gridGap = builder.gridGap;
    }

    /**
     * <p>
     * This attribute name identifies the featured slot. A participant with this attribute set to <code>"true"</code>
     * (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured slot. Default:
     * <code>""</code> (no featured participant).
     * </p>
     * 
     * @return This attribute name identifies the featured slot. A participant with this attribute set to
     *         <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured
     *         slot. Default: <code>""</code> (no featured participant).
     */
    public final String featuredParticipantAttribute() {
        return featuredParticipantAttribute;
    }

    /**
     * <p>
     * Determines whether to omit participants with stopped video in the composition. Default: <code>false</code>.
     * </p>
     * 
     * @return Determines whether to omit participants with stopped video in the composition. Default:
     *         <code>false</code>.
     */
    public final Boolean omitStoppedVideo() {
        return omitStoppedVideo;
    }

    /**
     * <p>
     * Sets the non-featured participant display mode, to control the aspect ratio of video tiles. <code>VIDEO</code> is
     * 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default: <code>VIDEO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoAspectRatio}
     * will return {@link VideoAspectRatio#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #videoAspectRatioAsString}.
     * </p>
     * 
     * @return Sets the non-featured participant display mode, to control the aspect ratio of video tiles.
     *         <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default:
     *         <code>VIDEO</code>.
     * @see VideoAspectRatio
     */
    public final VideoAspectRatio videoAspectRatio() {
        return VideoAspectRatio.fromValue(videoAspectRatio);
    }

    /**
     * <p>
     * Sets the non-featured participant display mode, to control the aspect ratio of video tiles. <code>VIDEO</code> is
     * 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default: <code>VIDEO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoAspectRatio}
     * will return {@link VideoAspectRatio#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #videoAspectRatioAsString}.
     * </p>
     * 
     * @return Sets the non-featured participant display mode, to control the aspect ratio of video tiles.
     *         <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default:
     *         <code>VIDEO</code>.
     * @see VideoAspectRatio
     */
    public final String videoAspectRatioAsString() {
        return videoAspectRatio;
    }

    /**
     * <p>
     * Defines how video content fits within the participant tile: <code>FILL</code> (stretched), <code>COVER</code>
     * (cropped), or <code>CONTAIN</code> (letterboxed). When not set, <code>videoFillMode</code> defaults to
     * <code>COVER</code> fill mode for participants in the grid and to <code>CONTAIN</code> fill mode for featured
     * participants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoFillMode}
     * will return {@link VideoFillMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoFillModeAsString}.
     * </p>
     * 
     * @return Defines how video content fits within the participant tile: <code>FILL</code> (stretched),
     *         <code>COVER</code> (cropped), or <code>CONTAIN</code> (letterboxed). When not set,
     *         <code>videoFillMode</code> defaults to <code>COVER</code> fill mode for participants in the grid and to
     *         <code>CONTAIN</code> fill mode for featured participants.
     * @see VideoFillMode
     */
    public final VideoFillMode videoFillMode() {
        return VideoFillMode.fromValue(videoFillMode);
    }

    /**
     * <p>
     * Defines how video content fits within the participant tile: <code>FILL</code> (stretched), <code>COVER</code>
     * (cropped), or <code>CONTAIN</code> (letterboxed). When not set, <code>videoFillMode</code> defaults to
     * <code>COVER</code> fill mode for participants in the grid and to <code>CONTAIN</code> fill mode for featured
     * participants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoFillMode}
     * will return {@link VideoFillMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoFillModeAsString}.
     * </p>
     * 
     * @return Defines how video content fits within the participant tile: <code>FILL</code> (stretched),
     *         <code>COVER</code> (cropped), or <code>CONTAIN</code> (letterboxed). When not set,
     *         <code>videoFillMode</code> defaults to <code>COVER</code> fill mode for participants in the grid and to
     *         <code>CONTAIN</code> fill mode for featured participants.
     * @see VideoFillMode
     */
    public final String videoFillModeAsString() {
        return videoFillMode;
    }

    /**
     * <p>
     * Specifies the spacing between participant tiles in pixels. Default: <code>2</code>.
     * </p>
     * 
     * @return Specifies the spacing between participant tiles in pixels. Default: <code>2</code>.
     */
    public final Integer gridGap() {
        return gridGap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featuredParticipantAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(omitStoppedVideo());
        hashCode = 31 * hashCode + Objects.hashCode(videoAspectRatioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoFillModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gridGap());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridConfiguration)) {
            return false;
        }
        GridConfiguration other = (GridConfiguration) obj;
        return Objects.equals(featuredParticipantAttribute(), other.featuredParticipantAttribute())
                && Objects.equals(omitStoppedVideo(), other.omitStoppedVideo())
                && Objects.equals(videoAspectRatioAsString(), other.videoAspectRatioAsString())
                && Objects.equals(videoFillModeAsString(), other.videoFillModeAsString())
                && Objects.equals(gridGap(), other.gridGap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridConfiguration").add("FeaturedParticipantAttribute", featuredParticipantAttribute())
                .add("OmitStoppedVideo", omitStoppedVideo()).add("VideoAspectRatio", videoAspectRatioAsString())
                .add("VideoFillMode", videoFillModeAsString()).add("GridGap", gridGap()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "featuredParticipantAttribute":
            return Optional.ofNullable(clazz.cast(featuredParticipantAttribute()));
        case "omitStoppedVideo":
            return Optional.ofNullable(clazz.cast(omitStoppedVideo()));
        case "videoAspectRatio":
            return Optional.ofNullable(clazz.cast(videoAspectRatioAsString()));
        case "videoFillMode":
            return Optional.ofNullable(clazz.cast(videoFillModeAsString()));
        case "gridGap":
            return Optional.ofNullable(clazz.cast(gridGap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GridConfiguration, T> g) {
        return obj -> g.apply((GridConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridConfiguration> {
        /**
         * <p>
         * This attribute name identifies the featured slot. A participant with this attribute set to
         * <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured
         * slot. Default: <code>""</code> (no featured participant).
         * </p>
         * 
         * @param featuredParticipantAttribute
         *        This attribute name identifies the featured slot. A participant with this attribute set to
         *        <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the
         *        featured slot. Default: <code>""</code> (no featured participant).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredParticipantAttribute(String featuredParticipantAttribute);

        /**
         * <p>
         * Determines whether to omit participants with stopped video in the composition. Default: <code>false</code>.
         * </p>
         * 
         * @param omitStoppedVideo
         *        Determines whether to omit participants with stopped video in the composition. Default:
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder omitStoppedVideo(Boolean omitStoppedVideo);

        /**
         * <p>
         * Sets the non-featured participant display mode, to control the aspect ratio of video tiles.
         * <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default:
         * <code>VIDEO</code>.
         * </p>
         * 
         * @param videoAspectRatio
         *        Sets the non-featured participant display mode, to control the aspect ratio of video tiles.
         *        <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default:
         *        <code>VIDEO</code>.
         * @see VideoAspectRatio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoAspectRatio
         */
        Builder videoAspectRatio(String videoAspectRatio);

        /**
         * <p>
         * Sets the non-featured participant display mode, to control the aspect ratio of video tiles.
         * <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default:
         * <code>VIDEO</code>.
         * </p>
         * 
         * @param videoAspectRatio
         *        Sets the non-featured participant display mode, to control the aspect ratio of video tiles.
         *        <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default:
         *        <code>VIDEO</code>.
         * @see VideoAspectRatio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoAspectRatio
         */
        Builder videoAspectRatio(VideoAspectRatio videoAspectRatio);

        /**
         * <p>
         * Defines how video content fits within the participant tile: <code>FILL</code> (stretched), <code>COVER</code>
         * (cropped), or <code>CONTAIN</code> (letterboxed). When not set, <code>videoFillMode</code> defaults to
         * <code>COVER</code> fill mode for participants in the grid and to <code>CONTAIN</code> fill mode for featured
         * participants.
         * </p>
         * 
         * @param videoFillMode
         *        Defines how video content fits within the participant tile: <code>FILL</code> (stretched),
         *        <code>COVER</code> (cropped), or <code>CONTAIN</code> (letterboxed). When not set,
         *        <code>videoFillMode</code> defaults to <code>COVER</code> fill mode for participants in the grid and
         *        to <code>CONTAIN</code> fill mode for featured participants.
         * @see VideoFillMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoFillMode
         */
        Builder videoFillMode(String videoFillMode);

        /**
         * <p>
         * Defines how video content fits within the participant tile: <code>FILL</code> (stretched), <code>COVER</code>
         * (cropped), or <code>CONTAIN</code> (letterboxed). When not set, <code>videoFillMode</code> defaults to
         * <code>COVER</code> fill mode for participants in the grid and to <code>CONTAIN</code> fill mode for featured
         * participants.
         * </p>
         * 
         * @param videoFillMode
         *        Defines how video content fits within the participant tile: <code>FILL</code> (stretched),
         *        <code>COVER</code> (cropped), or <code>CONTAIN</code> (letterboxed). When not set,
         *        <code>videoFillMode</code> defaults to <code>COVER</code> fill mode for participants in the grid and
         *        to <code>CONTAIN</code> fill mode for featured participants.
         * @see VideoFillMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoFillMode
         */
        Builder videoFillMode(VideoFillMode videoFillMode);

        /**
         * <p>
         * Specifies the spacing between participant tiles in pixels. Default: <code>2</code>.
         * </p>
         * 
         * @param gridGap
         *        Specifies the spacing between participant tiles in pixels. Default: <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gridGap(Integer gridGap);
    }

    static final class BuilderImpl implements Builder {
        private String featuredParticipantAttribute;

        private Boolean omitStoppedVideo;

        private String videoAspectRatio;

        private String videoFillMode;

        private Integer gridGap;

        private BuilderImpl() {
        }

        private BuilderImpl(GridConfiguration model) {
            featuredParticipantAttribute(model.featuredParticipantAttribute);
            omitStoppedVideo(model.omitStoppedVideo);
            videoAspectRatio(model.videoAspectRatio);
            videoFillMode(model.videoFillMode);
            gridGap(model.gridGap);
        }

        public final String getFeaturedParticipantAttribute() {
            return featuredParticipantAttribute;
        }

        public final void setFeaturedParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
        }

        @Override
        public final Builder featuredParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
            return this;
        }

        public final Boolean getOmitStoppedVideo() {
            return omitStoppedVideo;
        }

        public final void setOmitStoppedVideo(Boolean omitStoppedVideo) {
            this.omitStoppedVideo = omitStoppedVideo;
        }

        @Override
        public final Builder omitStoppedVideo(Boolean omitStoppedVideo) {
            this.omitStoppedVideo = omitStoppedVideo;
            return this;
        }

        public final String getVideoAspectRatio() {
            return videoAspectRatio;
        }

        public final void setVideoAspectRatio(String videoAspectRatio) {
            this.videoAspectRatio = videoAspectRatio;
        }

        @Override
        public final Builder videoAspectRatio(String videoAspectRatio) {
            this.videoAspectRatio = videoAspectRatio;
            return this;
        }

        @Override
        public final Builder videoAspectRatio(VideoAspectRatio videoAspectRatio) {
            this.videoAspectRatio(videoAspectRatio == null ? null : videoAspectRatio.toString());
            return this;
        }

        public final String getVideoFillMode() {
            return videoFillMode;
        }

        public final void setVideoFillMode(String videoFillMode) {
            this.videoFillMode = videoFillMode;
        }

        @Override
        public final Builder videoFillMode(String videoFillMode) {
            this.videoFillMode = videoFillMode;
            return this;
        }

        @Override
        public final Builder videoFillMode(VideoFillMode videoFillMode) {
            this.videoFillMode(videoFillMode == null ? null : videoFillMode.toString());
            return this;
        }

        public final Integer getGridGap() {
            return gridGap;
        }

        public final void setGridGap(Integer gridGap) {
            this.gridGap = gridGap;
        }

        @Override
        public final Builder gridGap(Integer gridGap) {
            this.gridGap = gridGap;
            return this;
        }

        @Override
        public GridConfiguration build() {
            return new GridConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
