/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPublicKeysResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<ListPublicKeysResponse.Builder, ListPublicKeysResponse> {
    private static final SdkField<List<PublicKeySummary>> PUBLIC_KEYS_FIELD = SdkField
            .<List<PublicKeySummary>> builder(MarshallingType.LIST)
            .memberName("publicKeys")
            .getter(getter(ListPublicKeysResponse::publicKeys))
            .setter(setter(Builder::publicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PublicKeySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublicKeySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPublicKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PublicKeySummary> publicKeys;

    private final String nextToken;

    private ListPublicKeysResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeys = builder.publicKeys;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPublicKeys() {
        return publicKeys != null && !(publicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the matching public keys (summary information only).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicKeys} method.
     * </p>
     * 
     * @return List of the matching public keys (summary information only).
     */
    public final List<PublicKeySummary> publicKeys() {
        return publicKeys;
    }

    /**
     * <p>
     * If there are more public keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
     * next set.
     * </p>
     * 
     * @return If there are more public keys than <code>maxResults</code>, use <code>nextToken</code> in the request to
     *         get the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicKeys() ? publicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPublicKeysResponse)) {
            return false;
        }
        ListPublicKeysResponse other = (ListPublicKeysResponse) obj;
        return hasPublicKeys() == other.hasPublicKeys() && Objects.equals(publicKeys(), other.publicKeys())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPublicKeysResponse").add("PublicKeys", hasPublicKeys() ? publicKeys() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "publicKeys":
            return Optional.ofNullable(clazz.cast(publicKeys()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPublicKeysResponse, T> g) {
        return obj -> g.apply((ListPublicKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPublicKeysResponse> {
        /**
         * <p>
         * List of the matching public keys (summary information only).
         * </p>
         * 
         * @param publicKeys
         *        List of the matching public keys (summary information only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeys(Collection<PublicKeySummary> publicKeys);

        /**
         * <p>
         * List of the matching public keys (summary information only).
         * </p>
         * 
         * @param publicKeys
         *        List of the matching public keys (summary information only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeys(PublicKeySummary... publicKeys);

        /**
         * <p>
         * List of the matching public keys (summary information only).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #publicKeys(List<PublicKeySummary>)}.
         * 
         * @param publicKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicKeys(java.util.Collection<PublicKeySummary>)
         */
        Builder publicKeys(Consumer<PublicKeySummary.Builder>... publicKeys);

        /**
         * <p>
         * If there are more public keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get
         * the next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more public keys than <code>maxResults</code>, use <code>nextToken</code> in the request
         *        to get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private List<PublicKeySummary> publicKeys = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPublicKeysResponse model) {
            super(model);
            publicKeys(model.publicKeys);
            nextToken(model.nextToken);
        }

        public final List<PublicKeySummary.Builder> getPublicKeys() {
            List<PublicKeySummary.Builder> result = PublicKeyListCopier.copyToBuilder(this.publicKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublicKeys(Collection<PublicKeySummary.BuilderImpl> publicKeys) {
            this.publicKeys = PublicKeyListCopier.copyFromBuilder(publicKeys);
        }

        @Override
        public final Builder publicKeys(Collection<PublicKeySummary> publicKeys) {
            this.publicKeys = PublicKeyListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(PublicKeySummary... publicKeys) {
            publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(Consumer<PublicKeySummary.Builder>... publicKeys) {
            publicKeys(Stream.of(publicKeys).map(c -> PublicKeySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPublicKeysResponse build() {
            return new ListPublicKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
