/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a participant token configuration in a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantTokenConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantTokenConfiguration.Builder, ParticipantTokenConfiguration> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("duration").getter(getter(ParticipantTokenConfiguration::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ParticipantTokenConfiguration::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(ParticipantTokenConfiguration::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(ParticipantTokenConfiguration::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, USER_ID_FIELD,
            ATTRIBUTES_FIELD, CAPABILITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer duration;

    private final String userId;

    private final Map<String, String> attributes;

    private final List<String> capabilities;

    private ParticipantTokenConfiguration(BuilderImpl builder) {
        this.duration = builder.duration;
        this.userId = builder.userId;
        this.attributes = builder.attributes;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12 hours).
     * </p>
     * 
     * @return Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12 hours).
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
     * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants
     * and should not be used for personally identifying, confidential, or sensitive information.</i>
     * </p>
     * 
     * @return Customer-assigned name to help identify the token; this can be used to link a participant to a user in
     *         the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
     *         participants and should not be used for personally identifying, confidential, or sensitive
     *         information.</i>
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to encode into the corresponding participant token and attach to a stage. Map
     * keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
     * exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive
     * information.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to encode into the corresponding participant token and attach to a stage.
     *         Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
     *         <i>This field is exposed to all stage participants and should not be used for personally identifying,
     *         confidential, or sensitive information.</i>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Set of capabilities that the user is allowed to perform in the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Set of capabilities that the user is allowed to perform in the stage.
     */
    public final List<ParticipantTokenCapability> capabilities() {
        return ParticipantTokenCapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Set of capabilities that the user is allowed to perform in the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Set of capabilities that the user is allowed to perform in the stage.
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantTokenConfiguration)) {
            return false;
        }
        ParticipantTokenConfiguration other = (ParticipantTokenConfiguration) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(userId(), other.userId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantTokenConfiguration").add("Duration", duration()).add("UserId", userId())
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipantTokenConfiguration, T> g) {
        return obj -> g.apply((ParticipantTokenConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantTokenConfiguration> {
        /**
         * <p>
         * Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12 hours).
         * </p>
         * 
         * @param duration
         *        Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12
         *        hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
         * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         * participants and should not be used for personally identifying, confidential, or sensitive information.</i>
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the token; this can be used to link a participant to a user in
         *        the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         *        participants and should not be used for personally identifying, confidential, or sensitive
         *        information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Application-provided attributes to encode into the corresponding participant token and attach to a stage. Map
         * keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field
         * is exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to encode into the corresponding participant token and attach to a
         *        stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB
         *        total. <i>This field is exposed to all stage participants and should not be used for personally
         *        identifying, confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<ParticipantTokenCapability> capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the stage.
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(ParticipantTokenCapability... capabilities);
    }

    static final class BuilderImpl implements Builder {
        private Integer duration;

        private String userId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantTokenConfiguration model) {
            duration(model.duration);
            userId(model.userId);
            attributes(model.attributes);
            capabilitiesWithStrings(model.capabilities);
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantTokenAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantTokenAttributesCopier.copy(attributes);
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<ParticipantTokenCapability> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(ParticipantTokenCapability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public ParticipantTokenConfiguration build() {
            return new ParticipantTokenConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
