/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Video implements SdkPojo, Serializable, ToCopyableBuilder<Video.Builder, Video> {
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("width")
            .getter(getter(Video::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("height").getter(getter(Video::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Float> FRAMERATE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("framerate").getter(getter(Video::framerate)).setter(setter(Builder::framerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("bitrate").getter(getter(Video::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIDTH_FIELD, HEIGHT_FIELD,
            FRAMERATE_FIELD, BITRATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer width;

    private final Integer height;

    private final Float framerate;

    private final Integer bitrate;

    private Video(BuilderImpl builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.framerate = builder.framerate;
        this.bitrate = builder.bitrate;
    }

    /**
     * <p>
     * Video-resolution width. Note that the maximum value is determined by <code>width</code> times <code>height</code>
     * , such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 1280.
     * </p>
     * 
     * @return Video-resolution width. Note that the maximum value is determined by <code>width</code> times
     *         <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default:
     *         1280.
     */
    public final Integer width() {
        return width;
    }

    /**
     * <p>
     * Video-resolution height. Note that the maximum value is determined by <code>width</code> times
     * <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 720.
     * </p>
     * 
     * @return Video-resolution height. Note that the maximum value is determined by <code>width</code> times
     *         <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default:
     *         720.
     */
    public final Integer height() {
        return height;
    }

    /**
     * <p>
     * Video frame rate, in fps. Default: 30.
     * </p>
     * 
     * @return Video frame rate, in fps. Default: 30.
     */
    public final Float framerate() {
        return framerate;
    }

    /**
     * <p>
     * Bitrate for generated output, in bps. Default: 2500000.
     * </p>
     * 
     * @return Bitrate for generated output, in bps. Default: 2500000.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(framerate());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Video)) {
            return false;
        }
        Video other = (Video) obj;
        return Objects.equals(width(), other.width()) && Objects.equals(height(), other.height())
                && Objects.equals(framerate(), other.framerate()) && Objects.equals(bitrate(), other.bitrate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Video").add("Width", width()).add("Height", height()).add("Framerate", framerate())
                .add("Bitrate", bitrate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "width":
            return Optional.ofNullable(clazz.cast(width()));
        case "height":
            return Optional.ofNullable(clazz.cast(height()));
        case "framerate":
            return Optional.ofNullable(clazz.cast(framerate()));
        case "bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Video, T> g) {
        return obj -> g.apply((Video) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Video> {
        /**
         * <p>
         * Video-resolution width. Note that the maximum value is determined by <code>width</code> times
         * <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 1280.
         * </p>
         * 
         * @param width
         *        Video-resolution width. Note that the maximum value is determined by <code>width</code> times
         *        <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default:
         *        1280.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * Video-resolution height. Note that the maximum value is determined by <code>width</code> times
         * <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 720.
         * </p>
         * 
         * @param height
         *        Video-resolution height. Note that the maximum value is determined by <code>width</code> times
         *        <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default:
         *        720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * <p>
         * Video frame rate, in fps. Default: 30.
         * </p>
         * 
         * @param framerate
         *        Video frame rate, in fps. Default: 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerate(Float framerate);

        /**
         * <p>
         * Bitrate for generated output, in bps. Default: 2500000.
         * </p>
         * 
         * @param bitrate
         *        Bitrate for generated output, in bps. Default: 2500000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);
    }

    static final class BuilderImpl implements Builder {
        private Integer width;

        private Integer height;

        private Float framerate;

        private Integer bitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(Video model) {
            width(model.width);
            height(model.height);
            framerate(model.framerate);
            bitrate(model.bitrate);
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Float getFramerate() {
            return framerate;
        }

        public final void setFramerate(Float framerate) {
            this.framerate = framerate;
        }

        @Override
        public final Builder framerate(Float framerate) {
            this.framerate = framerate;
            return this;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @Override
        public Video build() {
            return new Video(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
