/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a configuration for individual participant recording.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoParticipantRecordingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoParticipantRecordingConfiguration.Builder, AutoParticipantRecordingConfiguration> {
    private static final SdkField<String> STORAGE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageConfigurationArn").getter(getter(AutoParticipantRecordingConfiguration::storageConfigurationArn))
            .setter(setter(Builder::storageConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurationArn").build())
            .build();

    private static final SdkField<List<String>> MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("mediaTypes")
            .getter(getter(AutoParticipantRecordingConfiguration::mediaTypesAsStrings))
            .setter(setter(Builder::mediaTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_CONFIGURATION_ARN_FIELD, MEDIA_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String storageConfigurationArn;

    private final List<String> mediaTypes;

    private AutoParticipantRecordingConfiguration(BuilderImpl builder) {
        this.storageConfigurationArn = builder.storageConfigurationArn;
        this.mediaTypes = builder.mediaTypes;
    }

    /**
     * <p>
     * ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
     * <code>""</code> (empty string, no storage configuration is specified). Individual participant recording cannot be
     * started unless a storage configuration is specified, when a <a>Stage</a> is created or updated.
     * </p>
     * 
     * @return ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
     *         <code>""</code> (empty string, no storage configuration is specified). Individual participant recording
     *         cannot be started unless a storage configuration is specified, when a <a>Stage</a> is created or updated.
     */
    public final String storageConfigurationArn() {
        return storageConfigurationArn;
    }

    /**
     * <p>
     * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaTypes} method.
     * </p>
     * 
     * @return Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     */
    public final List<ParticipantRecordingMediaType> mediaTypes() {
        return ParticipantRecordingMediaTypeListCopier.copyStringToEnum(mediaTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMediaTypes() {
        return mediaTypes != null && !(mediaTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaTypes} method.
     * </p>
     * 
     * @return Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     */
    public final List<String> mediaTypesAsStrings() {
        return mediaTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaTypes() ? mediaTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoParticipantRecordingConfiguration)) {
            return false;
        }
        AutoParticipantRecordingConfiguration other = (AutoParticipantRecordingConfiguration) obj;
        return Objects.equals(storageConfigurationArn(), other.storageConfigurationArn())
                && hasMediaTypes() == other.hasMediaTypes() && Objects.equals(mediaTypesAsStrings(), other.mediaTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoParticipantRecordingConfiguration")
                .add("StorageConfigurationArn", storageConfigurationArn())
                .add("MediaTypes", hasMediaTypes() ? mediaTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageConfigurationArn":
            return Optional.ofNullable(clazz.cast(storageConfigurationArn()));
        case "mediaTypes":
            return Optional.ofNullable(clazz.cast(mediaTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoParticipantRecordingConfiguration, T> g) {
        return obj -> g.apply((AutoParticipantRecordingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoParticipantRecordingConfiguration> {
        /**
         * <p>
         * ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
         * <code>""</code> (empty string, no storage configuration is specified). Individual participant recording
         * cannot be started unless a storage configuration is specified, when a <a>Stage</a> is created or updated.
         * </p>
         * 
         * @param storageConfigurationArn
         *        ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
         *        <code>""</code> (empty string, no storage configuration is specified). Individual participant
         *        recording cannot be started unless a storage configuration is specified, when a <a>Stage</a> is
         *        created or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurationArn(String storageConfigurationArn);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypesWithStrings(Collection<String> mediaTypes);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypesWithStrings(String... mediaTypes);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypes(Collection<ParticipantRecordingMediaType> mediaTypes);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypes(ParticipantRecordingMediaType... mediaTypes);
    }

    static final class BuilderImpl implements Builder {
        private String storageConfigurationArn;

        private List<String> mediaTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoParticipantRecordingConfiguration model) {
            storageConfigurationArn(model.storageConfigurationArn);
            mediaTypesWithStrings(model.mediaTypes);
        }

        public final String getStorageConfigurationArn() {
            return storageConfigurationArn;
        }

        public final void setStorageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
        }

        @Override
        public final Builder storageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
            return this;
        }

        public final Collection<String> getMediaTypes() {
            if (mediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return mediaTypes;
        }

        public final void setMediaTypes(Collection<String> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copy(mediaTypes);
        }

        @Override
        public final Builder mediaTypesWithStrings(Collection<String> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copy(mediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaTypesWithStrings(String... mediaTypes) {
            mediaTypesWithStrings(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public final Builder mediaTypes(Collection<ParticipantRecordingMediaType> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copyEnumToString(mediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaTypes(ParticipantRecordingMediaType... mediaTypes) {
            mediaTypes(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public AutoParticipantRecordingConfiguration build() {
            return new AutoParticipantRecordingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
