/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIngestConfigurationRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<CreateIngestConfigurationRequest.Builder, CreateIngestConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateIngestConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(CreateIngestConfigurationRequest::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(CreateIngestConfigurationRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(CreateIngestConfigurationRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INGEST_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestProtocol").getter(getter(CreateIngestConfigurationRequest::ingestProtocolAsString))
            .setter(setter(Builder::ingestProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestProtocol").build()).build();

    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("insecureIngest").getter(getter(CreateIngestConfigurationRequest::insecureIngest))
            .setter(setter(Builder::insecureIngest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateIngestConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STAGE_ARN_FIELD,
            USER_ID_FIELD, ATTRIBUTES_FIELD, INGEST_PROTOCOL_FIELD, INSECURE_INGEST_FIELD, TAGS_FIELD));

    private final String name;

    private final String stageArn;

    private final String userId;

    private final Map<String, String> attributes;

    private final String ingestProtocol;

    private final Boolean insecureIngest;

    private final Map<String, String> tags;

    private CreateIngestConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stageArn = builder.stageArn;
        this.userId = builder.userId;
        this.attributes = builder.attributes;
        this.ingestProtocol = builder.ingestProtocol;
        this.insecureIngest = builder.insecureIngest;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Optional name that can be specified for the IngestConfiguration being created.
     * </p>
     * 
     * @return Optional name that can be specified for the IngestConfiguration being created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ARN of the stage with which the IngestConfiguration is associated.
     * </p>
     * 
     * @return ARN of the stage with which the IngestConfiguration is associated.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to link a
     * participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed
     * to all stage participants and should not be used for personally identifying, confidential, or sensitive
     * information.</i>
     * </p>
     * 
     * @return Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used
     *         to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text.
     *         <i>This field is exposed to all stage participants and should not be used for personally identifying,
     *         confidential, or sensitive information.</i>
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to store in the IngestConfiguration and attach to a stage. Map keys and values
     * can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all
     * stage participants and should not be used for personally identifying, confidential, or sensitive information.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to store in the IngestConfiguration and attach to a stage. Map keys and
     *         values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
     *         exposed to all stage participants and should not be used for personally identifying, confidential, or
     *         sensitive information.</i>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
     * <code>insecureIngest</code> must be set to <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestProtocol}
     * will return {@link IngestProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestProtocolAsString}.
     * </p>
     * 
     * @return Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
     *         <code>insecureIngest</code> must be set to <code>true</code>.
     * @see IngestProtocol
     */
    public final IngestProtocol ingestProtocol() {
        return IngestProtocol.fromValue(ingestProtocol);
    }

    /**
     * <p>
     * Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
     * <code>insecureIngest</code> must be set to <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestProtocol}
     * will return {@link IngestProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestProtocolAsString}.
     * </p>
     * 
     * @return Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
     *         <code>insecureIngest</code> must be set to <code>true</code>.
     * @see IngestProtocol
     */
    public final String ingestProtocolAsString() {
        return ingestProtocol;
    }

    /**
     * <p>
     * Whether the stage allows insecure RTMP ingest. This must be set to <code>true</code>, if
     * <code>ingestProtocol</code> is set to <code>RTMP</code>. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the stage allows insecure RTMP ingest. This must be set to <code>true</code>, if
     *         <code>ingestProtocol</code> is set to <code>RTMP</code>. Default: <code>false</code>.
     */
    public final Boolean insecureIngest() {
        return insecureIngest;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices and
     * strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that apply to
     * tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented
     * there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
     *         restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     *         on tags beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ingestProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestConfigurationRequest)) {
            return false;
        }
        CreateIngestConfigurationRequest other = (CreateIngestConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(stageArn(), other.stageArn())
                && Objects.equals(userId(), other.userId()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(ingestProtocolAsString(), other.ingestProtocolAsString())
                && Objects.equals(insecureIngest(), other.insecureIngest()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIngestConfigurationRequest").add("Name", name()).add("StageArn", stageArn())
                .add("UserId", userId()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("IngestProtocol", ingestProtocolAsString()).add("InsecureIngest", insecureIngest())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ingestProtocol":
            return Optional.ofNullable(clazz.cast(ingestProtocolAsString()));
        case "insecureIngest":
            return Optional.ofNullable(clazz.cast(insecureIngest()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestConfigurationRequest, T> g) {
        return obj -> g.apply((CreateIngestConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIngestConfigurationRequest> {
        /**
         * <p>
         * Optional name that can be specified for the IngestConfiguration being created.
         * </p>
         * 
         * @param name
         *        Optional name that can be specified for the IngestConfiguration being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ARN of the stage with which the IngestConfiguration is associated.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage with which the IngestConfiguration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to
         * link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field
         * is exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the participant using the IngestConfiguration; this can be
         *        used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded
         *        text. <i>This field is exposed to all stage participants and should not be used for personally
         *        identifying, confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Application-provided attributes to store in the IngestConfiguration and attach to a stage. Map keys and
         * values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
         * exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to store in the IngestConfiguration and attach to a stage. Map keys
         *        and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This
         *        field is exposed to all stage participants and should not be used for personally identifying,
         *        confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
         * <code>insecureIngest</code> must be set to <code>true</code>.
         * </p>
         * 
         * @param ingestProtocol
         *        Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
         *        <code>insecureIngest</code> must be set to <code>true</code>.
         * @see IngestProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestProtocol
         */
        Builder ingestProtocol(String ingestProtocol);

        /**
         * <p>
         * Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
         * <code>insecureIngest</code> must be set to <code>true</code>.
         * </p>
         * 
         * @param ingestProtocol
         *        Type of ingest protocol that the user employs to broadcast. If this is set to <code>RTMP</code>,
         *        <code>insecureIngest</code> must be set to <code>true</code>.
         * @see IngestProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestProtocol
         */
        Builder ingestProtocol(IngestProtocol ingestProtocol);

        /**
         * <p>
         * Whether the stage allows insecure RTMP ingest. This must be set to <code>true</code>, if
         * <code>ingestProtocol</code> is set to <code>RTMP</code>. Default: <code>false</code>.
         * </p>
         * 
         * @param insecureIngest
         *        Whether the stage allows insecure RTMP ingest. This must be set to <code>true</code>, if
         *        <code>ingestProtocol</code> is set to <code>RTMP</code>. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureIngest(Boolean insecureIngest);

        /**
         * <p>
         * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
         * and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that
         * apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
         *        See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
         *        restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         *        constraints on tags beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String name;

        private String stageArn;

        private String userId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String ingestProtocol;

        private Boolean insecureIngest;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestConfigurationRequest model) {
            super(model);
            name(model.name);
            stageArn(model.stageArn);
            userId(model.userId);
            attributes(model.attributes);
            ingestProtocol(model.ingestProtocol);
            insecureIngest(model.insecureIngest);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final String getIngestProtocol() {
            return ingestProtocol;
        }

        public final void setIngestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
        }

        @Override
        public final Builder ingestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
            return this;
        }

        @Override
        public final Builder ingestProtocol(IngestProtocol ingestProtocol) {
            this.ingestProtocol(ingestProtocol == null ? null : ingestProtocol.toString());
            return this;
        }

        public final Boolean getInsecureIngest() {
            return insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngestConfigurationRequest build() {
            return new CreateIngestConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
