/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying an ingest configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestConfiguration.Builder, IngestConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IngestConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IngestConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> INGEST_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestProtocol").getter(getter(IngestConfiguration::ingestProtocolAsString))
            .setter(setter(Builder::ingestProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestProtocol").build()).build();

    private static final SdkField<String> STREAM_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamKey").getter(getter(IngestConfiguration::streamKey)).setter(setter(Builder::streamKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKey").build()).build();

    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(IngestConfiguration::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(IngestConfiguration::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(IngestConfiguration::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(IngestConfiguration::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(IngestConfiguration::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(IngestConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            INGEST_PROTOCOL_FIELD, STREAM_KEY_FIELD, STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD, STATE_FIELD, USER_ID_FIELD,
            ATTRIBUTES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String ingestProtocol;

    private final String streamKey;

    private final String stageArn;

    private final String participantId;

    private final String state;

    private final String userId;

    private final Map<String, String> attributes;

    private final Map<String, String> tags;

    private IngestConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.ingestProtocol = builder.ingestProtocol;
        this.streamKey = builder.streamKey;
        this.stageArn = builder.stageArn;
        this.participantId = builder.participantId;
        this.state = builder.state;
        this.userId = builder.userId;
        this.attributes = builder.attributes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Ingest name
     * </p>
     * 
     * @return Ingest name
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Ingest configuration ARN.
     * </p>
     * 
     * @return Ingest configuration ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Type of ingest protocol that the user employs for broadcasting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestProtocol}
     * will return {@link IngestProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestProtocolAsString}.
     * </p>
     * 
     * @return Type of ingest protocol that the user employs for broadcasting.
     * @see IngestProtocol
     */
    public final IngestProtocol ingestProtocol() {
        return IngestProtocol.fromValue(ingestProtocol);
    }

    /**
     * <p>
     * Type of ingest protocol that the user employs for broadcasting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestProtocol}
     * will return {@link IngestProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestProtocolAsString}.
     * </p>
     * 
     * @return Type of ingest protocol that the user employs for broadcasting.
     * @see IngestProtocol
     */
    public final String ingestProtocolAsString() {
        return ingestProtocol;
    }

    /**
     * <p>
     * Ingest-key value for the RTMP(S) protocol.
     * </p>
     * 
     * @return Ingest-key value for the RTMP(S) protocol.
     */
    public final String streamKey() {
        return streamKey;
    }

    /**
     * <p>
     * ARN of the stage with which the IngestConfiguration is associated.
     * </p>
     * 
     * @return ARN of the stage with which the IngestConfiguration is associated.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * ID of the participant within the stage.
     * </p>
     * 
     * @return ID of the participant within the stage.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the stage
     * associated with the ingest configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IngestConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
     *         the stage associated with the ingest configuration.
     * @see IngestConfigurationState
     */
    public final IngestConfigurationState state() {
        return IngestConfigurationState.fromValue(state);
    }

    /**
     * <p>
     * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the stage
     * associated with the ingest configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IngestConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
     *         the stage associated with the ingest configuration.
     * @see IngestConfigurationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to link a
     * participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed
     * to all stage participants and should not be used for personally identifying, confidential, or sensitive
     * information.</i>
     * </p>
     * 
     * @return Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used
     *         to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text.
     *         <i>This field is exposed to all stage participants and should not be used for personally identifying,
     *         confidential, or sensitive information.</i>
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to to store in the IngestConfiguration and attach to a stage. Map keys and values
     * can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all
     * stage participants and should not be used for personally identifying, confidential, or sensitive information.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to to store in the IngestConfiguration and attach to a stage. Map keys
     *         and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field
     *         is exposed to all stage participants and should not be used for personally identifying, confidential, or
     *         sensitive information.</i>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices and
     * strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that apply to
     * tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented
     * there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
     *         restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     *         on tags beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamKey());
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfiguration)) {
            return false;
        }
        IngestConfiguration other = (IngestConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(ingestProtocolAsString(), other.ingestProtocolAsString())
                && Objects.equals(streamKey(), other.streamKey()) && Objects.equals(stageArn(), other.stageArn())
                && Objects.equals(participantId(), other.participantId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(userId(), other.userId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestConfiguration").add("Name", name()).add("Arn", arn())
                .add("IngestProtocol", ingestProtocolAsString())
                .add("StreamKey", streamKey() == null ? null : "*** Sensitive Data Redacted ***").add("StageArn", stageArn())
                .add("ParticipantId", participantId()).add("State", stateAsString()).add("UserId", userId())
                .add("Attributes", hasAttributes() ? attributes() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ingestProtocol":
            return Optional.ofNullable(clazz.cast(ingestProtocolAsString()));
        case "streamKey":
            return Optional.ofNullable(clazz.cast(streamKey()));
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestConfiguration, T> g) {
        return obj -> g.apply((IngestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestConfiguration> {
        /**
         * <p>
         * Ingest name
         * </p>
         * 
         * @param name
         *        Ingest name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Ingest configuration ARN.
         * </p>
         * 
         * @param arn
         *        Ingest configuration ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Type of ingest protocol that the user employs for broadcasting.
         * </p>
         * 
         * @param ingestProtocol
         *        Type of ingest protocol that the user employs for broadcasting.
         * @see IngestProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestProtocol
         */
        Builder ingestProtocol(String ingestProtocol);

        /**
         * <p>
         * Type of ingest protocol that the user employs for broadcasting.
         * </p>
         * 
         * @param ingestProtocol
         *        Type of ingest protocol that the user employs for broadcasting.
         * @see IngestProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestProtocol
         */
        Builder ingestProtocol(IngestProtocol ingestProtocol);

        /**
         * <p>
         * Ingest-key value for the RTMP(S) protocol.
         * </p>
         * 
         * @param streamKey
         *        Ingest-key value for the RTMP(S) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKey(String streamKey);

        /**
         * <p>
         * ARN of the stage with which the IngestConfiguration is associated.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage with which the IngestConfiguration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * ID of the participant within the stage.
         * </p>
         * 
         * @param participantId
         *        ID of the participant within the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the
         * stage associated with the ingest configuration.
         * </p>
         * 
         * @param state
         *        State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
         *        the stage associated with the ingest configuration.
         * @see IngestConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestConfigurationState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the
         * stage associated with the ingest configuration.
         * </p>
         * 
         * @param state
         *        State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
         *        the stage associated with the ingest configuration.
         * @see IngestConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestConfigurationState
         */
        Builder state(IngestConfigurationState state);

        /**
         * <p>
         * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to
         * link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field
         * is exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the participant using the IngestConfiguration; this can be
         *        used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded
         *        text. <i>This field is exposed to all stage participants and should not be used for personally
         *        identifying, confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Application-provided attributes to to store in the IngestConfiguration and attach to a stage. Map keys and
         * values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
         * exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to to store in the IngestConfiguration and attach to a stage. Map keys
         *        and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This
         *        field is exposed to all stage participants and should not be used for personally identifying,
         *        confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
         * and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that
         * apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
         *        See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
         *        restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         *        constraints on tags beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String ingestProtocol;

        private String streamKey;

        private String stageArn;

        private String participantId;

        private String state;

        private String userId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfiguration model) {
            name(model.name);
            arn(model.arn);
            ingestProtocol(model.ingestProtocol);
            streamKey(model.streamKey);
            stageArn(model.stageArn);
            participantId(model.participantId);
            state(model.state);
            userId(model.userId);
            attributes(model.attributes);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIngestProtocol() {
            return ingestProtocol;
        }

        public final void setIngestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
        }

        @Override
        public final Builder ingestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
            return this;
        }

        @Override
        public final Builder ingestProtocol(IngestProtocol ingestProtocol) {
            this.ingestProtocol(ingestProtocol == null ? null : ingestProtocol.toString());
            return this;
        }

        public final String getStreamKey() {
            return streamKey;
        }

        public final void setStreamKey(String streamKey) {
            this.streamKey = streamKey;
        }

        @Override
        public final Builder streamKey(String streamKey) {
            this.streamKey = streamKey;
            return this;
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IngestConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public IngestConfiguration build() {
            return new IngestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
