/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Complex data type that defines S3Detail objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Detail implements SdkPojo, Serializable, ToCopyableBuilder<S3Detail.Builder, S3Detail> {
    private static final SdkField<String> RECORDING_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingPrefix").getter(getter(S3Detail::recordingPrefix)).setter(setter(Builder::recordingPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDING_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordingPrefix;

    private S3Detail(BuilderImpl builder) {
        this.recordingPrefix = builder.recordingPrefix;
    }

    /**
     * <p>
     * The S3 bucket prefix under which the recording is stored.
     * </p>
     * 
     * @return The S3 bucket prefix under which the recording is stored.
     */
    public final String recordingPrefix() {
        return recordingPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordingPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Detail)) {
            return false;
        }
        S3Detail other = (S3Detail) obj;
        return Objects.equals(recordingPrefix(), other.recordingPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Detail").add("RecordingPrefix", recordingPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordingPrefix":
            return Optional.ofNullable(clazz.cast(recordingPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Detail, T> g) {
        return obj -> g.apply((S3Detail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Detail> {
        /**
         * <p>
         * The S3 bucket prefix under which the recording is stored.
         * </p>
         * 
         * @param recordingPrefix
         *        The S3 bucket prefix under which the recording is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingPrefix(String recordingPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String recordingPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Detail model) {
            recordingPrefix(model.recordingPrefix);
        }

        public final String getRecordingPrefix() {
            return recordingPrefix;
        }

        public final void setRecordingPrefix(String recordingPrefix) {
            this.recordingPrefix = recordingPrefix;
        }

        @Override
        public final Builder recordingPrefix(String recordingPrefix) {
            this.recordingPrefix = recordingPrefix;
            return this;
        }

        @Override
        public S3Detail build() {
            return new S3Detail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
