/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEncoderConfigurationResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<CreateEncoderConfigurationResponse.Builder, CreateEncoderConfigurationResponse> {
    private static final SdkField<EncoderConfiguration> ENCODER_CONFIGURATION_FIELD = SdkField
            .<EncoderConfiguration> builder(MarshallingType.SDK_POJO).memberName("encoderConfiguration")
            .getter(getter(CreateEncoderConfigurationResponse::encoderConfiguration))
            .setter(setter(Builder::encoderConfiguration)).constructor(EncoderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EncoderConfiguration encoderConfiguration;

    private CreateEncoderConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.encoderConfiguration = builder.encoderConfiguration;
    }

    /**
     * <p>
     * The EncoderConfiguration that was created.
     * </p>
     * 
     * @return The EncoderConfiguration that was created.
     */
    public final EncoderConfiguration encoderConfiguration() {
        return encoderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encoderConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEncoderConfigurationResponse)) {
            return false;
        }
        CreateEncoderConfigurationResponse other = (CreateEncoderConfigurationResponse) obj;
        return Objects.equals(encoderConfiguration(), other.encoderConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEncoderConfigurationResponse").add("EncoderConfiguration", encoderConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encoderConfiguration":
            return Optional.ofNullable(clazz.cast(encoderConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encoderConfiguration", ENCODER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEncoderConfigurationResponse, T> g) {
        return obj -> g.apply((CreateEncoderConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEncoderConfigurationResponse> {
        /**
         * <p>
         * The EncoderConfiguration that was created.
         * </p>
         * 
         * @param encoderConfiguration
         *        The EncoderConfiguration that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderConfiguration(EncoderConfiguration encoderConfiguration);

        /**
         * <p>
         * The EncoderConfiguration that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncoderConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncoderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncoderConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #encoderConfiguration(EncoderConfiguration)}.
         * 
         * @param encoderConfiguration
         *        a consumer that will call methods on {@link EncoderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encoderConfiguration(EncoderConfiguration)
         */
        default Builder encoderConfiguration(Consumer<EncoderConfiguration.Builder> encoderConfiguration) {
            return encoderConfiguration(EncoderConfiguration.builder().applyMutation(encoderConfiguration).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private EncoderConfiguration encoderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEncoderConfigurationResponse model) {
            super(model);
            encoderConfiguration(model.encoderConfiguration);
        }

        public final EncoderConfiguration.Builder getEncoderConfiguration() {
            return encoderConfiguration != null ? encoderConfiguration.toBuilder() : null;
        }

        public final void setEncoderConfiguration(EncoderConfiguration.BuilderImpl encoderConfiguration) {
            this.encoderConfiguration = encoderConfiguration != null ? encoderConfiguration.build() : null;
        }

        @Override
        public final Builder encoderConfiguration(EncoderConfiguration encoderConfiguration) {
            this.encoderConfiguration = encoderConfiguration;
            return this;
        }

        @Override
        public CreateEncoderConfigurationResponse build() {
            return new CreateEncoderConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
