/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIngestConfigurationResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<CreateIngestConfigurationResponse.Builder, CreateIngestConfigurationResponse> {
    private static final SdkField<IngestConfiguration> INGEST_CONFIGURATION_FIELD = SdkField
            .<IngestConfiguration> builder(MarshallingType.SDK_POJO).memberName("ingestConfiguration")
            .getter(getter(CreateIngestConfigurationResponse::ingestConfiguration)).setter(setter(Builder::ingestConfiguration))
            .constructor(IngestConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGEST_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IngestConfiguration ingestConfiguration;

    private CreateIngestConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.ingestConfiguration = builder.ingestConfiguration;
    }

    /**
     * <p>
     * The IngestConfiguration that was created.
     * </p>
     * 
     * @return The IngestConfiguration that was created.
     */
    public final IngestConfiguration ingestConfiguration() {
        return ingestConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingestConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestConfigurationResponse)) {
            return false;
        }
        CreateIngestConfigurationResponse other = (CreateIngestConfigurationResponse) obj;
        return Objects.equals(ingestConfiguration(), other.ingestConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIngestConfigurationResponse").add("IngestConfiguration", ingestConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestConfiguration":
            return Optional.ofNullable(clazz.cast(ingestConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ingestConfiguration", INGEST_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestConfigurationResponse, T> g) {
        return obj -> g.apply((CreateIngestConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIngestConfigurationResponse> {
        /**
         * <p>
         * The IngestConfiguration that was created.
         * </p>
         * 
         * @param ingestConfiguration
         *        The IngestConfiguration that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestConfiguration(IngestConfiguration ingestConfiguration);

        /**
         * <p>
         * The IngestConfiguration that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestConfiguration.Builder} avoiding the
         * need to create one manually via {@link IngestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #ingestConfiguration(IngestConfiguration)}.
         * 
         * @param ingestConfiguration
         *        a consumer that will call methods on {@link IngestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestConfiguration(IngestConfiguration)
         */
        default Builder ingestConfiguration(Consumer<IngestConfiguration.Builder> ingestConfiguration) {
            return ingestConfiguration(IngestConfiguration.builder().applyMutation(ingestConfiguration).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private IngestConfiguration ingestConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestConfigurationResponse model) {
            super(model);
            ingestConfiguration(model.ingestConfiguration);
        }

        public final IngestConfiguration.Builder getIngestConfiguration() {
            return ingestConfiguration != null ? ingestConfiguration.toBuilder() : null;
        }

        public final void setIngestConfiguration(IngestConfiguration.BuilderImpl ingestConfiguration) {
            this.ingestConfiguration = ingestConfiguration != null ? ingestConfiguration.build() : null;
        }

        @Override
        public final Builder ingestConfiguration(IngestConfiguration ingestConfiguration) {
            this.ingestConfiguration = ingestConfiguration;
            return this;
        }

        @Override
        public CreateIngestConfigurationResponse build() {
            return new CreateIngestConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
