/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStageRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<CreateStageRequest.Builder, CreateStageRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateStageRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ParticipantTokenConfiguration>> PARTICIPANT_TOKEN_CONFIGURATIONS_FIELD = SdkField
            .<List<ParticipantTokenConfiguration>> builder(MarshallingType.LIST)
            .memberName("participantTokenConfigurations")
            .getter(getter(CreateStageRequest::participantTokenConfigurations))
            .setter(setter(Builder::participantTokenConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantTokenConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParticipantTokenConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParticipantTokenConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateStageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AutoParticipantRecordingConfiguration> AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD = SdkField
            .<AutoParticipantRecordingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("autoParticipantRecordingConfiguration")
            .getter(getter(CreateStageRequest::autoParticipantRecordingConfiguration))
            .setter(setter(Builder::autoParticipantRecordingConfiguration))
            .constructor(AutoParticipantRecordingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("autoParticipantRecordingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PARTICIPANT_TOKEN_CONFIGURATIONS_FIELD, TAGS_FIELD, AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final List<ParticipantTokenConfiguration> participantTokenConfigurations;

    private final Map<String, String> tags;

    private final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

    private CreateStageRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.participantTokenConfigurations = builder.participantTokenConfigurations;
        this.tags = builder.tags;
        this.autoParticipantRecordingConfiguration = builder.autoParticipantRecordingConfiguration;
    }

    /**
     * <p>
     * Optional name that can be specified for the stage being created.
     * </p>
     * 
     * @return Optional name that can be specified for the stage being created.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParticipantTokenConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasParticipantTokenConfigurations() {
        return participantTokenConfigurations != null && !(participantTokenConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of participant token configuration objects to attach to the new stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParticipantTokenConfigurations} method.
     * </p>
     * 
     * @return Array of participant token configuration objects to attach to the new stage.
     */
    public final List<ParticipantTokenConfiguration> participantTokenConfigurations() {
        return participantTokenConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices and
     * strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that apply to
     * tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented
     * there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
     *         restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     *         on tags beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Configuration object for individual participant recording, to attach to the new stage.
     * </p>
     * 
     * @return Configuration object for individual participant recording, to attach to the new stage.
     */
    public final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration() {
        return autoParticipantRecordingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasParticipantTokenConfigurations() ? participantTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoParticipantRecordingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageRequest)) {
            return false;
        }
        CreateStageRequest other = (CreateStageRequest) obj;
        return Objects.equals(name(), other.name())
                && hasParticipantTokenConfigurations() == other.hasParticipantTokenConfigurations()
                && Objects.equals(participantTokenConfigurations(), other.participantTokenConfigurations())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(autoParticipantRecordingConfiguration(), other.autoParticipantRecordingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateStageRequest")
                .add("Name", name())
                .add("ParticipantTokenConfigurations",
                        hasParticipantTokenConfigurations() ? participantTokenConfigurations() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("AutoParticipantRecordingConfiguration", autoParticipantRecordingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "participantTokenConfigurations":
            return Optional.ofNullable(clazz.cast(participantTokenConfigurations()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "autoParticipantRecordingConfiguration":
            return Optional.ofNullable(clazz.cast(autoParticipantRecordingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("participantTokenConfigurations", PARTICIPANT_TOKEN_CONFIGURATIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("autoParticipantRecordingConfiguration", AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStageRequest, T> g) {
        return obj -> g.apply((CreateStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStageRequest> {
        /**
         * <p>
         * Optional name that can be specified for the stage being created.
         * </p>
         * 
         * @param name
         *        Optional name that can be specified for the stage being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Array of participant token configuration objects to attach to the new stage.
         * </p>
         * 
         * @param participantTokenConfigurations
         *        Array of participant token configuration objects to attach to the new stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantTokenConfigurations(Collection<ParticipantTokenConfiguration> participantTokenConfigurations);

        /**
         * <p>
         * Array of participant token configuration objects to attach to the new stage.
         * </p>
         * 
         * @param participantTokenConfigurations
         *        Array of participant token configuration objects to attach to the new stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantTokenConfigurations(ParticipantTokenConfiguration... participantTokenConfigurations);

        /**
         * <p>
         * Array of participant token configuration objects to attach to the new stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #participantTokenConfigurations(List<ParticipantTokenConfiguration>)}.
         * 
         * @param participantTokenConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantTokenConfigurations(java.util.Collection<ParticipantTokenConfiguration>)
         */
        Builder participantTokenConfigurations(Consumer<ParticipantTokenConfiguration.Builder>... participantTokenConfigurations);

        /**
         * <p>
         * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
         * and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that
         * apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
         *        See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
         *        restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         *        constraints on tags beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Configuration object for individual participant recording, to attach to the new stage.
         * </p>
         * 
         * @param autoParticipantRecordingConfiguration
         *        Configuration object for individual participant recording, to attach to the new stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration);

        /**
         * <p>
         * Configuration object for individual participant recording, to attach to the new stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoParticipantRecordingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AutoParticipantRecordingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoParticipantRecordingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration)}.
         * 
         * @param autoParticipantRecordingConfiguration
         *        a consumer that will call methods on {@link AutoParticipantRecordingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration)
         */
        default Builder autoParticipantRecordingConfiguration(
                Consumer<AutoParticipantRecordingConfiguration.Builder> autoParticipantRecordingConfiguration) {
            return autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration.builder()
                    .applyMutation(autoParticipantRecordingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String name;

        private List<ParticipantTokenConfiguration> participantTokenConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageRequest model) {
            super(model);
            name(model.name);
            participantTokenConfigurations(model.participantTokenConfigurations);
            tags(model.tags);
            autoParticipantRecordingConfiguration(model.autoParticipantRecordingConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ParticipantTokenConfiguration.Builder> getParticipantTokenConfigurations() {
            List<ParticipantTokenConfiguration.Builder> result = ParticipantTokenConfigurationsCopier
                    .copyToBuilder(this.participantTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipantTokenConfigurations(
                Collection<ParticipantTokenConfiguration.BuilderImpl> participantTokenConfigurations) {
            this.participantTokenConfigurations = ParticipantTokenConfigurationsCopier
                    .copyFromBuilder(participantTokenConfigurations);
        }

        @Override
        public final Builder participantTokenConfigurations(
                Collection<ParticipantTokenConfiguration> participantTokenConfigurations) {
            this.participantTokenConfigurations = ParticipantTokenConfigurationsCopier.copy(participantTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokenConfigurations(ParticipantTokenConfiguration... participantTokenConfigurations) {
            participantTokenConfigurations(Arrays.asList(participantTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokenConfigurations(
                Consumer<ParticipantTokenConfiguration.Builder>... participantTokenConfigurations) {
            participantTokenConfigurations(Stream.of(participantTokenConfigurations)
                    .map(c -> ParticipantTokenConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final AutoParticipantRecordingConfiguration.Builder getAutoParticipantRecordingConfiguration() {
            return autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration.toBuilder() : null;
        }

        public final void setAutoParticipantRecordingConfiguration(
                AutoParticipantRecordingConfiguration.BuilderImpl autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder autoParticipantRecordingConfiguration(
                AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStageRequest build() {
            return new CreateStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
