/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisconnectParticipantRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<DisconnectParticipantRequest.Builder, DisconnectParticipantRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(DisconnectParticipantRequest::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(DisconnectParticipantRequest::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(DisconnectParticipantRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD,
            PARTICIPANT_ID_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stageArn;

    private final String participantId;

    private final String reason;

    private DisconnectParticipantRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.participantId = builder.participantId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * ARN of the stage to which the participant is attached.
     * </p>
     * 
     * @return ARN of the stage to which the participant is attached.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * Identifier of the participant to be disconnected. IVS assigns this; it is returned by
     * <a>CreateParticipantToken</a> (for streams using WebRTC ingest) or <a>CreateIngestConfiguration</a> (for streams
     * using RTMP ingest).
     * </p>
     * 
     * @return Identifier of the participant to be disconnected. IVS assigns this; it is returned by
     *         <a>CreateParticipantToken</a> (for streams using WebRTC ingest) or <a>CreateIngestConfiguration</a> (for
     *         streams using RTMP ingest).
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * Description of why this participant is being disconnected.
     * </p>
     * 
     * @return Description of why this participant is being disconnected.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectParticipantRequest)) {
            return false;
        }
        DisconnectParticipantRequest other = (DisconnectParticipantRequest) obj;
        return Objects.equals(stageArn(), other.stageArn()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisconnectParticipantRequest").add("StageArn", stageArn()).add("ParticipantId", participantId())
                .add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stageArn", STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisconnectParticipantRequest, T> g) {
        return obj -> g.apply((DisconnectParticipantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisconnectParticipantRequest> {
        /**
         * <p>
         * ARN of the stage to which the participant is attached.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage to which the participant is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * Identifier of the participant to be disconnected. IVS assigns this; it is returned by
         * <a>CreateParticipantToken</a> (for streams using WebRTC ingest) or <a>CreateIngestConfiguration</a> (for
         * streams using RTMP ingest).
         * </p>
         * 
         * @param participantId
         *        Identifier of the participant to be disconnected. IVS assigns this; it is returned by
         *        <a>CreateParticipantToken</a> (for streams using WebRTC ingest) or <a>CreateIngestConfiguration</a>
         *        (for streams using RTMP ingest).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * Description of why this participant is being disconnected.
         * </p>
         * 
         * @param reason
         *        Description of why this participant is being disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String stageArn;

        private String participantId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectParticipantRequest model) {
            super(model);
            stageArn(model.stageArn);
            participantId(model.participantId);
            reason(model.reason);
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisconnectParticipantRequest build() {
            return new DisconnectParticipantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
