/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStageResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<GetStageResponse.Builder, GetStageResponse> {
    private static final SdkField<Stage> STAGE_FIELD = SdkField.<Stage> builder(MarshallingType.SDK_POJO).memberName("stage")
            .getter(getter(GetStageResponse::stage)).setter(setter(Builder::stage)).constructor(Stage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Stage stage;

    private GetStageResponse(BuilderImpl builder) {
        super(builder);
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The stage that is returned.
     * </p>
     * 
     * @return The stage that is returned.
     */
    public final Stage stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStageResponse)) {
            return false;
        }
        GetStageResponse other = (GetStageResponse) obj;
        return Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStageResponse").add("Stage", stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStageResponse, T> g) {
        return obj -> g.apply((GetStageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStageResponse> {
        /**
         * <p>
         * The stage that is returned.
         * </p>
         * 
         * @param stage
         *        The stage that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * The stage that is returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link Stage.Builder} avoiding the need to
         * create one manually via {@link Stage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Stage.Builder#build()} is called immediately and its result is
         * passed to {@link #stage(Stage)}.
         * 
         * @param stage
         *        a consumer that will call methods on {@link Stage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stage(Stage)
         */
        default Builder stage(Consumer<Stage.Builder> stage) {
            return stage(Stage.builder().applyMutation(stage).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private Stage stage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStageResponse model) {
            super(model);
            stage(model.stage);
        }

        public final Stage.Builder getStage() {
            return stage != null ? stage.toBuilder() : null;
        }

        public final void setStage(Stage.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public GetStageResponse build() {
            return new GetStageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
