/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information of supported layouts for server-side composition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LayoutConfiguration.Builder, LayoutConfiguration> {
    private static final SdkField<GridConfiguration> GRID_FIELD = SdkField.<GridConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("grid").getter(getter(LayoutConfiguration::grid)).setter(setter(Builder::grid))
            .constructor(GridConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grid").build()).build();

    private static final SdkField<PipConfiguration> PIP_FIELD = SdkField.<PipConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("pip").getter(getter(LayoutConfiguration::pip)).setter(setter(Builder::pip))
            .constructor(PipConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pip").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRID_FIELD, PIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GridConfiguration grid;

    private final PipConfiguration pip;

    private LayoutConfiguration(BuilderImpl builder) {
        this.grid = builder.grid;
        this.pip = builder.pip;
    }

    /**
     * <p>
     * Configuration related to grid layout. Default: Grid layout.
     * </p>
     * 
     * @return Configuration related to grid layout. Default: Grid layout.
     */
    public final GridConfiguration grid() {
        return grid;
    }

    /**
     * <p>
     * Configuration related to PiP layout.
     * </p>
     * 
     * @return Configuration related to PiP layout.
     */
    public final PipConfiguration pip() {
        return pip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grid());
        hashCode = 31 * hashCode + Objects.hashCode(pip());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutConfiguration)) {
            return false;
        }
        LayoutConfiguration other = (LayoutConfiguration) obj;
        return Objects.equals(grid(), other.grid()) && Objects.equals(pip(), other.pip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayoutConfiguration").add("Grid", grid()).add("Pip", pip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grid":
            return Optional.ofNullable(clazz.cast(grid()));
        case "pip":
            return Optional.ofNullable(clazz.cast(pip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("grid", GRID_FIELD);
        map.put("pip", PIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayoutConfiguration, T> g) {
        return obj -> g.apply((LayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayoutConfiguration> {
        /**
         * <p>
         * Configuration related to grid layout. Default: Grid layout.
         * </p>
         * 
         * @param grid
         *        Configuration related to grid layout. Default: Grid layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grid(GridConfiguration grid);

        /**
         * <p>
         * Configuration related to grid layout. Default: Grid layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link GridConfiguration.Builder} avoiding the
         * need to create one manually via {@link GridConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GridConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #grid(GridConfiguration)}.
         * 
         * @param grid
         *        a consumer that will call methods on {@link GridConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grid(GridConfiguration)
         */
        default Builder grid(Consumer<GridConfiguration.Builder> grid) {
            return grid(GridConfiguration.builder().applyMutation(grid).build());
        }

        /**
         * <p>
         * Configuration related to PiP layout.
         * </p>
         * 
         * @param pip
         *        Configuration related to PiP layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pip(PipConfiguration pip);

        /**
         * <p>
         * Configuration related to PiP layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipConfiguration.Builder} avoiding the
         * need to create one manually via {@link PipConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #pip(PipConfiguration)}.
         * 
         * @param pip
         *        a consumer that will call methods on {@link PipConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pip(PipConfiguration)
         */
        default Builder pip(Consumer<PipConfiguration.Builder> pip) {
            return pip(PipConfiguration.builder().applyMutation(pip).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GridConfiguration grid;

        private PipConfiguration pip;

        private BuilderImpl() {
        }

        private BuilderImpl(LayoutConfiguration model) {
            grid(model.grid);
            pip(model.pip);
        }

        public final GridConfiguration.Builder getGrid() {
            return grid != null ? grid.toBuilder() : null;
        }

        public final void setGrid(GridConfiguration.BuilderImpl grid) {
            this.grid = grid != null ? grid.build() : null;
        }

        @Override
        public final Builder grid(GridConfiguration grid) {
            this.grid = grid;
            return this;
        }

        public final PipConfiguration.Builder getPip() {
            return pip != null ? pip.toBuilder() : null;
        }

        public final void setPip(PipConfiguration.BuilderImpl pip) {
            this.pip = pip != null ? pip.build() : null;
        }

        @Override
        public final Builder pip(PipConfiguration pip) {
            this.pip = pip;
            return this;
        }

        @Override
        public LayoutConfiguration build() {
            return new LayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
