/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCompositionsRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<ListCompositionsRequest.Builder, ListCompositionsRequest> {
    private static final SdkField<String> FILTER_BY_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterByStageArn").getter(getter(ListCompositionsRequest::filterByStageArn))
            .setter(setter(Builder::filterByStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByStageArn").build()).build();

    private static final SdkField<String> FILTER_BY_ENCODER_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("filterByEncoderConfigurationArn")
            .getter(getter(ListCompositionsRequest::filterByEncoderConfigurationArn))
            .setter(setter(Builder::filterByEncoderConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByEncoderConfigurationArn")
                    .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCompositionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCompositionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_STAGE_ARN_FIELD,
            FILTER_BY_ENCODER_CONFIGURATION_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String filterByStageArn;

    private final String filterByEncoderConfigurationArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListCompositionsRequest(BuilderImpl builder) {
        super(builder);
        this.filterByStageArn = builder.filterByStageArn;
        this.filterByEncoderConfigurationArn = builder.filterByEncoderConfigurationArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filters the Composition list to match the specified Stage ARN.
     * </p>
     * 
     * @return Filters the Composition list to match the specified Stage ARN.
     */
    public final String filterByStageArn() {
        return filterByStageArn;
    }

    /**
     * <p>
     * Filters the Composition list to match the specified EncoderConfiguration attached to at least one of its output.
     * </p>
     * 
     * @return Filters the Composition list to match the specified EncoderConfiguration attached to at least one of its
     *         output.
     */
    public final String filterByEncoderConfigurationArn() {
        return filterByEncoderConfigurationArn;
    }

    /**
     * <p>
     * The first Composition to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
     * </p>
     * 
     * @return The first Composition to retrieve. This is used for pagination; see the <code>nextToken</code> response
     *         field.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results to return. Default: 100.
     * </p>
     * 
     * @return Maximum number of results to return. Default: 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterByStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterByEncoderConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompositionsRequest)) {
            return false;
        }
        ListCompositionsRequest other = (ListCompositionsRequest) obj;
        return Objects.equals(filterByStageArn(), other.filterByStageArn())
                && Objects.equals(filterByEncoderConfigurationArn(), other.filterByEncoderConfigurationArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCompositionsRequest").add("FilterByStageArn", filterByStageArn())
                .add("FilterByEncoderConfigurationArn", filterByEncoderConfigurationArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterByStageArn":
            return Optional.ofNullable(clazz.cast(filterByStageArn()));
        case "filterByEncoderConfigurationArn":
            return Optional.ofNullable(clazz.cast(filterByEncoderConfigurationArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterByStageArn", FILTER_BY_STAGE_ARN_FIELD);
        map.put("filterByEncoderConfigurationArn", FILTER_BY_ENCODER_CONFIGURATION_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCompositionsRequest, T> g) {
        return obj -> g.apply((ListCompositionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCompositionsRequest> {
        /**
         * <p>
         * Filters the Composition list to match the specified Stage ARN.
         * </p>
         * 
         * @param filterByStageArn
         *        Filters the Composition list to match the specified Stage ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByStageArn(String filterByStageArn);

        /**
         * <p>
         * Filters the Composition list to match the specified EncoderConfiguration attached to at least one of its
         * output.
         * </p>
         * 
         * @param filterByEncoderConfigurationArn
         *        Filters the Composition list to match the specified EncoderConfiguration attached to at least one of
         *        its output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByEncoderConfigurationArn(String filterByEncoderConfigurationArn);

        /**
         * <p>
         * The first Composition to retrieve. This is used for pagination; see the <code>nextToken</code> response
         * field.
         * </p>
         * 
         * @param nextToken
         *        The first Composition to retrieve. This is used for pagination; see the <code>nextToken</code>
         *        response field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results to return. Default: 100.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return. Default: 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String filterByStageArn;

        private String filterByEncoderConfigurationArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompositionsRequest model) {
            super(model);
            filterByStageArn(model.filterByStageArn);
            filterByEncoderConfigurationArn(model.filterByEncoderConfigurationArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getFilterByStageArn() {
            return filterByStageArn;
        }

        public final void setFilterByStageArn(String filterByStageArn) {
            this.filterByStageArn = filterByStageArn;
        }

        @Override
        public final Builder filterByStageArn(String filterByStageArn) {
            this.filterByStageArn = filterByStageArn;
            return this;
        }

        public final String getFilterByEncoderConfigurationArn() {
            return filterByEncoderConfigurationArn;
        }

        public final void setFilterByEncoderConfigurationArn(String filterByEncoderConfigurationArn) {
            this.filterByEncoderConfigurationArn = filterByEncoderConfigurationArn;
        }

        @Override
        public final Builder filterByEncoderConfigurationArn(String filterByEncoderConfigurationArn) {
            this.filterByEncoderConfigurationArn = filterByEncoderConfigurationArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCompositionsRequest build() {
            return new ListCompositionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
