/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIngestConfigurationsRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<ListIngestConfigurationsRequest.Builder, ListIngestConfigurationsRequest> {
    private static final SdkField<String> FILTER_BY_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterByStageArn").getter(getter(ListIngestConfigurationsRequest::filterByStageArn))
            .setter(setter(Builder::filterByStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByStageArn").build()).build();

    private static final SdkField<String> FILTER_BY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterByState").getter(getter(ListIngestConfigurationsRequest::filterByStateAsString))
            .setter(setter(Builder::filterByState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByState").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIngestConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListIngestConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_STAGE_ARN_FIELD,
            FILTER_BY_STATE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String filterByStageArn;

    private final String filterByState;

    private final String nextToken;

    private final Integer maxResults;

    private ListIngestConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.filterByStageArn = builder.filterByStageArn;
        this.filterByState = builder.filterByState;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filters the response list to match the specified stage ARN. Only one filter (by stage ARN or by state) can be
     * used at a time.
     * </p>
     * 
     * @return Filters the response list to match the specified stage ARN. Only one filter (by stage ARN or by state)
     *         can be used at a time.
     */
    public final String filterByStageArn() {
        return filterByStageArn;
    }

    /**
     * <p>
     * Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can be used at
     * a time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterByState}
     * will return {@link IngestConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterByStateAsString}.
     * </p>
     * 
     * @return Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can be
     *         used at a time.
     * @see IngestConfigurationState
     */
    public final IngestConfigurationState filterByState() {
        return IngestConfigurationState.fromValue(filterByState);
    }

    /**
     * <p>
     * Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can be used at
     * a time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterByState}
     * will return {@link IngestConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterByStateAsString}.
     * </p>
     * 
     * @return Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can be
     *         used at a time.
     * @see IngestConfigurationState
     */
    public final String filterByStateAsString() {
        return filterByState;
    }

    /**
     * <p>
     * The first IngestConfiguration to retrieve. This is used for pagination; see the <code>nextToken</code> response
     * field.
     * </p>
     * 
     * @return The first IngestConfiguration to retrieve. This is used for pagination; see the <code>nextToken</code>
     *         response field.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results to return. Default: 50.
     * </p>
     * 
     * @return Maximum number of results to return. Default: 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterByStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterByStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestConfigurationsRequest)) {
            return false;
        }
        ListIngestConfigurationsRequest other = (ListIngestConfigurationsRequest) obj;
        return Objects.equals(filterByStageArn(), other.filterByStageArn())
                && Objects.equals(filterByStateAsString(), other.filterByStateAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIngestConfigurationsRequest").add("FilterByStageArn", filterByStageArn())
                .add("FilterByState", filterByStateAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterByStageArn":
            return Optional.ofNullable(clazz.cast(filterByStageArn()));
        case "filterByState":
            return Optional.ofNullable(clazz.cast(filterByStateAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterByStageArn", FILTER_BY_STAGE_ARN_FIELD);
        map.put("filterByState", FILTER_BY_STATE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestConfigurationsRequest, T> g) {
        return obj -> g.apply((ListIngestConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIngestConfigurationsRequest> {
        /**
         * <p>
         * Filters the response list to match the specified stage ARN. Only one filter (by stage ARN or by state) can be
         * used at a time.
         * </p>
         * 
         * @param filterByStageArn
         *        Filters the response list to match the specified stage ARN. Only one filter (by stage ARN or by state)
         *        can be used at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByStageArn(String filterByStageArn);

        /**
         * <p>
         * Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can be
         * used at a time.
         * </p>
         * 
         * @param filterByState
         *        Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can
         *        be used at a time.
         * @see IngestConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestConfigurationState
         */
        Builder filterByState(String filterByState);

        /**
         * <p>
         * Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can be
         * used at a time.
         * </p>
         * 
         * @param filterByState
         *        Filters the response list to match the specified state. Only one filter (by stage ARN or by state) can
         *        be used at a time.
         * @see IngestConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestConfigurationState
         */
        Builder filterByState(IngestConfigurationState filterByState);

        /**
         * <p>
         * The first IngestConfiguration to retrieve. This is used for pagination; see the <code>nextToken</code>
         * response field.
         * </p>
         * 
         * @param nextToken
         *        The first IngestConfiguration to retrieve. This is used for pagination; see the <code>nextToken</code>
         *        response field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results to return. Default: 50.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return. Default: 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String filterByStageArn;

        private String filterByState;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestConfigurationsRequest model) {
            super(model);
            filterByStageArn(model.filterByStageArn);
            filterByState(model.filterByState);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getFilterByStageArn() {
            return filterByStageArn;
        }

        public final void setFilterByStageArn(String filterByStageArn) {
            this.filterByStageArn = filterByStageArn;
        }

        @Override
        public final Builder filterByStageArn(String filterByStageArn) {
            this.filterByStageArn = filterByStageArn;
            return this;
        }

        public final String getFilterByState() {
            return filterByState;
        }

        public final void setFilterByState(String filterByState) {
            this.filterByState = filterByState;
        }

        @Override
        public final Builder filterByState(String filterByState) {
            this.filterByState = filterByState;
            return this;
        }

        @Override
        public final Builder filterByState(IngestConfigurationState filterByState) {
            this.filterByState(filterByState == null ? null : filterByState.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIngestConfigurationsRequest build() {
            return new ListIngestConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
