/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListParticipantsRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<ListParticipantsRequest.Builder, ListParticipantsRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(ListParticipantsRequest::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(ListParticipantsRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> FILTER_BY_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterByUserId").getter(getter(ListParticipantsRequest::filterByUserId))
            .setter(setter(Builder::filterByUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByUserId").build()).build();

    private static final SdkField<Boolean> FILTER_BY_PUBLISHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("filterByPublished").getter(getter(ListParticipantsRequest::filterByPublished))
            .setter(setter(Builder::filterByPublished))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByPublished").build()).build();

    private static final SdkField<String> FILTER_BY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterByState").getter(getter(ListParticipantsRequest::filterByStateAsString))
            .setter(setter(Builder::filterByState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByState").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListParticipantsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListParticipantsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> FILTER_BY_RECORDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterByRecordingState").getter(getter(ListParticipantsRequest::filterByRecordingStateAsString))
            .setter(setter(Builder::filterByRecordingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByRecordingState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD,
            SESSION_ID_FIELD, FILTER_BY_USER_ID_FIELD, FILTER_BY_PUBLISHED_FIELD, FILTER_BY_STATE_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTER_BY_RECORDING_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stageArn;

    private final String sessionId;

    private final String filterByUserId;

    private final Boolean filterByPublished;

    private final String filterByState;

    private final String nextToken;

    private final Integer maxResults;

    private final String filterByRecordingState;

    private ListParticipantsRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.sessionId = builder.sessionId;
        this.filterByUserId = builder.filterByUserId;
        this.filterByPublished = builder.filterByPublished;
        this.filterByState = builder.filterByState;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filterByRecordingState = builder.filterByRecordingState;
    }

    /**
     * <p>
     * Stage ARN.
     * </p>
     * 
     * @return Stage ARN.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * ID of the session within the stage.
     * </p>
     * 
     * @return ID of the session within the stage.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Filters the response list to match the specified user ID. Only one of <code>filterByUserId</code>,
     * <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be
     * provided per request. A <code>userId</code> is a customer-assigned name to help identify the token; this can be
     * used to link a participant to a user in the customer’s own systems.
     * </p>
     * 
     * @return Filters the response list to match the specified user ID. Only one of <code>filterByUserId</code>,
     *         <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be
     *         provided per request. A <code>userId</code> is a customer-assigned name to help identify the token; this
     *         can be used to link a participant to a user in the customer’s own systems.
     */
    public final String filterByUserId() {
        return filterByUserId;
    }

    /**
     * <p>
     * Filters the response list to only show participants who published during the stage session. Only one of
     * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     * <code>filterByRecordingState</code> can be provided per request.
     * </p>
     * 
     * @return Filters the response list to only show participants who published during the stage session. Only one of
     *         <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     *         <code>filterByRecordingState</code> can be provided per request.
     */
    public final Boolean filterByPublished() {
        return filterByPublished;
    }

    /**
     * <p>
     * Filters the response list to only show participants in the specified state. Only one of
     * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     * <code>filterByRecordingState</code> can be provided per request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterByState}
     * will return {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterByStateAsString}.
     * </p>
     * 
     * @return Filters the response list to only show participants in the specified state. Only one of
     *         <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     *         <code>filterByRecordingState</code> can be provided per request.
     * @see ParticipantState
     */
    public final ParticipantState filterByState() {
        return ParticipantState.fromValue(filterByState);
    }

    /**
     * <p>
     * Filters the response list to only show participants in the specified state. Only one of
     * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     * <code>filterByRecordingState</code> can be provided per request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterByState}
     * will return {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterByStateAsString}.
     * </p>
     * 
     * @return Filters the response list to only show participants in the specified state. Only one of
     *         <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     *         <code>filterByRecordingState</code> can be provided per request.
     * @see ParticipantState
     */
    public final String filterByStateAsString() {
        return filterByState;
    }

    /**
     * <p>
     * The first participant to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
     * </p>
     * 
     * @return The first participant to retrieve. This is used for pagination; see the <code>nextToken</code> response
     *         field.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results to return. Default: 50.
     * </p>
     * 
     * @return Maximum number of results to return. Default: 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters the response list to only show participants with the specified recording state. Only one of
     * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     * <code>filterByRecordingState</code> can be provided per request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #filterByRecordingState} will return
     * {@link ParticipantRecordingFilterByRecordingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #filterByRecordingStateAsString}.
     * </p>
     * 
     * @return Filters the response list to only show participants with the specified recording state. Only one of
     *         <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     *         <code>filterByRecordingState</code> can be provided per request.
     * @see ParticipantRecordingFilterByRecordingState
     */
    public final ParticipantRecordingFilterByRecordingState filterByRecordingState() {
        return ParticipantRecordingFilterByRecordingState.fromValue(filterByRecordingState);
    }

    /**
     * <p>
     * Filters the response list to only show participants with the specified recording state. Only one of
     * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     * <code>filterByRecordingState</code> can be provided per request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #filterByRecordingState} will return
     * {@link ParticipantRecordingFilterByRecordingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #filterByRecordingStateAsString}.
     * </p>
     * 
     * @return Filters the response list to only show participants with the specified recording state. Only one of
     *         <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
     *         <code>filterByRecordingState</code> can be provided per request.
     * @see ParticipantRecordingFilterByRecordingState
     */
    public final String filterByRecordingStateAsString() {
        return filterByRecordingState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(filterByUserId());
        hashCode = 31 * hashCode + Objects.hashCode(filterByPublished());
        hashCode = 31 * hashCode + Objects.hashCode(filterByStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filterByRecordingStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParticipantsRequest)) {
            return false;
        }
        ListParticipantsRequest other = (ListParticipantsRequest) obj;
        return Objects.equals(stageArn(), other.stageArn()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(filterByUserId(), other.filterByUserId())
                && Objects.equals(filterByPublished(), other.filterByPublished())
                && Objects.equals(filterByStateAsString(), other.filterByStateAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filterByRecordingStateAsString(), other.filterByRecordingStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListParticipantsRequest").add("StageArn", stageArn()).add("SessionId", sessionId())
                .add("FilterByUserId", filterByUserId()).add("FilterByPublished", filterByPublished())
                .add("FilterByState", filterByStateAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("FilterByRecordingState", filterByRecordingStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "filterByUserId":
            return Optional.ofNullable(clazz.cast(filterByUserId()));
        case "filterByPublished":
            return Optional.ofNullable(clazz.cast(filterByPublished()));
        case "filterByState":
            return Optional.ofNullable(clazz.cast(filterByStateAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filterByRecordingState":
            return Optional.ofNullable(clazz.cast(filterByRecordingStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stageArn", STAGE_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("filterByUserId", FILTER_BY_USER_ID_FIELD);
        map.put("filterByPublished", FILTER_BY_PUBLISHED_FIELD);
        map.put("filterByState", FILTER_BY_STATE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filterByRecordingState", FILTER_BY_RECORDING_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListParticipantsRequest, T> g) {
        return obj -> g.apply((ListParticipantsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListParticipantsRequest> {
        /**
         * <p>
         * Stage ARN.
         * </p>
         * 
         * @param stageArn
         *        Stage ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * ID of the session within the stage.
         * </p>
         * 
         * @param sessionId
         *        ID of the session within the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Filters the response list to match the specified user ID. Only one of <code>filterByUserId</code>,
         * <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be
         * provided per request. A <code>userId</code> is a customer-assigned name to help identify the token; this can
         * be used to link a participant to a user in the customer’s own systems.
         * </p>
         * 
         * @param filterByUserId
         *        Filters the response list to match the specified user ID. Only one of <code>filterByUserId</code>,
         *        <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can
         *        be provided per request. A <code>userId</code> is a customer-assigned name to help identify the token;
         *        this can be used to link a participant to a user in the customer’s own systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByUserId(String filterByUserId);

        /**
         * <p>
         * Filters the response list to only show participants who published during the stage session. Only one of
         * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         * <code>filterByRecordingState</code> can be provided per request.
         * </p>
         * 
         * @param filterByPublished
         *        Filters the response list to only show participants who published during the stage session. Only one
         *        of <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         *        <code>filterByRecordingState</code> can be provided per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByPublished(Boolean filterByPublished);

        /**
         * <p>
         * Filters the response list to only show participants in the specified state. Only one of
         * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         * <code>filterByRecordingState</code> can be provided per request.
         * </p>
         * 
         * @param filterByState
         *        Filters the response list to only show participants in the specified state. Only one of
         *        <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         *        <code>filterByRecordingState</code> can be provided per request.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder filterByState(String filterByState);

        /**
         * <p>
         * Filters the response list to only show participants in the specified state. Only one of
         * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         * <code>filterByRecordingState</code> can be provided per request.
         * </p>
         * 
         * @param filterByState
         *        Filters the response list to only show participants in the specified state. Only one of
         *        <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         *        <code>filterByRecordingState</code> can be provided per request.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder filterByState(ParticipantState filterByState);

        /**
         * <p>
         * The first participant to retrieve. This is used for pagination; see the <code>nextToken</code> response
         * field.
         * </p>
         * 
         * @param nextToken
         *        The first participant to retrieve. This is used for pagination; see the <code>nextToken</code>
         *        response field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results to return. Default: 50.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return. Default: 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the response list to only show participants with the specified recording state. Only one of
         * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         * <code>filterByRecordingState</code> can be provided per request.
         * </p>
         * 
         * @param filterByRecordingState
         *        Filters the response list to only show participants with the specified recording state. Only one of
         *        <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         *        <code>filterByRecordingState</code> can be provided per request.
         * @see ParticipantRecordingFilterByRecordingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRecordingFilterByRecordingState
         */
        Builder filterByRecordingState(String filterByRecordingState);

        /**
         * <p>
         * Filters the response list to only show participants with the specified recording state. Only one of
         * <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         * <code>filterByRecordingState</code> can be provided per request.
         * </p>
         * 
         * @param filterByRecordingState
         *        Filters the response list to only show participants with the specified recording state. Only one of
         *        <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or
         *        <code>filterByRecordingState</code> can be provided per request.
         * @see ParticipantRecordingFilterByRecordingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRecordingFilterByRecordingState
         */
        Builder filterByRecordingState(ParticipantRecordingFilterByRecordingState filterByRecordingState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String stageArn;

        private String sessionId;

        private String filterByUserId;

        private Boolean filterByPublished;

        private String filterByState;

        private String nextToken;

        private Integer maxResults;

        private String filterByRecordingState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParticipantsRequest model) {
            super(model);
            stageArn(model.stageArn);
            sessionId(model.sessionId);
            filterByUserId(model.filterByUserId);
            filterByPublished(model.filterByPublished);
            filterByState(model.filterByState);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filterByRecordingState(model.filterByRecordingState);
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getFilterByUserId() {
            return filterByUserId;
        }

        public final void setFilterByUserId(String filterByUserId) {
            this.filterByUserId = filterByUserId;
        }

        @Override
        public final Builder filterByUserId(String filterByUserId) {
            this.filterByUserId = filterByUserId;
            return this;
        }

        public final Boolean getFilterByPublished() {
            return filterByPublished;
        }

        public final void setFilterByPublished(Boolean filterByPublished) {
            this.filterByPublished = filterByPublished;
        }

        @Override
        public final Builder filterByPublished(Boolean filterByPublished) {
            this.filterByPublished = filterByPublished;
            return this;
        }

        public final String getFilterByState() {
            return filterByState;
        }

        public final void setFilterByState(String filterByState) {
            this.filterByState = filterByState;
        }

        @Override
        public final Builder filterByState(String filterByState) {
            this.filterByState = filterByState;
            return this;
        }

        @Override
        public final Builder filterByState(ParticipantState filterByState) {
            this.filterByState(filterByState == null ? null : filterByState.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getFilterByRecordingState() {
            return filterByRecordingState;
        }

        public final void setFilterByRecordingState(String filterByRecordingState) {
            this.filterByRecordingState = filterByRecordingState;
        }

        @Override
        public final Builder filterByRecordingState(String filterByRecordingState) {
            this.filterByRecordingState = filterByRecordingState;
            return this;
        }

        @Override
        public final Builder filterByRecordingState(ParticipantRecordingFilterByRecordingState filterByRecordingState) {
            this.filterByRecordingState(filterByRecordingState == null ? null : filterByRecordingState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListParticipantsRequest build() {
            return new ListParticipantsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
