/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stage implements SdkPojo, Serializable, ToCopyableBuilder<Stage.Builder, Stage> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Stage::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Stage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ACTIVE_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activeSessionId").getter(getter(Stage::activeSessionId)).setter(setter(Builder::activeSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeSessionId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Stage::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AutoParticipantRecordingConfiguration> AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD = SdkField
            .<AutoParticipantRecordingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("autoParticipantRecordingConfiguration")
            .getter(getter(Stage::autoParticipantRecordingConfiguration))
            .setter(setter(Builder::autoParticipantRecordingConfiguration))
            .constructor(AutoParticipantRecordingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("autoParticipantRecordingConfiguration").build()).build();

    private static final SdkField<StageEndpoints> ENDPOINTS_FIELD = SdkField.<StageEndpoints> builder(MarshallingType.SDK_POJO)
            .memberName("endpoints").getter(getter(Stage::endpoints)).setter(setter(Builder::endpoints))
            .constructor(StageEndpoints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            ACTIVE_SESSION_ID_FIELD, TAGS_FIELD, AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD, ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String activeSessionId;

    private final Map<String, String> tags;

    private final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

    private final StageEndpoints endpoints;

    private Stage(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.activeSessionId = builder.activeSessionId;
        this.tags = builder.tags;
        this.autoParticipantRecordingConfiguration = builder.autoParticipantRecordingConfiguration;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * Stage ARN.
     * </p>
     * 
     * @return Stage ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Stage name.
     * </p>
     * 
     * @return Stage name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ID of the active session within the stage.
     * </p>
     * 
     * @return ID of the active session within the stage.
     */
    public final String activeSessionId() {
        return activeSessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices and
     * strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that apply to
     * tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented
     * there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
     *         restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     *         on tags beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Configuration object for individual participant recording, attached to the stage.
     * </p>
     * 
     * @return Configuration object for individual participant recording, attached to the stage.
     */
    public final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration() {
        return autoParticipantRecordingConfiguration;
    }

    /**
     * <p>
     * Summary information about various endpoints for a stage.
     * </p>
     * 
     * @return Summary information about various endpoints for a stage.
     */
    public final StageEndpoints endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(activeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoParticipantRecordingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(endpoints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stage)) {
            return false;
        }
        Stage other = (Stage) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(activeSessionId(), other.activeSessionId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(autoParticipantRecordingConfiguration(), other.autoParticipantRecordingConfiguration())
                && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Stage").add("Arn", arn()).add("Name", name()).add("ActiveSessionId", activeSessionId())
                .add("Tags", hasTags() ? tags() : null)
                .add("AutoParticipantRecordingConfiguration", autoParticipantRecordingConfiguration())
                .add("Endpoints", endpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "activeSessionId":
            return Optional.ofNullable(clazz.cast(activeSessionId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "autoParticipantRecordingConfiguration":
            return Optional.ofNullable(clazz.cast(autoParticipantRecordingConfiguration()));
        case "endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("activeSessionId", ACTIVE_SESSION_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("autoParticipantRecordingConfiguration", AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Stage, T> g) {
        return obj -> g.apply((Stage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stage> {
        /**
         * <p>
         * Stage ARN.
         * </p>
         * 
         * @param arn
         *        Stage ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Stage name.
         * </p>
         * 
         * @param name
         *        Stage name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ID of the active session within the stage.
         * </p>
         * 
         * @param activeSessionId
         *        ID of the active session within the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeSessionId(String activeSessionId);

        /**
         * <p>
         * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
         * and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that
         * apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
         *        See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including
         *        restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         *        constraints on tags beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Configuration object for individual participant recording, attached to the stage.
         * </p>
         * 
         * @param autoParticipantRecordingConfiguration
         *        Configuration object for individual participant recording, attached to the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration);

        /**
         * <p>
         * Configuration object for individual participant recording, attached to the stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoParticipantRecordingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AutoParticipantRecordingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoParticipantRecordingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration)}.
         * 
         * @param autoParticipantRecordingConfiguration
         *        a consumer that will call methods on {@link AutoParticipantRecordingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration)
         */
        default Builder autoParticipantRecordingConfiguration(
                Consumer<AutoParticipantRecordingConfiguration.Builder> autoParticipantRecordingConfiguration) {
            return autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration.builder()
                    .applyMutation(autoParticipantRecordingConfiguration).build());
        }

        /**
         * <p>
         * Summary information about various endpoints for a stage.
         * </p>
         * 
         * @param endpoints
         *        Summary information about various endpoints for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(StageEndpoints endpoints);

        /**
         * <p>
         * Summary information about various endpoints for a stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageEndpoints.Builder} avoiding the need
         * to create one manually via {@link StageEndpoints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageEndpoints.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoints(StageEndpoints)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link StageEndpoints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(StageEndpoints)
         */
        default Builder endpoints(Consumer<StageEndpoints.Builder> endpoints) {
            return endpoints(StageEndpoints.builder().applyMutation(endpoints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String activeSessionId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

        private StageEndpoints endpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(Stage model) {
            arn(model.arn);
            name(model.name);
            activeSessionId(model.activeSessionId);
            tags(model.tags);
            autoParticipantRecordingConfiguration(model.autoParticipantRecordingConfiguration);
            endpoints(model.endpoints);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getActiveSessionId() {
            return activeSessionId;
        }

        public final void setActiveSessionId(String activeSessionId) {
            this.activeSessionId = activeSessionId;
        }

        @Override
        public final Builder activeSessionId(String activeSessionId) {
            this.activeSessionId = activeSessionId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final AutoParticipantRecordingConfiguration.Builder getAutoParticipantRecordingConfiguration() {
            return autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration.toBuilder() : null;
        }

        public final void setAutoParticipantRecordingConfiguration(
                AutoParticipantRecordingConfiguration.BuilderImpl autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder autoParticipantRecordingConfiguration(
                AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration;
            return this;
        }

        public final StageEndpoints.Builder getEndpoints() {
            return endpoints != null ? endpoints.toBuilder() : null;
        }

        public final void setEndpoints(StageEndpoints.BuilderImpl endpoints) {
            this.endpoints = endpoints != null ? endpoints.build() : null;
        }

        @Override
        public final Builder endpoints(StageEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        @Override
        public Stage build() {
            return new Stage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
