/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StageSummary;
import software.amazon.awssdk.services.ivsrealtime.model.StageSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStagesResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListStagesResponse> {
    private static final SdkField<List<StageSummary>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stages").getter(ListStagesResponse.getter(ListStagesResponse::stages)).setter(ListStagesResponse.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStagesResponse.getter(ListStagesResponse::nextToken)).setter(ListStagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStagesResponse.memberNameToFieldInitializer();
    private final List<StageSummary> stages;
    private final String nextToken;

    private ListStagesResponse(BuilderImpl builder) {
        super(builder);
        this.stages = builder.stages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<StageSummary> stages() {
        return this.stages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStagesResponse)) {
            return false;
        }
        ListStagesResponse other = (ListStagesResponse)((Object)obj);
        return this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStagesResponse").add("Stages", this.hasStages() ? this.stages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stages", STAGES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStagesResponse, T> g) {
        return obj -> g.apply((ListStagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private List<StageSummary> stages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStagesResponse model) {
            super(model);
            this.stages(model.stages);
            this.nextToken(model.nextToken);
        }

        public final List<StageSummary.Builder> getStages() {
            List<StageSummary.Builder> result = StageSummaryListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<StageSummary.BuilderImpl> stages) {
            this.stages = StageSummaryListCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<StageSummary> stages) {
            this.stages = StageSummaryListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageSummary ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<StageSummary.Builder> ... stages) {
            this.stages(Stream.of(stages).map(c -> (StageSummary)((StageSummary.Builder)StageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStagesResponse build() {
            return new ListStagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStagesResponse> {
        public Builder stages(Collection<StageSummary> var1);

        public Builder stages(StageSummary ... var1);

        public Builder stages(Consumer<StageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

