/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantRecordingState;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantState;
import software.amazon.awssdk.services.ivsrealtime.model.ReplicationState;
import software.amazon.awssdk.services.ivsrealtime.model.ReplicationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantSummary> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(ParticipantSummary.getter(ParticipantSummary::participantId)).setter(ParticipantSummary.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ParticipantSummary.getter(ParticipantSummary::userId)).setter(ParticipantSummary.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ParticipantSummary.getter(ParticipantSummary::stateAsString)).setter(ParticipantSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstJoinTime").getter(ParticipantSummary.getter(ParticipantSummary::firstJoinTime)).setter(ParticipantSummary.setter(Builder::firstJoinTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("published").getter(ParticipantSummary.getter(ParticipantSummary::published)).setter(ParticipantSummary.setter(Builder::published)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()}).build();
    private static final SdkField<String> RECORDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingState").getter(ParticipantSummary.getter(ParticipantSummary::recordingStateAsString)).setter(ParticipantSummary.setter(Builder::recordingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingState").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationType").getter(ParticipantSummary.getter(ParticipantSummary::replicationTypeAsString)).setter(ParticipantSummary.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationType").build()}).build();
    private static final SdkField<String> REPLICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationState").getter(ParticipantSummary.getter(ParticipantSummary::replicationStateAsString)).setter(ParticipantSummary.setter(Builder::replicationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationState").build()}).build();
    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceStageArn").getter(ParticipantSummary.getter(ParticipantSummary::sourceStageArn)).setter(ParticipantSummary.setter(Builder::sourceStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()}).build();
    private static final SdkField<String> SOURCE_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceSessionId").getter(ParticipantSummary.getter(ParticipantSummary::sourceSessionId)).setter(ParticipantSummary.setter(Builder::sourceSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD, USER_ID_FIELD, STATE_FIELD, FIRST_JOIN_TIME_FIELD, PUBLISHED_FIELD, RECORDING_STATE_FIELD, REPLICATION_TYPE_FIELD, REPLICATION_STATE_FIELD, SOURCE_STAGE_ARN_FIELD, SOURCE_SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipantSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String participantId;
    private final String userId;
    private final String state;
    private final Instant firstJoinTime;
    private final Boolean published;
    private final String recordingState;
    private final String replicationType;
    private final String replicationState;
    private final String sourceStageArn;
    private final String sourceSessionId;

    private ParticipantSummary(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.userId = builder.userId;
        this.state = builder.state;
        this.firstJoinTime = builder.firstJoinTime;
        this.published = builder.published;
        this.recordingState = builder.recordingState;
        this.replicationType = builder.replicationType;
        this.replicationState = builder.replicationState;
        this.sourceStageArn = builder.sourceStageArn;
        this.sourceSessionId = builder.sourceSessionId;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String userId() {
        return this.userId;
    }

    public final ParticipantState state() {
        return ParticipantState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant firstJoinTime() {
        return this.firstJoinTime;
    }

    public final Boolean published() {
        return this.published;
    }

    public final ParticipantRecordingState recordingState() {
        return ParticipantRecordingState.fromValue(this.recordingState);
    }

    public final String recordingStateAsString() {
        return this.recordingState;
    }

    public final ReplicationType replicationType() {
        return ReplicationType.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final ReplicationState replicationState() {
        return ReplicationState.fromValue(this.replicationState);
    }

    public final String replicationStateAsString() {
        return this.replicationState;
    }

    public final String sourceStageArn() {
        return this.sourceStageArn;
    }

    public final String sourceSessionId() {
        return this.sourceSessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.published());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantSummary)) {
            return false;
        }
        ParticipantSummary other = (ParticipantSummary)obj;
        return Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.firstJoinTime(), other.firstJoinTime()) && Objects.equals(this.published(), other.published()) && Objects.equals(this.recordingStateAsString(), other.recordingStateAsString()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.replicationStateAsString(), other.replicationStateAsString()) && Objects.equals(this.sourceStageArn(), other.sourceStageArn()) && Objects.equals(this.sourceSessionId(), other.sourceSessionId());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantSummary").add("ParticipantId", (Object)this.participantId()).add("UserId", (Object)this.userId()).add("State", (Object)this.stateAsString()).add("FirstJoinTime", (Object)this.firstJoinTime()).add("Published", (Object)this.published()).add("RecordingState", (Object)this.recordingStateAsString()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("ReplicationState", (Object)this.replicationStateAsString()).add("SourceStageArn", (Object)this.sourceStageArn()).add("SourceSessionId", (Object)this.sourceSessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "firstJoinTime": {
                return Optional.ofNullable(clazz.cast(this.firstJoinTime()));
            }
            case "published": {
                return Optional.ofNullable(clazz.cast(this.published()));
            }
            case "recordingState": {
                return Optional.ofNullable(clazz.cast(this.recordingStateAsString()));
            }
            case "replicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "replicationState": {
                return Optional.ofNullable(clazz.cast(this.replicationStateAsString()));
            }
            case "sourceStageArn": {
                return Optional.ofNullable(clazz.cast(this.sourceStageArn()));
            }
            case "sourceSessionId": {
                return Optional.ofNullable(clazz.cast(this.sourceSessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("firstJoinTime", FIRST_JOIN_TIME_FIELD);
        map.put("published", PUBLISHED_FIELD);
        map.put("recordingState", RECORDING_STATE_FIELD);
        map.put("replicationType", REPLICATION_TYPE_FIELD);
        map.put("replicationState", REPLICATION_STATE_FIELD);
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("sourceSessionId", SOURCE_SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantSummary, T> g) {
        return obj -> g.apply((ParticipantSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantId;
        private String userId;
        private String state;
        private Instant firstJoinTime;
        private Boolean published;
        private String recordingState;
        private String replicationType;
        private String replicationState;
        private String sourceStageArn;
        private String sourceSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantSummary model) {
            this.participantId(model.participantId);
            this.userId(model.userId);
            this.state(model.state);
            this.firstJoinTime(model.firstJoinTime);
            this.published(model.published);
            this.recordingState(model.recordingState);
            this.replicationType(model.replicationType);
            this.replicationState(model.replicationState);
            this.sourceStageArn(model.sourceStageArn);
            this.sourceSessionId(model.sourceSessionId);
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getFirstJoinTime() {
            return this.firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final Boolean getPublished() {
            return this.published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getRecordingState() {
            return this.recordingState;
        }

        public final void setRecordingState(String recordingState) {
            this.recordingState = recordingState;
        }

        @Override
        public final Builder recordingState(String recordingState) {
            this.recordingState = recordingState;
            return this;
        }

        @Override
        public final Builder recordingState(ParticipantRecordingState recordingState) {
            this.recordingState(recordingState == null ? null : recordingState.toString());
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(ReplicationType replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getReplicationState() {
            return this.replicationState;
        }

        public final void setReplicationState(String replicationState) {
            this.replicationState = replicationState;
        }

        @Override
        public final Builder replicationState(String replicationState) {
            this.replicationState = replicationState;
            return this;
        }

        @Override
        public final Builder replicationState(ReplicationState replicationState) {
            this.replicationState(replicationState == null ? null : replicationState.toString());
            return this;
        }

        public final String getSourceStageArn() {
            return this.sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getSourceSessionId() {
            return this.sourceSessionId;
        }

        public final void setSourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
        }

        @Override
        public final Builder sourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
            return this;
        }

        public ParticipantSummary build() {
            return new ParticipantSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantSummary> {
        public Builder participantId(String var1);

        public Builder userId(String var1);

        public Builder state(String var1);

        public Builder state(ParticipantState var1);

        public Builder firstJoinTime(Instant var1);

        public Builder published(Boolean var1);

        public Builder recordingState(String var1);

        public Builder recordingState(ParticipantRecordingState var1);

        public Builder replicationType(String var1);

        public Builder replicationType(ReplicationType var1);

        public Builder replicationState(String var1);

        public Builder replicationState(ReplicationState var1);

        public Builder sourceStageArn(String var1);

        public Builder sourceSessionId(String var1);
    }
}

