/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a configuration for individual participant recording.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoParticipantRecordingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoParticipantRecordingConfiguration.Builder, AutoParticipantRecordingConfiguration> {
    private static final SdkField<String> STORAGE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageConfigurationArn").getter(getter(AutoParticipantRecordingConfiguration::storageConfigurationArn))
            .setter(setter(Builder::storageConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurationArn").build())
            .build();

    private static final SdkField<List<String>> MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("mediaTypes")
            .getter(getter(AutoParticipantRecordingConfiguration::mediaTypesAsStrings))
            .setter(setter(Builder::mediaTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ParticipantThumbnailConfiguration> THUMBNAIL_CONFIGURATION_FIELD = SdkField
            .<ParticipantThumbnailConfiguration> builder(MarshallingType.SDK_POJO).memberName("thumbnailConfiguration")
            .getter(getter(AutoParticipantRecordingConfiguration::thumbnailConfiguration))
            .setter(setter(Builder::thumbnailConfiguration)).constructor(ParticipantThumbnailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfiguration").build())
            .build();

    private static final SdkField<Integer> RECORDING_RECONNECT_WINDOW_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recordingReconnectWindowSeconds")
            .getter(getter(AutoParticipantRecordingConfiguration::recordingReconnectWindowSeconds))
            .setter(setter(Builder::recordingReconnectWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingReconnectWindowSeconds")
                    .build()).build();

    private static final SdkField<ParticipantRecordingHlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField
            .<ParticipantRecordingHlsConfiguration> builder(MarshallingType.SDK_POJO).memberName("hlsConfiguration")
            .getter(getter(AutoParticipantRecordingConfiguration::hlsConfiguration)).setter(setter(Builder::hlsConfiguration))
            .constructor(ParticipantRecordingHlsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsConfiguration").build()).build();

    private static final SdkField<Boolean> RECORD_PARTICIPANT_REPLICAS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("recordParticipantReplicas")
            .getter(getter(AutoParticipantRecordingConfiguration::recordParticipantReplicas))
            .setter(setter(Builder::recordParticipantReplicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordParticipantReplicas").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_CONFIGURATION_ARN_FIELD, MEDIA_TYPES_FIELD, THUMBNAIL_CONFIGURATION_FIELD,
            RECORDING_RECONNECT_WINDOW_SECONDS_FIELD, HLS_CONFIGURATION_FIELD, RECORD_PARTICIPANT_REPLICAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storageConfigurationArn;

    private final List<String> mediaTypes;

    private final ParticipantThumbnailConfiguration thumbnailConfiguration;

    private final Integer recordingReconnectWindowSeconds;

    private final ParticipantRecordingHlsConfiguration hlsConfiguration;

    private final Boolean recordParticipantReplicas;

    private AutoParticipantRecordingConfiguration(BuilderImpl builder) {
        this.storageConfigurationArn = builder.storageConfigurationArn;
        this.mediaTypes = builder.mediaTypes;
        this.thumbnailConfiguration = builder.thumbnailConfiguration;
        this.recordingReconnectWindowSeconds = builder.recordingReconnectWindowSeconds;
        this.hlsConfiguration = builder.hlsConfiguration;
        this.recordParticipantReplicas = builder.recordParticipantReplicas;
    }

    /**
     * <p>
     * ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
     * <code>""</code> (empty string, no storage configuration is specified). Individual participant recording cannot be
     * started unless a storage configuration is specified, when a <a>Stage</a> is created or updated. To disable
     * individual participant recording, set this to <code>""</code>; other fields in this object will get reset to
     * their defaults when sending <code>""</code>.
     * </p>
     * 
     * @return ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
     *         <code>""</code> (empty string, no storage configuration is specified). Individual participant recording
     *         cannot be started unless a storage configuration is specified, when a <a>Stage</a> is created or updated.
     *         To disable individual participant recording, set this to <code>""</code>; other fields in this object
     *         will get reset to their defaults when sending <code>""</code>.
     */
    public final String storageConfigurationArn() {
        return storageConfigurationArn;
    }

    /**
     * <p>
     * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaTypes} method.
     * </p>
     * 
     * @return Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     */
    public final List<ParticipantRecordingMediaType> mediaTypes() {
        return ParticipantRecordingMediaTypeListCopier.copyStringToEnum(mediaTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMediaTypes() {
        return mediaTypes != null && !(mediaTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaTypes} method.
     * </p>
     * 
     * @return Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
     */
    public final List<String> mediaTypesAsStrings() {
        return mediaTypes;
    }

    /**
     * <p>
     * A complex type that allows you to enable/disable the recording of thumbnails for individual participant recording
     * and modify the interval at which thumbnails are generated for the live session.
     * </p>
     * 
     * @return A complex type that allows you to enable/disable the recording of thumbnails for individual participant
     *         recording and modify the interval at which thumbnails are generated for the live session.
     */
    public final ParticipantThumbnailConfiguration thumbnailConfiguration() {
        return thumbnailConfiguration;
    }

    /**
     * <p>
     * If a stage publisher disconnects and then reconnects within the specified interval, the multiple recordings will
     * be considered a single recording and merged together.
     * </p>
     * <p>
     * The default value is 0, which disables merging.
     * </p>
     * 
     * @return If a stage publisher disconnects and then reconnects within the specified interval, the multiple
     *         recordings will be considered a single recording and merged together.</p>
     *         <p>
     *         The default value is 0, which disables merging.
     */
    public final Integer recordingReconnectWindowSeconds() {
        return recordingReconnectWindowSeconds;
    }

    /**
     * <p>
     * HLS configuration object for individual participant recording.
     * </p>
     * 
     * @return HLS configuration object for individual participant recording.
     */
    public final ParticipantRecordingHlsConfiguration hlsConfiguration() {
        return hlsConfiguration;
    }

    /**
     * <p>
     * Optional field to disable replica participant recording. If this is set to <code>false</code> when a participant
     * is a replica, replica participants are not recorded. Default: <code>true</code>.
     * </p>
     * 
     * @return Optional field to disable replica participant recording. If this is set to <code>false</code> when a
     *         participant is a replica, replica participants are not recorded. Default: <code>true</code>.
     */
    public final Boolean recordParticipantReplicas() {
        return recordParticipantReplicas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaTypes() ? mediaTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(recordingReconnectWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(recordParticipantReplicas());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoParticipantRecordingConfiguration)) {
            return false;
        }
        AutoParticipantRecordingConfiguration other = (AutoParticipantRecordingConfiguration) obj;
        return Objects.equals(storageConfigurationArn(), other.storageConfigurationArn())
                && hasMediaTypes() == other.hasMediaTypes() && Objects.equals(mediaTypesAsStrings(), other.mediaTypesAsStrings())
                && Objects.equals(thumbnailConfiguration(), other.thumbnailConfiguration())
                && Objects.equals(recordingReconnectWindowSeconds(), other.recordingReconnectWindowSeconds())
                && Objects.equals(hlsConfiguration(), other.hlsConfiguration())
                && Objects.equals(recordParticipantReplicas(), other.recordParticipantReplicas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoParticipantRecordingConfiguration")
                .add("StorageConfigurationArn", storageConfigurationArn())
                .add("MediaTypes", hasMediaTypes() ? mediaTypesAsStrings() : null)
                .add("ThumbnailConfiguration", thumbnailConfiguration())
                .add("RecordingReconnectWindowSeconds", recordingReconnectWindowSeconds())
                .add("HlsConfiguration", hlsConfiguration()).add("RecordParticipantReplicas", recordParticipantReplicas())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageConfigurationArn":
            return Optional.ofNullable(clazz.cast(storageConfigurationArn()));
        case "mediaTypes":
            return Optional.ofNullable(clazz.cast(mediaTypesAsStrings()));
        case "thumbnailConfiguration":
            return Optional.ofNullable(clazz.cast(thumbnailConfiguration()));
        case "recordingReconnectWindowSeconds":
            return Optional.ofNullable(clazz.cast(recordingReconnectWindowSeconds()));
        case "hlsConfiguration":
            return Optional.ofNullable(clazz.cast(hlsConfiguration()));
        case "recordParticipantReplicas":
            return Optional.ofNullable(clazz.cast(recordParticipantReplicas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageConfigurationArn", STORAGE_CONFIGURATION_ARN_FIELD);
        map.put("mediaTypes", MEDIA_TYPES_FIELD);
        map.put("thumbnailConfiguration", THUMBNAIL_CONFIGURATION_FIELD);
        map.put("recordingReconnectWindowSeconds", RECORDING_RECONNECT_WINDOW_SECONDS_FIELD);
        map.put("hlsConfiguration", HLS_CONFIGURATION_FIELD);
        map.put("recordParticipantReplicas", RECORD_PARTICIPANT_REPLICAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoParticipantRecordingConfiguration, T> g) {
        return obj -> g.apply((AutoParticipantRecordingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoParticipantRecordingConfiguration> {
        /**
         * <p>
         * ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
         * <code>""</code> (empty string, no storage configuration is specified). Individual participant recording
         * cannot be started unless a storage configuration is specified, when a <a>Stage</a> is created or updated. To
         * disable individual participant recording, set this to <code>""</code>; other fields in this object will get
         * reset to their defaults when sending <code>""</code>.
         * </p>
         * 
         * @param storageConfigurationArn
         *        ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default:
         *        <code>""</code> (empty string, no storage configuration is specified). Individual participant
         *        recording cannot be started unless a storage configuration is specified, when a <a>Stage</a> is
         *        created or updated. To disable individual participant recording, set this to <code>""</code>; other
         *        fields in this object will get reset to their defaults when sending <code>""</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurationArn(String storageConfigurationArn);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypesWithStrings(Collection<String> mediaTypes);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypesWithStrings(String... mediaTypes);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypes(Collection<ParticipantRecordingMediaType> mediaTypes);

        /**
         * <p>
         * Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * </p>
         * 
         * @param mediaTypes
         *        Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaTypes(ParticipantRecordingMediaType... mediaTypes);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for individual participant
         * recording and modify the interval at which thumbnails are generated for the live session.
         * </p>
         * 
         * @param thumbnailConfiguration
         *        A complex type that allows you to enable/disable the recording of thumbnails for individual
         *        participant recording and modify the interval at which thumbnails are generated for the live session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfiguration(ParticipantThumbnailConfiguration thumbnailConfiguration);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for individual participant
         * recording and modify the interval at which thumbnails are generated for the live session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ParticipantThumbnailConfiguration.Builder} avoiding the need to create one manually via
         * {@link ParticipantThumbnailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantThumbnailConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #thumbnailConfiguration(ParticipantThumbnailConfiguration)}.
         * 
         * @param thumbnailConfiguration
         *        a consumer that will call methods on {@link ParticipantThumbnailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailConfiguration(ParticipantThumbnailConfiguration)
         */
        default Builder thumbnailConfiguration(Consumer<ParticipantThumbnailConfiguration.Builder> thumbnailConfiguration) {
            return thumbnailConfiguration(ParticipantThumbnailConfiguration.builder().applyMutation(thumbnailConfiguration)
                    .build());
        }

        /**
         * <p>
         * If a stage publisher disconnects and then reconnects within the specified interval, the multiple recordings
         * will be considered a single recording and merged together.
         * </p>
         * <p>
         * The default value is 0, which disables merging.
         * </p>
         * 
         * @param recordingReconnectWindowSeconds
         *        If a stage publisher disconnects and then reconnects within the specified interval, the multiple
         *        recordings will be considered a single recording and merged together.</p>
         *        <p>
         *        The default value is 0, which disables merging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds);

        /**
         * <p>
         * HLS configuration object for individual participant recording.
         * </p>
         * 
         * @param hlsConfiguration
         *        HLS configuration object for individual participant recording.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsConfiguration(ParticipantRecordingHlsConfiguration hlsConfiguration);

        /**
         * <p>
         * HLS configuration object for individual participant recording.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ParticipantRecordingHlsConfiguration.Builder} avoiding the need to create one manually via
         * {@link ParticipantRecordingHlsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantRecordingHlsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #hlsConfiguration(ParticipantRecordingHlsConfiguration)}.
         * 
         * @param hlsConfiguration
         *        a consumer that will call methods on {@link ParticipantRecordingHlsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsConfiguration(ParticipantRecordingHlsConfiguration)
         */
        default Builder hlsConfiguration(Consumer<ParticipantRecordingHlsConfiguration.Builder> hlsConfiguration) {
            return hlsConfiguration(ParticipantRecordingHlsConfiguration.builder().applyMutation(hlsConfiguration).build());
        }

        /**
         * <p>
         * Optional field to disable replica participant recording. If this is set to <code>false</code> when a
         * participant is a replica, replica participants are not recorded. Default: <code>true</code>.
         * </p>
         * 
         * @param recordParticipantReplicas
         *        Optional field to disable replica participant recording. If this is set to <code>false</code> when a
         *        participant is a replica, replica participants are not recorded. Default: <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordParticipantReplicas(Boolean recordParticipantReplicas);
    }

    static final class BuilderImpl implements Builder {
        private String storageConfigurationArn;

        private List<String> mediaTypes = DefaultSdkAutoConstructList.getInstance();

        private ParticipantThumbnailConfiguration thumbnailConfiguration;

        private Integer recordingReconnectWindowSeconds;

        private ParticipantRecordingHlsConfiguration hlsConfiguration;

        private Boolean recordParticipantReplicas;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoParticipantRecordingConfiguration model) {
            storageConfigurationArn(model.storageConfigurationArn);
            mediaTypesWithStrings(model.mediaTypes);
            thumbnailConfiguration(model.thumbnailConfiguration);
            recordingReconnectWindowSeconds(model.recordingReconnectWindowSeconds);
            hlsConfiguration(model.hlsConfiguration);
            recordParticipantReplicas(model.recordParticipantReplicas);
        }

        public final String getStorageConfigurationArn() {
            return storageConfigurationArn;
        }

        public final void setStorageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
        }

        @Override
        public final Builder storageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
            return this;
        }

        public final Collection<String> getMediaTypes() {
            if (mediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return mediaTypes;
        }

        public final void setMediaTypes(Collection<String> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copy(mediaTypes);
        }

        @Override
        public final Builder mediaTypesWithStrings(Collection<String> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copy(mediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaTypesWithStrings(String... mediaTypes) {
            mediaTypesWithStrings(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public final Builder mediaTypes(Collection<ParticipantRecordingMediaType> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copyEnumToString(mediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaTypes(ParticipantRecordingMediaType... mediaTypes) {
            mediaTypes(Arrays.asList(mediaTypes));
            return this;
        }

        public final ParticipantThumbnailConfiguration.Builder getThumbnailConfiguration() {
            return thumbnailConfiguration != null ? thumbnailConfiguration.toBuilder() : null;
        }

        public final void setThumbnailConfiguration(ParticipantThumbnailConfiguration.BuilderImpl thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration != null ? thumbnailConfiguration.build() : null;
        }

        @Override
        public final Builder thumbnailConfiguration(ParticipantThumbnailConfiguration thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        public final Integer getRecordingReconnectWindowSeconds() {
            return recordingReconnectWindowSeconds;
        }

        public final void setRecordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
        }

        @Override
        public final Builder recordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
            return this;
        }

        public final ParticipantRecordingHlsConfiguration.Builder getHlsConfiguration() {
            return hlsConfiguration != null ? hlsConfiguration.toBuilder() : null;
        }

        public final void setHlsConfiguration(ParticipantRecordingHlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        @Override
        public final Builder hlsConfiguration(ParticipantRecordingHlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final Boolean getRecordParticipantReplicas() {
            return recordParticipantReplicas;
        }

        public final void setRecordParticipantReplicas(Boolean recordParticipantReplicas) {
            this.recordParticipantReplicas = recordParticipantReplicas;
        }

        @Override
        public final Builder recordParticipantReplicas(Boolean recordParticipantReplicas) {
            this.recordParticipantReplicas = recordParticipantReplicas;
            return this;
        }

        @Override
        public AutoParticipantRecordingConfiguration build() {
            return new AutoParticipantRecordingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
