/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStageResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<CreateStageResponse.Builder, CreateStageResponse> {
    private static final SdkField<Stage> STAGE_FIELD = SdkField.<Stage> builder(MarshallingType.SDK_POJO).memberName("stage")
            .getter(getter(CreateStageResponse::stage)).setter(setter(Builder::stage)).constructor(Stage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<List<ParticipantToken>> PARTICIPANT_TOKENS_FIELD = SdkField
            .<List<ParticipantToken>> builder(MarshallingType.LIST)
            .memberName("participantTokens")
            .getter(getter(CreateStageResponse::participantTokens))
            .setter(setter(Builder::participantTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantTokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParticipantToken> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParticipantToken::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD,
            PARTICIPANT_TOKENS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Stage stage;

    private final List<ParticipantToken> participantTokens;

    private CreateStageResponse(BuilderImpl builder) {
        super(builder);
        this.stage = builder.stage;
        this.participantTokens = builder.participantTokens;
    }

    /**
     * <p>
     * The stage that was created.
     * </p>
     * 
     * @return The stage that was created.
     */
    public final Stage stage() {
        return stage;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParticipantTokens property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParticipantTokens() {
        return participantTokens != null && !(participantTokens instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Participant tokens attached to the stage. These correspond to the <code>participants</code> in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParticipantTokens} method.
     * </p>
     * 
     * @return Participant tokens attached to the stage. These correspond to the <code>participants</code> in the
     *         request.
     */
    public final List<ParticipantToken> participantTokens() {
        return participantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(hasParticipantTokens() ? participantTokens() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageResponse)) {
            return false;
        }
        CreateStageResponse other = (CreateStageResponse) obj;
        return Objects.equals(stage(), other.stage()) && hasParticipantTokens() == other.hasParticipantTokens()
                && Objects.equals(participantTokens(), other.participantTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStageResponse").add("Stage", stage())
                .add("ParticipantTokens", hasParticipantTokens() ? participantTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "participantTokens":
            return Optional.ofNullable(clazz.cast(participantTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stage", STAGE_FIELD);
        map.put("participantTokens", PARTICIPANT_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStageResponse, T> g) {
        return obj -> g.apply((CreateStageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStageResponse> {
        /**
         * <p>
         * The stage that was created.
         * </p>
         * 
         * @param stage
         *        The stage that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * The stage that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Stage.Builder} avoiding the need to
         * create one manually via {@link Stage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Stage.Builder#build()} is called immediately and its result is
         * passed to {@link #stage(Stage)}.
         * 
         * @param stage
         *        a consumer that will call methods on {@link Stage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stage(Stage)
         */
        default Builder stage(Consumer<Stage.Builder> stage) {
            return stage(Stage.builder().applyMutation(stage).build());
        }

        /**
         * <p>
         * Participant tokens attached to the stage. These correspond to the <code>participants</code> in the request.
         * </p>
         * 
         * @param participantTokens
         *        Participant tokens attached to the stage. These correspond to the <code>participants</code> in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantTokens(Collection<ParticipantToken> participantTokens);

        /**
         * <p>
         * Participant tokens attached to the stage. These correspond to the <code>participants</code> in the request.
         * </p>
         * 
         * @param participantTokens
         *        Participant tokens attached to the stage. These correspond to the <code>participants</code> in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantTokens(ParticipantToken... participantTokens);

        /**
         * <p>
         * Participant tokens attached to the stage. These correspond to the <code>participants</code> in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken.Builder#build()} is called
         * immediately and its result is passed to {@link #participantTokens(List<ParticipantToken>)}.
         * 
         * @param participantTokens
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantTokens(java.util.Collection<ParticipantToken>)
         */
        Builder participantTokens(Consumer<ParticipantToken.Builder>... participantTokens);
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private Stage stage;

        private List<ParticipantToken> participantTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageResponse model) {
            super(model);
            stage(model.stage);
            participantTokens(model.participantTokens);
        }

        public final Stage.Builder getStage() {
            return stage != null ? stage.toBuilder() : null;
        }

        public final void setStage(Stage.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public final List<ParticipantToken.Builder> getParticipantTokens() {
            List<ParticipantToken.Builder> result = ParticipantTokenListCopier.copyToBuilder(this.participantTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipantTokens(Collection<ParticipantToken.BuilderImpl> participantTokens) {
            this.participantTokens = ParticipantTokenListCopier.copyFromBuilder(participantTokens);
        }

        @Override
        public final Builder participantTokens(Collection<ParticipantToken> participantTokens) {
            this.participantTokens = ParticipantTokenListCopier.copy(participantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokens(ParticipantToken... participantTokens) {
            participantTokens(Arrays.asList(participantTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokens(Consumer<ParticipantToken.Builder>... participantTokens) {
            participantTokens(Stream.of(participantTokens).map(c -> ParticipantToken.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateStageResponse build() {
            return new CreateStageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
