/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParticipantResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<GetParticipantResponse.Builder, GetParticipantResponse> {
    private static final SdkField<Participant> PARTICIPANT_FIELD = SdkField.<Participant> builder(MarshallingType.SDK_POJO)
            .memberName("participant").getter(getter(GetParticipantResponse::participant)).setter(setter(Builder::participant))
            .constructor(Participant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Participant participant;

    private GetParticipantResponse(BuilderImpl builder) {
        super(builder);
        this.participant = builder.participant;
    }

    /**
     * <p>
     * The participant that is returned.
     * </p>
     * 
     * @return The participant that is returned.
     */
    public final Participant participant() {
        return participant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(participant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParticipantResponse)) {
            return false;
        }
        GetParticipantResponse other = (GetParticipantResponse) obj;
        return Objects.equals(participant(), other.participant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetParticipantResponse").add("Participant", participant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "participant":
            return Optional.ofNullable(clazz.cast(participant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("participant", PARTICIPANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetParticipantResponse, T> g) {
        return obj -> g.apply((GetParticipantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetParticipantResponse> {
        /**
         * <p>
         * The participant that is returned.
         * </p>
         * 
         * @param participant
         *        The participant that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participant(Participant participant);

        /**
         * <p>
         * The participant that is returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link Participant.Builder} avoiding the need to
         * create one manually via {@link Participant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Participant.Builder#build()} is called immediately and its result
         * is passed to {@link #participant(Participant)}.
         * 
         * @param participant
         *        a consumer that will call methods on {@link Participant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participant(Participant)
         */
        default Builder participant(Consumer<Participant.Builder> participant) {
            return participant(Participant.builder().applyMutation(participant).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private Participant participant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParticipantResponse model) {
            super(model);
            participant(model.participant);
        }

        public final Participant.Builder getParticipant() {
            return participant != null ? participant.toBuilder() : null;
        }

        public final void setParticipant(Participant.BuilderImpl participant) {
            this.participant = participant != null ? participant.build() : null;
        }

        @Override
        public final Builder participant(Participant participant) {
            this.participant = participant;
            return this;
        }

        @Override
        public GetParticipantResponse build() {
            return new GetParticipantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
